#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

Texture2D g_depth : register(t0);
Texture2D g_normal : register(t1);
SamplerState g_sam_linear : register(s3);

float3 GetViewPos(float2 uv)
{
  float depth = g_depth.Sample(g_sam_linear, uv).x;
  float3 pos = ScreenToView( float4(uv, depth, 1.0f)).xyz;
  return pos;
}

float Falloff(float dist_sqr)
{
  return dist_sqr * -4.0 + 1.0f;
}

float ComputeOcclusion(float3 p, float3 n, float3 s)
{
  float3 v = s - p;
  float vdotv = dot(v,v);
  float ndotv = dot(n,v) / sqrt(vdotv);
  
  return clamp(ndotv - g_hbao_n_dot_v_bias,0.0f,1.0f) * clamp(Falloff(vdotv),0,1);
}

float CalcAO(float3 n, float3 pos, float2 dir, float2 uv, float radius_pixels)
{
  float step_size = max(radius_pixels / (g_hbao_steps + 1),0.8);
  
  float res = 0.0f;
  float2 texel_size = float2(1,1) / g_screen_size;
  
  float ray_pixels = step_size;
  for (int step_index = 0.0f; step_index < g_hbao_steps; ++step_index)
  {
    float2 snapped_uv = uv + round(ray_pixels * dir) * texel_size;
    float3 s = GetViewPos(snapped_uv);
  
    res += ComputeOcclusion(pos, n, s); 
    ray_pixels += step_size;
  }

  res *= g_hbao_mul;
  res /= g_hbao_steps;
  return res;
}

float4 main(VertexTOut pin) : SV_Target
{
  float3 pos = GetViewPos(pin.uv);
  float4 normal = g_normal.Sample(g_sam_linear, pin.uv);

  float2 dir = float2(0,1);
  
  float max_angle = 3.14159f;
  float rand = Noise(pin.uv);
  rand *= max_angle;
  dir = normalize(float2(sin(rand),cos(rand)));
  
  float radius_pixels = g_hbao_radius / pos.z;
  
  float res = 0.0f;
  res += CalcAO(normal.xyz, pos, dir, pin.uv, radius_pixels);
  res += CalcAO(normal.xyz, pos, -dir, pin.uv, radius_pixels);
  res += CalcAO(normal.xyz, pos, float2(-dir.y, dir.x), pin.uv, radius_pixels);
  res += CalcAO(normal.xyz, pos, float2(dir.y, -dir.x), pin.uv, radius_pixels);
  res /= 4.0f;
  
  res = 1.0f - saturate(res);
  //res = 1.0f;
  float d = normal.w;
  if (length(normal.xyz) < 0.001f)
    d = 1000.0f;
  
  return float4(res.xxx, d);
}