#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\noise.h"

float checker(float2 uv){
 	return (abs(floor(fmod(uv.x*10.,2.))-floor(fmod(uv.y*10.,2.))));
}

float3 get_ray_dir( in float2 p, in float3 cam_dir, in float fov)
{
	float3 cw = normalize(cam_dir.xyz);
	float3 cp = float3(0.0,1.0,0.0);
	float3 cu = normalize(cross(cp,cw));
	float3 cv = normalize(cross(cu,cw));

	float halfFOV = fov * 0.5f;
	float focalLength = 1.0f/tan(halfFOV * 3.14159f/180.0f);

	return normalize(p.x*cu + p.y*cv + focalLength*cw);
}

float4 main(VertexTOut pin) : SV_Target
{
  float aspect = g_screen_size.x / g_screen_size.y;
  float2 uv = pin.uv  * float2(aspect, 1.0f);
  uv.x = uv.x * 2.0f - 1.0f;
  uv.y = (uv.y * 2.0 - 1.0);

  float3 sun_dir = normalize(float3(1,1,1));
  float3 dir = get_ray_dir(uv, g_cam_dir, g_fov);

  float c = dot(dir, float3(0,1,0));
  float x = smoothstep(g_h_min, g_h_max, c);

  float3 col = lerp(g_h_color, g_h_color2, x);
  x = pow( max(dot(dir, g_sun_dir),0.0), 8.0f);
  col = lerp(col, g_sun_color, x);

  return float4(col, 1.0f);
}
