#define PCF_NUM_SAMPLES 16
#define BLOCKER_SEARCH_NUM_SAMPLES 16
#define NEAR_PLANE 0.1
#define LIGHT_WORLD_SIZE 1800.0
#define LIGHT_FRUSTUM_WIDTH 2048.0

#define LIGHT_SIZE_UV (LIGHT_WORLD_SIZE / LIGHT_FRUSTUM_WIDTH)

static const float2 poisson_disk[16] = 
{
  float2( -0.94201624, -0.39906216 ),
  float2( 0.94558609, -0.76890725 ),
  float2( -0.094184101, -0.92938870 ),
  float2( 0.34495938, 0.29387760 ),
  float2( -0.91588581, 0.45771432 ),
  float2( -0.81544232, -0.87912464 ),
  float2( -0.38277543, 0.27676845 ),
  float2( 0.97484398, 0.75648379 ),
  float2( 0.44323325, -0.97511554 ),
  float2( 0.53742981, -0.47373420 ),
  float2( -0.26496911, -0.41893023 ),
  float2( 0.79197514, 0.19090188 ),
  float2( -0.24188840, 0.99706507 ),
  float2( -0.81409955, 0.91437590 ),
  float2( 0.19984126, 0.78641367 ),
  float2( 0.14383161, -0.14100790 )
};

void FindBlocker(Texture2D depth_map, SamplerState sam_point, out float avg_blocker_depth, out float num_blockers, float2 uv, float z_reciever)
{
  float search_width = LIGHT_SIZE_UV * (z_reciever - NEAR_PLANE) / z_reciever;

  float blocker_sum = 0.0f;
  num_blockers = 0;
  
  for (int i = 0; i < BLOCKER_SEARCH_NUM_SAMPLES; ++i)
  {
    float shadow_map_depth = depth_map.SampleLevel( sam_point, uv + poisson_disk[i] * search_width, 0).x;
    if (shadow_map_depth < z_reciever)
    {
      blocker_sum += shadow_map_depth;
      num_blockers++;
    }
  }
  
  avg_blocker_depth = blocker_sum / num_blockers;
}

float PCF16(Texture2D depth_map, SamplerComparisonState sampler, float2 uv, float z, float filter_uv)
{
  float sum = 0.0f;
  for (int i = 0; i < PCF_NUM_SAMPLES; ++i)
  {
    float2 offset = poisson_disk[i] * filter_uv;
    sum += depth_map.SampleCmpLevelZero(sampler, uv + offset, z);
  }
  return sum / PCF_NUM_SAMPLES;
}

float PCF9(Texture2D depth_map, SamplerComparisonState sampler, float2 uv, float z, float filter_uv)
{
  float shadows = depth_map.SampleCmpLevelZero(sampler, uv, z);
  shadows += depth_map.SampleCmpLevelZero(sampler, uv + float2(-1.0,-1.0) * filter_uv, z);
  shadows += depth_map.SampleCmpLevelZero(sampler, uv + float2(-1.0, 0.0) * filter_uv, z);
  shadows += depth_map.SampleCmpLevelZero(sampler, uv + float2(-1.0, 1.0) * filter_uv, z);
  shadows += depth_map.SampleCmpLevelZero(sampler, uv + float2( 0.0,-1.0) * filter_uv, z);
  shadows += depth_map.SampleCmpLevelZero(sampler, uv + float2( 0.0, 1.0) * filter_uv, z);
  shadows += depth_map.SampleCmpLevelZero(sampler, uv + float2( 1.0,-1.0) * filter_uv, z);
  shadows += depth_map.SampleCmpLevelZero(sampler, uv + float2( 1.0, 0.0) * filter_uv, z);
  shadows += depth_map.SampleCmpLevelZero(sampler, uv + float2( 1.0, 1.0) * filter_uv, z);
  return shadows / 9.0f;
}

float PCSS(Texture2D depth_map, SamplerComparisonState sampler, SamplerState sam_point, float3 coords)
{
  float2 uv = coords.xy;
  float z_reciever = coords.z;
  
  //blocker search
  float avg_blocker_depth = 0;
  float num_blockers = 0;
  FindBlocker(depth_map, sam_point, avg_blocker_depth, num_blockers, uv, z_reciever);
  
  if (num_blockers < 1)
    return 1.0f;
  
  //penumbra size
  float penumbra_ratio = (z_reciever - avg_blocker_depth) / avg_blocker_depth;
  float filter_uv = penumbra_ratio * LIGHT_SIZE_UV * NEAR_PLANE / z_reciever;
  
  //filter
  //filter_uv = 0.001f;
  return PCF16(depth_map, sampler, uv, z_reciever, filter_uv);
}