#define MAX_PARTICLES 2048

struct Double3
{
  double x;
  double y;
  double z;
};

Double3 ToDouble(float3 p)
{
  Double3 r;
  r.x = p.x;
  r.y = p.y;
  r.z = p.z;
  return r;
}

Double3 PackDouble(double x, double y, double z)
{
  Double3 r;
  r.x = x;
  r.y = y;
  r.z = z;
  return r;
}

Double3 Mul(Double3 p, double v)
{
  Double3 r;
  r.x = p.x * v;
  r.y = p.y * v;
  r.z = p.z * v;
  return r;
}

Double3 Add(Double3 a, Double3 b)
{
  Double3 r;
  r.x = a.x + b.x;
  r.y = a.y + b.y;
  r.z = a.z + b.z;
  return r;
}

Double3 Minus(Double3 a, Double3 b)
{
  Double3 r;
  r.x = a.x - b.x;
  r.y = a.y - b.y;
  r.z = a.z - b.z;
  return r;
}

double Length(Double3 v)
{
  return double(sqrt(float(v.x*v.x + v.y*v.y + v.z*v.z)));
}

Double3 Normalize(Double3 v)
{
  Double3 r;
  double len = Length(v);
  r.x /= len;
  r.y /= len;
  r.z /= len;
  return r;
}

struct Particle
{
  double p_x;
  double p_y;
  
  double p_z;
  double prev_x;
  
	double prev_y;
	double prev_z;
  
  double v_x;
  double v_y;
  
  double v_z;
  double w;
  
  float3 normal;
	uint flags;
  
  int mat_index;
  uint softbody;
  uint num_constraints;
};

struct Edge
{
  uint idx0;
  uint idx1;
};

struct DistConstraint
{
  uint p0;
	uint p1;
	double l0;
  uint flags;
  float2 pad;
};