#include "data\\shaders\\common.h"

cbuffer PerParticleSys : register(b0, space1)
{
  float4x4 g_world;
  Material g_mat;

  int g_noise_type;
  int g_seed;
  float g_frequency;
  float g_speed;
  float g_reset;

  float3 g_extent;
}

struct Particle
{
  float3 pos;
  float size;

  float3 heading;
  float pad;
};

float3 GetParticlePos(Particle p, float3 vp)
{
  float3 pos = vp;

  float3 forward = p.heading;
  float3 right = cross(float3(0,1,0),forward);
  float3 up = cross(forward, right);
  pos = normalize(forward)*pos.z + normalize(right)*pos.x + normalize(up)*pos.y;

  return pos*p.size*0.005f + p.pos;
}
