#include "data\\shaders\\particles\\particles_common.h"
#include "data\\shaders\\input_formats.h"

StructuredBuffer<Particle> particles : register(t0);

VertexPPNTOut main(VertexPNTIn vin, uint instanceID : SV_InstanceID)
{
	VertexPPNTOut vout;
	Particle p = particles[instanceID];
  float3 pos = GetParticlePos(p, vin.pos);
	float3 world_pos = mul(float4(pos, 1.0f), g_world).xyz;

  vout.pos_w = world_pos;
  vout.pos_v = mul(float4(world_pos,1.0f), g_view).xyz;

  float4 clip_pos = mul(float4(world_pos, 1.0f), g_view_proj);
  vout.pos_h = clip_pos;

  float3 normal = vin.normal;

  float3 forward = p.heading;
  float3 right = cross(float3(0,1,0),forward);
  float3 up = cross(forward, right);
  normal = normalize(forward)*normal.z + normalize(right)*normal.x + normalize(up)*normal.y;


	normal = mul(float4(normal, 0.0f), g_world).xyz;
  vout.normal = mul(float4(normal, 0.0f), g_view).xyz;

  vout.uv = vin.uv;
  vout.mat_index = 0;//inst.mat_index;
  return vout;
}
