#include "data\\shaders\\common.h"
#include "data\\shaders\\effects\\pixel_sort_common.h"

RWStructuredBuffer<RangeColor> range_buff : register(u0, space4);
Texture2D g_input : register(t0);
RWTexture2D<float4> g_output : register(u1, space4);

[numthreads(16, 16, 1)]
void main(uint3 globalID : SV_DispatchThreadID, uint3 localID : SV_GroupThreadID, uint localIndex : SV_GroupIndex, uint3 groupID : SV_GroupID)
{
  uint w, h;
  g_output.GetDimensions(w, h);
  if(globalID.x >= w || globalID.y >= 16)
    return;

  RangeColor range = range_buff[globalID.x*16 + globalID.y];
  uint first = (uint)(range.minc.a*h);
  uint next = (uint)(range.maxc.a*h);

  int size = next - first;
  if (size <= 0)
    return;

  float minBC = Luminance(range.minc.xyz);
  float maxBC = Luminance(range.maxc.xyz);
  float avgBC = Luminance(range.avgc.xyz);
  float div = maxBC - minBC;
  if (div < 0.01) div = 0.01;
  float lerpScale = 1.0;
  float lerpPow = 0.2 + 1.6 - ((avgBC - minBC) / (div)) * 1.6;

  float inv_size = 1.0f / (float)size;
  uint2 p;
  for (uint i = 0; i < size; ++i)
  {
    p = uint2(globalID.x, first + i);
    float lerpk = i * inv_size;
    //lerpk = pow(max(lerpk,0.0f), lerpPow);
    lerpk = 1.0 - lerpk;
    float3 col = lerp(range.minc.xyz, range.maxc.xyz, saturate(lerpk));
    //col.x = col.y = col.z = lerpk;
    g_output[p] = float4(col, 1.0f);
  }
}
