#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

StructuredBuffer<Instance> g_instance : register(t0, space0);
StructuredBuffer<uint> g_index_instance : register(t1, space0);
Texture2D g_depth : register(t2, space0);

StructuredBuffer<Material> g_materials : register(t5, space1);
Texture2D g_mat_tex[] : register(t0, space3);

SamplerState g_sam_point : register(s0);
SamplerState g_sam_linear : register(s2);

float4 main(VertexPPIOut pin) : SV_Target
{
	pin.clip_pos.xyz /= pin.clip_pos.w;
	float2 uv = float2(pin.clip_pos.x,-pin.clip_pos.y)*0.5 + 0.5f;
	Instance inst = g_instance[g_index_instance[pin.instance_id]];
	Material mat = g_materials[inst.mat_index];

	float depth = g_depth.Sample(g_sam_point, uv).r;

	float4 pos = float4(1.0f,1.0f,1.0f,1.0f);
  pos.x = uv.x * 2.0f - 1.0f;
  pos.y = -(uv.y * 2.0f - 1.0f);
  pos.z = depth;
  pos = mul(pos, g_inv_view_proj);
  pos /= pos.w;

	float4 model_pos = mul(float4(pos.xyz,1.0f), inst.inv_world);
	clip(0.5 - abs(model_pos.xyz));

	uv.x = -(model_pos.x+0.5f);
	uv.y = model_pos.z+0.5f;

	float4 col = g_mat_tex[mat.diffuse_tex].Sample(g_sam_linear, uv * mat.tiling);
	col.rgb *= mat.diffuse;
	col.a *= saturate(mat.specular.x);
	return col;
}
