#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

StructuredBuffer<Instance> g_instance : register(t0, space0);
StructuredBuffer<uint> g_index_instance : register(t1, space0);

VertexPPNTOut main(VertexPNTIn vin, uint instanceID : SV_InstanceID)
{
	VertexPPNTOut vout;
  Instance inst = g_instance[g_index_instance[instanceID]];

	float3 world_pos = mul(float4(vin.pos, 1.0f), inst.world).xyz;

  vout.pos_w = world_pos;
  vout.pos_v = world_pos;

  float4 clip_pos = mul(float4(world_pos, 1.0f), g_proj_2d);
  vout.pos_h = clip_pos;

  float3 normal = vin.normal;
  normal = mul(float4(normal, 0.0f), inst.world).xyz;
  vout.normal = normal;

  vout.uv = vin.uv;
  vout.mat_index = inst.mat_index;
  return vout;
}
