pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

data = {
  {
    name="scrapper",
    fact1="likes da shaders",
    fact2="hete dans actie",
    suitcol = 9,
    textcol = 13,
    sprite = 46,
  },
  {
    name="samar",
    fact1="first time here",
    fact2="outgoing introvert",
    suitcol = 3,
    textcol = 11,
    sprite = 10,
  },
  {
    name="gorbo",
    fact1="eats mustard",
    fact2="wants all your\nsold-out revision mugs",
    suitcol = 15,
    textcol = 9,
    sprite = 42,
  },
  {
    name="tibs",
    fact1="da best dancer",
    fact2="has a funny face",
    suitcol = 11,
    textcol = 12,
    sprite = 12,
  },
  {
    name="badkuip",
    fact1="can do magic",
    fact2="but not right now",
    suitcol = 2,
    textcol = 14,
    sprite = 44,
  },
  {
    name="wafel",
    fact1="drinks enuff water",
    fact2="has a passion",
    suitcol = 11,
    textcol = 2,
    sprite = 40,
  },
  {
    name="kywr",
    fact1="almost didn't go",
    fact2="wants to play\nballetje balletje",
    suitcol = 12,
    textcol = 10,
    sprite = 6,
  },
  {
    name="spiderbro",
    fact1="for da first time",
    fact2="loves da scene",
    suitcol = 9,
    textcol = 15,
    sprite = 38,
  },
  {
    name="stab",
    fact1="can lift up a boulder",
    fact2="with relative ease",
    suitcol = 3,
    textcol = 12,
    sprite = 8,
  },
}

current_character_index = 0
previous_character_index = 0

function _init()
  srand(1234) -- gives da best dances

  shuffle(data)

  random_options = {}
  final_options = {}
  finalize(final_options)

  music(0)
end

function time_text(text16, time01)
  local result = ""

  local r = min(32, flr(time01 * 32) + 1)

  for i = 1, r do
    result = result .. text16[i]
  end

  return result
end

function remap(s, a1, a2, b1, b2)
  return b1 + (s - a1) * (b2 - b1) / (a2 - a1);
end

function animate_scene(char, time01)
  local prependo = 0.25 / 8

  if (time01 >= 0.25 - prependo) then
    color(char.textcol)
    print("NAME:", 8, 16)
  end
  if (time01 >= 0.25) then
    color(6)
    print(char.name, 8, 16+8)
  end

  if (time01 >= 0.5 - prependo) then
    color(char.textcol)
    print("FACT:", 8, 16+16)
  end
  if (time01 >= 0.5) then
    color(6)
    print(char.fact1, 8, 16+16+8)
  end

  if (time01 >= 0.75 - prependo) then
    color(char.textcol)
    print("FACT:", 8, 16+16+16)
  end
  if (time01 >= 0.75) then
    color(6)
    print(char.fact2, 8, 16+16+16+8)
  end

end

txt_intro1 = {
  " are ","","","you ","","","ready ","",
  "to\n","","","","","","","",
  "meet ","","","da ","","","kex ","",
  "crew?","","","","","","","",
}

txt_intro2 = {
  "(if ","","you ","","know ","","the ","",
  "words\n","","","","   you ","","","",
  "ca","n ","jo","in ","","","in ","",
  "too!)","","","","","","","",
}

tempo = {
  "x","_","_","_","x","_","_","_\n",
  "x","_","_","_","x","_","_","_\n",
  "x","_","_","_","x","_","_","_\n",
  "x","_","_","_","x","_","_","_\n",
}

function animate_intro(time01)
  if (time01 >= 0 and time01 < 0.25) then
    color(6)
    print("kexfabriken", 64-20, 64+12)
    spr(1, 64 - 16, 64 - 24, 4, 4)
  end

  if (time01 >= 0.25 and time01 < 0.75) then
    local txt = time_text(txt_intro1, remap(time01, 0.25, 0.5, 0, 1))
    print(txt, 16 + 16, 64-12)
  end
  if (time01 >= 0.5 and time01 < 0.75) then
    local txt = time_text(txt_intro2, remap(time01, 0.5, 0.75, 0, 1))
    print(txt, 16 + 0, 64+12)
  end

  local alt = ((time01 * 16) % 1) < 0.5
  if (time01 >= 0.75) then
    local txt = "(wait for it)"
    local c = alt and 8 or 13
    color(c)
    print(txt, 64-24, 64)
  end
end

-- we're doing zero caching which is lame
function point(x, y)
  return {
    x = x, y = y,

    get = function(self, flip)
      return x, y -- do nothing with the flip
    end,

    draw = function(self)
      circ(x, y, 1, 8)
    end,

    vec = function(self, flip)
      local x, y = self:get(flip)
      return {x = x, y = y}
    end
  }
end

function point_child(parent, offsetx, offsety)
  return {
    parent = parent,
    ox = offsetx, oy = offsety,

    get = function(self, flip)
      local px, py = self.parent:get(flip)
      return px + self.ox * (flip and -1 or 1), py + self.oy
    end,

    draw = function(self)
      local px, py = self.parent:get()
      local x, y = px + self.ox, py + self.oy
      circ(x, y, 1, 9)
    end,

    vec = function(self, flip)
      local x, y = self:get(flip)
      return {x = x, y = y}
    end
  }
end

function randomize(o)
  o.speed_mult = rnd({1, 1, 1, 1, 2})
  o.speed_mult_feet = rnd({1, 1, 1, 2})
  o.speed_mult_arms = rnd({1, 1, 1, 2, 2, 4})
  o.feet_async_mode = rnd({1, 1, 2, 3})
  o.hip_swing = rnd({-10, 10, -8, 8, -5, 5, -3, -3, 3, 3, -1, 1, 0, 0, 0, 0})
  o.shoulder_swing = rnd({-10, 10, -8, 8, -5, 5, -3, -3, 3, 3, -1, 1, 0, 0, 0, 0})
  o.head_updown = rnd({5, 3, 1, 0, -1, -3, -5})
  o.hip_updown = rnd({-2, -2, -1, 0, 1, 2, 2})
  o.full_flip = rnd({true, false})
  o.arms_period = rnd({1, 1, 2, 2, 2, 4})
  o.arms_updown = rnd({-10, -6, -4, 0, 4, 6, 10})
  o.arms_async_mode = rnd({1, 1, 2})
  o.arms_out = rnd({true, false})
  o.feet_out = rnd({true, false})
  o.flip_every = rnd({0, 0, 0, 0, 0, 0, 0, 0.25, 0.5, 1, 2, 4})
end

function finalize(o)
  o.speed_mult = 0.25
  o.speed_mult_feet = 1
  o.speed_mult_arms = 1
  o.feet_async_mode = 1
  o.hip_swing = 0
  o.shoulder_swing = 0
  o.head_updown = rnd({-3, -2, -1, 0, 1, 2, 3})
  o.hip_updown = 0
  o.full_flip = false
  o.arms_period = 1
  o.arms_updown = 0
  o.arms_async_mode = 1
  o.arms_out = true
  o.feet_out = true
  o.flip_every = 0
end

function animate_char(char, ntime, x, y, options)
  -- hflip vlaflip

  local o = {
    speed_mult = 1, -- 1, 2
    speed_mult_feet = 1, -- 1, 2
    speed_mult_arms = 2, -- 1, 2, 4
    feet_async_mode = 2, -- 1, 2, 3
    hip_swing = -5, -- -10 .. 10
    shoulder_swing = 5, -- -10 .. 10
    head_updown = 0, -- -2 .. 2
    hip_updown = 0, -- -5 .. 5
    full_flip = true,
    arms_period = 2, -- 1, 2, 4
    arms_updown = 10, -- -10 .. 10
    arms_async_mode = 2, -- 1, 2
    arms_out = false,
    feet_out = false,
    flip_every = 0, -- 0, 0.25, 0.5, 1, 2, 4
  }

  if (options) then
    o = options
  end

  local base_flip = o.full_flip

  if (ntime*o.flip_every) % 1 > 0.5 then
    base_flip = not base_flip
  end

  -- shoulder swing should counteract hip swing
  local corrected_shoulder_swing = o.shoulder_swing -1 * o.hip_swing

  local t = ntime * o.speed_mult
  local t_followthrough = t - 0.125
  local t_counter = t + 0.25

  local t_feet = t * o.speed_mult_feet
  local t_feet_quarter = t_feet + 0.25
  local t_feet_counter = t_feet + 0.5
  local t_arms = t * o.speed_mult_arms
  local t_arms_counter = t_arms + 0.5

  local center = point(64 + x, 64 + y)

  local hips = point_child(center, o.hip_swing * sin(t), - o.hip_updown + 10 * abs(sin(t)))
  local shoulders = point_child(hips, corrected_shoulder_swing * sin(t), -18)
  
  local head = point_child(shoulders, 2, -10 - o.head_updown + 6 * abs(sin(t_followthrough)))

  local left_leg = point_child(hips, -5, 0);
  local right_leg = point_child(hips, 5, 0);
  local left_arm = point_child(shoulders, -5, 0);
  local right_arm = point_child(shoulders, 5, 0);

  local left_foot = point_child(center, -10, 30 + min(0, 10 * sin(t_feet)))

  local t_feet_moded = t_feet
  if o.feet_async_mode == 2 then
    t_feet_moded = t_feet_quarter
  elseif o.feet_async_mode == 3 then
    t_feet_moded = t_feet_counter
  end

  local right_foot = point_child(center, 10, 30 + min(0, 10 * sin(t_feet_moded)))

  local right_hand = point_child(
    center,
    20 - 8 * cos(0.5 * t_arms),
    -10 - o.arms_updown + 10 * sin(0.5 * t_arms * o.arms_period)
  )

  local t_arms_moded = t_arms
  if o.arms_async_mode == 2 then
    t_arms_moded = t_arms_counter
  end

  local left_hand = point_child(
    center,
    -20 - 8 * cos(0.5 * t_arms_moded),
    -10 - o.arms_updown + 10 * sin(0.5 * t_arms_moded * o.arms_period)
  )

  if not o.arms_out then
    left_hand.ox = left_hand.ox + 18
    left_hand.oy = left_hand.oy + 15
  end

  local legl = 30
  local arml = 25
  
  color(char.suitcol)

  local armssign = base_flip and 1 or -1
  local feetsign = base_flip and -1 or 1

  local posflip = base_flip

  lline_vector(shoulders:vec(posflip), hips:vec(posflip), 10)

  -- the leg of leg (the zeg of zeg?)
  knee_vector(left_leg:vec(posflip), left_foot:vec(posflip), legl, feetsign * (o.feet_out and -1 or 1))
  knee_vector(right_leg:vec(posflip), right_foot:vec(posflip), legl, feetsign)
  
  knee_vector(right_arm:vec(posflip), right_hand:vec(posflip), arml, armssign)
  if (o.arms_out) then
    armssign = armssign * -1
  end
  knee_vector(left_arm:vec(posflip), left_hand:vec(posflip), arml, armssign)

  spr_head(char.sprite, head:vec(posflip), posflip)

  if false then
    center:draw()
    hips:draw()
    head:draw()
    shoulders:draw()

    left_foot:draw()
    right_foot:draw()

    left_hand:draw()
    right_hand:draw()

    left_leg:draw()
    right_leg:draw()
    left_arm:draw()
    right_arm:draw()
  end
end

function spr_head(sprite, pos, flip)
  local offset_x = flip and -8 or -8
  spr(sprite, pos.x + offset_x, pos.y - 8, 2, 2, flip)
end

function _draw()
  local tt = t()*0.75 -- should match music with speed '10'
  
  cls()

  local slen = 4

  local lastindex = 9 + 2
  
  local index = min(lastindex, flr(tt / slen), lastindex)

  --index = index + 10 -- temp

  local time01 = (tt % slen) / slen

  if (index == 0 or index == 1) then
    -- intro time works differently
    time01 = (tt % 8) / 8
    animate_intro(time01)
  else
    current_character_index = index - 1

    if (previous_character_index ~= current_character_index) then
      -- show a new character!
      if index <= lastindex then
        randomize(random_options)
      end
    end

    if current_character_index <= #data then
      if current_character_index ~= 9 or time01 < (1 - 1/8) then
        -- draw a character dancing
        local char = data[current_character_index]

        animate_scene(char, time01)
        
        animate_char(char, tt, 0, 30, random_options)
      end
    else
      -- grand finale
      
      -- thanks
      local alt = ((time01 * 16) % 1) < 0.5
      local txt = "thanks revision!"
      local c = alt and 8 or 13
      color(c)
      print(txt, 64-32, 40)
      color(6)
      print("kexfabriken will return", 64-40-4, 48)
      
      -- and the bunch
      animate_char(data[2], tt      , -30, 50 - 20, final_options)
      animate_char(data[4], tt + 0.1, -10, 50 - 20, final_options)
      animate_char(data[8], tt + 0.2,  10, 50 - 20, final_options)
      animate_char(data[6], tt + 0.3,  30, 50 - 20, final_options)
      animate_char(data[1], tt + 0.4, -40, 70 - 20, final_options)
      animate_char(data[9], tt + 0.5, -20, 70 - 20, final_options)
      animate_char(data[3], tt + 0.6,   0, 70 - 20, final_options)
      animate_char(data[7], tt + 0.7,  20, 70 - 20, final_options)
      animate_char(data[5], tt + 0.8,  40, 70 - 20, final_options)

    end

    previous_character_index = current_character_index
  end
end

function rotate(offx, offy, dir, len)
  local x = offx+cos(dir)*len
  local y = offy+sin(dir)*len
  return x, y
end

function lline(x1, y1, x2, y2, n)
  --local d = atan2(x2 - x1, y2 - y1)
  --d = d + 0.25
  --
  --for i = 1, n do
  --  local r = (i-1) / (n-1)
  --  r = -0.5 + r
  --  r = r * 0.707 * n
  --  local offx = cos(d)*r
  --  local offy = sin(d)*r
  --  
  --  line(x1+offx, y1+offy, x2+offx, y2+offy)
  --end

  phatline(x1, y1, x2, y2, n * 0.5)
end

function lline_vector(v1, v2, n)
  phatline(v1.x, v1.y, v2.x, v2.y, n * 0.5)
end

function knee_vector(v1, v2, len, flipsign)
  knee(v1.x, v1.y, v2.x, v2.y, len, flipsign)
end

function knee(x1, y1, x2, y2, len, flipsign)
  local l = function(xx1, yy1, xx2, yy2)
    lline(xx1, yy1, xx2, yy2, 4)
  end
  local dx = x2 - x1
  local dy = y2 - y1
  local d = sqrt(dx*dx+dy*dy)
  local ratio = d / len
  local dir = atan2(dx,dy)
  if (ratio < 1) then
    -- get bent
    local aanl = 0.5*d
    local schuin = 0.5*len
    -- cos a = aanl / schuin
    local a = acos(aanl / schuin)
    local kneex = cos(dir + a * flipsign)*0.5*len
    local kneey = sin(dir + a * flipsign)*0.5*len
    kneex = kneex + x1
    kneey = kneey + y1

    --color(11)
    l(x1, y1, kneex, kneey)
    --color(8)
    l(kneex, kneey, x2, y2)
  else
    --color(12)
    l(x1, y1, x2, y2)
  end
end

function acos(x)
  return atan2(x, -sqrt(1-x*x))
end

function shuffle(table)
  for i = #table, 1, -1 do
    local index=ceil(rnd(i))
    table[i], table[index] = table[index], table[i]
  end
end

function phatline(ax,ay,bx,by,r)
  local dx = bx - ax
  local dy = by - ay
  local d = max(abs(dx),abs(dy))
  local n = min(abs(dx),abs(dy)) / d
  d = d * sqrt(n*n+1)
  if d < 0.001 then
    return
  end
  local ca = dx/d
  local sa = -dy/d
  local s = {
    {0,-r}, {d,-r}, {d,r}, {0,r}
  }
  local u, v, spans = s[4][1], s[4][2], {}
  local x0 = ax + u * ca + v * sa
  local y0 = ay - u * sa + v * ca
  for i = 1, 4 do
    local u = s[i][1]
    local v = s[i][2]
    local x1 = ax + u * ca + v * sa 
    local y1 = ay - u * sa + v * ca
    local _x1, _y1 = x1, y1
    if y0 > y1 then
      x0, y0, x1, y1 = x1, y1, x0, y0
    end
    local dx = (x1 - x0) / (y1 - y0)
    if y0 < 0 then
      x0 = x0 - y0 * dx
      y0 = -1
    end
    local cy0 = y0 \ 1 + 1
    x0 = x0 + (cy0 - y0) * dx
    for y = y0 \ 1+1, min(y1 \ 1, 127) do
        local span = spans[y]
        if span then
            rectfill(x0, y, span, y)
        else
            spans[y] = x0
        end
        x0 = x0 + dx
    end
    x0, y0 = _x1, _y1
  end
end

__gfx__
00000000007777770000000000000000000000000000000000004400444440000000000000000000000000444444000000000000000000000000000000000000
00000000007777770000000000000000000000000000000000444444444444000000099999999000000444444444400000000aaaaaaa00000000066666660000
0070070000777777000000000000000000000000000000000044444444444440099099999999990000044444444444000aa0aaaaaaaaa0000000666666666000
00077000007777770000000000000000000000000000000000444444444444409999999999999990004444ff44444400aaaaaaaaaaaaaa000006666666666600
0007700000777777000000000000000000000000000000000444ff4444f44400999999ffffffff90004444ffff444400aaaaaaafffffaa000006666666666600
007007000077777700000000000000000000000000000000044ffffffff44f00999999ffffffff900044ffffffff4400aaaaaafffffffaa00006666666666600
000000000077777700000000000000000000000000000000044fffffffffff0009999ffffffffff000f4ffffffffff00aaaaafffffffffa00006666666666600
000000000077777700000000000000000000000000000000ff4fffffffffff0090ff9ffffffffff000fffffdffffdf00aaffafffffffffa00666666666666600
000000000077777700000000000000000000000000000000fffff4fffff4ff0000fffff3fffff3f000ffffffffffff0000ffaafdffffdfa00666666666666600
000000000077777700000000000000000000000000000000ffffffffffffff0000fffffffffffff0000fffffffffff0000ffaaffffffffa00666665666665600
00000000007777770000000000000000000000000000000000ffffffffffff000000fffffffffff0000fffffffffff00000faaffffffffa00006666666666600
00000000007777770000077700000777000007770000000000ffffffffffff000000fffffffffff0000fffffffffff00000fafffffffff0a0006666666666600
00000000007777770007777700077777000777770000000000ffffffffffff0000000ffffffffff00000fffffffff000000fafffffffff000006666666666600
000000000077777700777777007777770077777700000000000ffffffffff000000000ffffffff0000000fffffff0000000aaffffffff0000000666666666600
0000000000777777077777770777777707777777000000000000ffffffff00000000000ffffff000000000ffffff0000000a00ffffff00000000066666666000
00000000007777770777777707777777077777770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000077777777777777777777777777777700000000000000099990999000eeeeeeeeee0000000000000000000000004044440440000000044404444000
000000000077777777777777777777777777777700000000000999999999999000eeeeeeeeeee000000444444444400000044444444444000000444444444400
00000000007777777777777777777777777777770000000000999999999999900eeeeeeeeeeee000004444444444440000444444444444400004444444444440
00000000007777777777777777777777777777770000000009999999999999900eeeeeeeeeeeeeee0044444444444400004444444444444000444ff444f44440
000000000077777770077777777777777777777700000000099999ffff9999900eeeeeeeeeeeeeee04444444444444000044f4444444f44000444ffff4ff4440
0000000000777777700777777777777777777777000000000999fffffff999900111fff11ff1110004444444444444400044ff4f44f4ff400044ffffffffff00
000000000077777770077777777777777777777700000000099fffffffffff00011fffff1fff1100044f44444f44f440004fffffffffff000ff4ffffffffff00
000000000077777770077777777777777777777700000000ff9fffffffffff00ff1ffffffffff000ff4ffffffffff4400f4fffffffffff000ff4ff4fffff4f00
000000000077777770077700770000770077700700000000fffffdfffffdff00fffff5ffff5ff000ff4fff4ffff4f4400ffffdfffffdff000fffffffffffff00
000000000077777770077000700000070007000700000000ffffffffffffff00fffffffffffff000ff4ffffffffff4400fffffffffffff00000fffffffffff00
00000000007777777007000770077707700000770000000000ffffffffffff0000fffffffffff0000ffffff4444ff440000fffffffffff00000fffffffffff00
00000000007777777000007770000007770007770000000000ffffffffffff0000fffffffffff000044fff4ffff4f440000fffffffffff00000fffffffffff00
00000000007777777000000770077777700000770000000000fffffffffff00000fffffffffff000044ffffffffff440000fffffffffff000000fffffffff000
000000000077777770077000700000070007000700000000000ffffffffff000000fffffffff00000444ffffffff44000000fffffffff00000000ffffffff000
0000000000777777700777007700007700777007000000000000ffffffff00000000fffffff0000000444ffffff4440000000fffffff0000000000ffffff0000
00000000007777777777777777777777777777770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
66600000666066606660660000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
60600000006060600060060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
60600000666060600660060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
60600000600060600060060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
66600600666066606660666000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000007770000077700000777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777000777770007777700077777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777007777770077777700777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777077777770777777707777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777077777770777777707777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777777777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777777777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777777777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777777777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700777007700007700777007000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700770007000000700070007000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700700077007770770000077000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700000777000000777000777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700000077007777770000077000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700770007000000700070007000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777700777007700007700777007000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000777777777777777777777777777777000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000606066606060666066606660666066606060666066000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000606060006060600060606060606006006060600060600000000000000000000000000000000000000000
00000000000000000000000000000000000000000000660066000600660066606600660006006600660060600000000000000000000000000000000000000000
00000000000000000000000000000000000000000000606060006060600060606060606006006060600060600000000000000000000000000000000000000000
00000000000000000000000000000000000000000000606066606060600060606660606066606060666060600000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

__sfx__
000a00000c45300600006000c40300600006000c453006000c650006000060000600006000060000600006000c45300600006000c30300600006000c403006000c65000600006000060000600006000060000600
010a00000c45300600006000c45300600006000c453006000c650006000060000600006000060000600006000c45300600006000c35300600006000c453006000c65000600006000060000600006000060000600
010a00000c453006000c453006000c453006000c453006000c6500060000600006000c4530060000600006000c3530c1530c1530c45300600006000c452006040c65200604006000060000600006000060000600
010a00000c453006000c153006000c253006000c453006000c650006000c153006000c2530060000600006000c45300600006000c35300600006000c453006000c650006000c1530c2000c153006000060000600
000a00000c453006000c153006000c253006000c453006000c650006000c153006000c4530060000600006000c3530c1530c1530c45300600006000c453006000c650006000c153006000c153006000c10000600
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a000018455184001845518400184551d40018455004001c4551d4001d4421d4221d415004001f400004001f455004001d455004001c455004001d455004001c4421c4221c4150040018455004000040000400
010a00001f455181001d455181001c4551d1001d455000001c4551d1001d1001d10018452184351f1000000016455000001545500000164550000015455000001645500000184550000018100000000000000000
010a00001845518400184001840018455000001645500000164550000018455000000000000000184550000018400000001d455000001d455000001d455000001c45500000184550000018455000001840000000
010a00001d4551d4001d4551d4001d4551c4001d455000001c455000001845500000184550000000000000001645500000184550000018455000001d455000001c4550000000000000001f455000000000000000
010a000019455194001945519400194551e40019455014001d4551e4001e4421e4221e41501400204000140020455014001e455014001d455014001e455014001d4421d4221d4150140019455014000140001400
010a000020455191001e455191001d4551e1001e455010001d4551e1001e1001e1001945219435201000100017455010001645501000174550100016455010001745501000194550100019100010000100001000
010a00001945519400194001940019455010001745501000174550100019455010000100001000194550100019400010001e455010001e455010001e455010001d45501000194550100019455010001940001000
010a00001e4551e4001e4551e4001e4551d4001e455010001d455010001945501000194550100001000010001745501000194550100019455010001e455010002045524000010000100020400010000100001000
010a00000c1260c1061f126131060c126131061f1260c1060c1260c1061f126131060c126131061f1260c1060c1260c1061f126131060c126131061f1260c1060c1260c1061f126131060c126131061f1260c106
010a00000d1260d10620126141060d12614106201260d1060d1260d10620126141060d12614106201260d1060d1260d10620126141060d12614106201260d1060d1260d10620126141060d12614106201260d106
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00001e4551e4001e4551e4001e4551d4001e455010001d4550100019455010001945501000010000100017455010001945501000194550100019455010001945524000194000100019400010001940001000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00002b55029500005000050000500005000050000500005000050000500005002b55029551245512455500500005003055000500005000050000500005000050000500005000050000500005000050000500
010a00002455000000000000000000000000000000000000000000000000000285002855024550185502455030550000000000000000000000000000000000000000000000000000000000000000000000000000
010a00002455000002000020000200002000020000200002000020000229552295422854228542295422954230550000020000200002000020000200002000020000200002000020000200002000020000200002
010a000029550295302951000000285000000028500000002855028530285101f500225001f50022500245002e5502b5402e5302b5402e5302b5402e530305403055000000000000000000000000000000000000
010a000029550295302951000000285000000028500000002855028530285101f500225001f50022500245002e5502b5402e5302b5402e5302b5402e530305403154131531315213151100000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00002c5502a500015000150001500015000150001500015000150001500015002c5502a551255512555501500015003155001500015000150001500015000150001500015000150001500015000150001500
010a00002555001000010000100001000010000100001000010000100001000295002955025550195502555031550010000100001000010000100001000010000100001000010000100001000010000100001000
010a0000255500100201002010020100201002010020100201002010022a5522a54229542295422a5422a54231550010020100201002010020100201002010020100201002010020100201002010020100201002
010a00002a5502a5302a510010002950001000295000100029550295302951020500235002050023500255002f5502c5402f5302c5402f5302c5402f530315403155001000010000100001000010000100001000
010a00002a5502a5302a510010002950001000295000100029550295302951020500235002050023500255002f5502c5402f5302c5402f5302c5402f530315403155031540315303152031510010000100001000
__music__
01 00485058
00 01495059
00 024a505a
00 0248105b
00 01084344
00 02094344
00 030a4444
00 040b4344
00 01081844
00 02091944
00 030a1a44
00 040b1b44
00 01081810
00 02091910
00 030a1a10
00 040b1c10
00 010c2011
00 020d2111
00 030e2211
00 040f2311
00 444f2311
00 04132311

