	page	240, 132
;vlf.asm
;Very, Little Fugue
;Fugue in G Minor by Johann Sebastian Bach
;The recursive spiral was inspired by this:
;https://pythonturtle.academy/spiral-of-spirals-fractals-2-with-python-turtle-source-code/
;Assemble with: tasm; tlink /t
;This runs under DOSBox; not under pure DOS.

	.model	tiny
	.code
	.486
	org	100h
;ax=0, bx=0, cx=00FFh, dx=cs, si=0100h, di=-2, bp=09xx, sp=-2
;high 16 bits of esp = 0000h

debug	equ	0		;set to 0 for compo version
ScrW	equ	1024		;screen dimensions (pixels)
ScrH	equ	768

start:
;	push	ax		;access absolute memory addresses
;	pop	fs		;unnecessary with DOSBox
;	fninit			;unnecessary with DOSBox

	mov	ax, 4F02h	;1024x768x8 graphics
	mov	bx, 0105h
	int	10h
ticks	equ	$-1		;tick counter for note duration, initially 1 sec

;Use our routine for the system timer interrupt (1Ch).
;The routine is called about 18.2 times per second.
if debug
;First, save the original interrupt handler vector
	mov	ax, 351Ch
	int	21h
	mov	oldint, bx
	mov	oldint+2, es
endif
	push	offset score
	pop	es

	mov	ax, 251Ch	;point interrupt vector to our routine
	mov	dx, offset inthan ; ds=cs
	int	21h		;(music will start playing)

;DrawSpiral(770, 600, 135, -1.6)
	fild	word ptr [si+d770-start]	;FPU: X
	fild	word ptr [si+d600-start]	;FPU: X Y
	fild	word ptr [si+d135-start]	;FPU: X Y Len
	fld    dword ptr [si+d_1_6-start]	;FPU: X Y Len Dir
	call	Spiral

wait10:	in	ax, 60h				;wait for Esc key
	dec	al
	jne	wait10
if debug
	mov	ax, 251Ch	;restore original interrupt vector
	mov	dx, oldint	;(music stops playing)
	mov	ds, oldint+2	;WARNING ds is changed
	int	21h

	mov	ax, 0003h			;restore text mode
	int	10h
endif
return:	ret

d770	dw	770		;02 03
d3	equ	$-1		;03 00
dScrW	dw	ScrW		;00 04
d600	dw	600
d135	dw	135
d_1_6	dd	-1.6
d0_3	dd	0.3
d4	dw	4
d0_94	dd	0.94

;-------------------------------------------------------------------------------
;proc DrawSpiral(X, Y, Len, Dir)

Spiral:
;while Len > 0.3 do
spi00:	fld	dword ptr [si+d0_3-start]	;FPU: X Y Len Dir 0.3
	fcomp	st(2)				;FPU: X Y Len Dir
	fnstsw	ax
	sahf
	jae	short return			;exit if Len <= 0.3

;if Len > 1 then
	fld1					;FPU: X Y Len Dir 1
	fcomp	st(2)				;FPU: X Y Len Dir
	fnstsw	ax
	sahf
	jae	short spi20			;skip if Len <= 1

;DrawSpiral(X, Y, Len/4, Dir-3)
	sub	sp, si				;at least 108 bytes of stack
	fnsave	[esp]				;FPU: also does finit
	fnrstor	[esp]				;FPU: X Y Len Dir

	fild	word ptr [si+d4-start]		;FPU: X Y Len Dir 4
	fdivp	st(2)
	fisub	word ptr [si+d3-start]		;FPU: X Y Len/4 Dir-3

	call	spiral				;recurse

	fnrstor	[esp]				;FPU: X Y Len Dir
	add	sp, si				;release reserved stack space

	loop	$				;delay for effect
spi20:
;X:= X + Len*Cos(Dir)
	fld	st				;FPU: X Y Len Dir Dir
	fsincos					;FPU: X Y Len Dir sin cos
	fmul	st, st(3)			;FPU: X Y Len Dir sin Lencos
	faddp	st(5), st			;FPU: X Y Len Dir sin

;Y:= Y + Len*Sin(Dir)
	fmul	st, st(2)
	faddp	st(3), st			;FPU: X Y Len Dir

;Point(fix(X), fix(Y), $0F)
	fld	st(2)				;FPU: X Y Len Dir Y
	frndint
	fimul	word ptr [si+dScrW-start]	;FPU: X Y Len Dir Y*ScrW
	fadd	st, st(4)			;FPU: X Y Len Dir Y*ScrW+X
	fistp	dword ptr [si]			;FPU: X Y Len Dir
	mov	ebx, dword ptr [si]
	mov	ax, sp				;color it beautiful!
	add	al, 16
	mov	byte ptr fs:[ebx+0C0000000h], al

;Len:= Len * 0.94
	fld	dword ptr [si+d0_94-start]	;FPU: X Y Len Dir 0.94
	fmulp	st(2), st			;FPU: X Y Len Dir

;Dir:= Dir - 0.30
	fsub	dword ptr [si+d0_3-start]	;FPU: X Y Len Dir
	jmp	spi00

;-------------------------------------------------------------------------------
base	equ	43		;base offset for packed notes format

inthan:	pusha

	dec	byte ptr [si+ticks-start]
	jne	ih90

	mov	dx, 330h	;set MPU-401 into UART mode and
	mov	ax, 3FC0h	; set instrument on channel 0 to:
	out	dx, ax
	mov	al, 12-1	; vibraphone
	out	dx, al
	
	mov	al, 90h		;turn on note for channel 0
	out	dx, al

	mov	si, es		;fetch note
	lodsb			;al:= ds:[si++]
	mov	es, si

	cmp	al, 0		;end of score?
	jne	ih10		;skip if not
	 push	offset score	;restart music
	 pop	es
	 jmp	ih90
ih10:				;unpack note byte into pitch and duration
	aam	6		;ah:= al/6; al:= remainder
	inc	ax		;1..6
	shl	al, 2		;*4: 4, 8, 12, 16, 20, 24
	mov	byte ptr ticks, al ;note duration (ticks); 1/4 note = 16/18.2

	mov	al, ah		;play note's pitch
	add	al, base
	out	dx, al

	mov	al, 7Fh		;full volume
	out	dx, al
ih90:
	popa
	iret

score	db	(67-base)*6+4-1	;quarter note
	db	(74-base)*6+4-1
	db	(70-base)*6+6-1	;dotted quarter note
	db	(69-base)*6+2-1	;eigth note

	db	(67-base)*6+2-1
	db	(70-base)*6+2-1
	db	(69-base)*6+2-1
	db	(67-base)*6+2-1
	db	(66-base)*6+2-1
	db	(69-base)*6+2-1
	db	(62-base)*6+4-1

	db	(67-base)*6+2-1
	db	(62-base)*6+2-1
	db	(69-base)*6+2-1
	db	(62-base)*6+2-1
	db	(70-base)*6+2-1
	db	(69-base)*6+1-1	;sixteenth note
	db	(67-base)*6+1-1
	db	(69-base)*6+2-1
	db	(62-base)*6+2-1

	db	(67-base)*6+2-1
	db	(62-base)*6+1-1
	db	(67-base)*6+1-1
	db	(69-base)*6+2-1
	db	(62-base)*6+1-1
	db	(69-base)*6+1-1
	db	(70-base)*6+2-1
	db	(69-base)*6+1-1
	db	(67-base)*6+1-1
	db	(69-base)*6+1-1
	db	(62-base)*6+1-1

	db	(74-base)*6+1-1
	db	(72-base)*6+1-1
	db	(70-base)*6+1-1
	db	(69-base)*6+1-1
	db	(67-base)*6+1-1
	db	(70-base)*6+1-1
	db	(69-base)*6+1-1
	db	(67-base)*6+1-1
	db	(66-base)*6+1-1
	db	(69-base)*6+1-1

	db	(67-base)*6+1-1
	db	0

oldint	dw	?, ?		;original interrupt handler vector
	end	start
