.model   tiny

; Compile with tasm, link with tlink /t!

.code
org     0100h

start:  jmp     begin

margins db      1bh,"[3;22r",1bh,"[?6h",'$'
top     db      1bh,"#3Lovebyte",13,10,'$'
year    db      "2025"

resetv  db      1bh,"[?3l",'$'
scrup   db      1bh,"M",'$'

onesec  dw      0f000h

hwidth  db      12, 14, 16, 18, 20, 20, 20, 20, 18, 16, 14, 12, 10, 8, 6, 4, 2
swidth  db      6, 4, 2

charuse dw      1h

; place line number in ah
; assumes es is set to video ram
; di is the offset at exit
proc    findline
        mov     di, 12h
        
lsearch: 
        cmp     ah, 1
        je      found        

        mov     al, [es]:di
        cmp     al, 0ffh
        je      lend
        inc     di
        jmp     lsearch   
        
lend:   inc     di
        mov     di, [es]:di
        dec     ah
        jmp     lsearch
        
found:  
        ret
        endp

;       ah is line start
;       al is character
;       bx is array address
proc    drawarr
        xor     cx, cx
        
line:
        push    ax
        ; store a copy of the line number to ah for findline
        call findline
        mov     cl, BYTE PTR [bx]
        add     di, 40
        sub     di, cx
        add     cl, BYTE PTR [bx]
        pop     ax
        rep stosb
        cmp     BYTE PTR [bx], 2
        jle     ddone
        inc     ah
        inc     bx
        jmp line

ddone:  ret
        endp

proc    heart
        
        ; line number is in ah
        mov     ah, 4
        lea     bx, hwidth
        mov     al, 1
        call drawarr        

        ; line number is in ah
        mov     ah, 4
        lea     bx, swidth
        mov     al, 0
        call drawarr
        
hdone:
        ret
        endp
        
; pass the size of the delay loop
; in bx
proc    delay
        
delay2: dec     bx
        nop
        cmp     bx, 0
        jnz     delay2

        ret
        endp

proc    keyready

kready: in      al, 11h
        and     al, 1
        cmp     al, 1
        jne     kready
        ret
        endp

proc    vol
        call keyready
        mov     al, 1bh
        out     10h, al
        mov     al, 01h
        out     11h, al
        call keyready

        mov     al, bl
        out     10h, al
        mov     al, 01h
        out     11h, al
        
        ret
        endp
        
proc    tick
        call keyready
        
        mov     al, 9fh
        out     10h, al
        mov     al, 01h
        out     11h, al
        
        ret
        endp

proc    modline

        mov     si, 0ff00h

        ; increments the char value if the
        ; routine has been called 20 times
        mov     dx, charuse
        cmp     dh, 20
        jl      modcont
        mov     dh, 0
        inc     dl
        cmp     dl, 11
        jl      modcont
        mov     dl, 0
modcont:
        inc     dh
        mov     charuse, dx

        xor     dh, dh
        lea     di, top
        add     di, dx
        mov     dl, BYTE PTR [di]
        

nextmod: 
        mov     al, BYTE PTR [si]
        cmp     al, 0
        je      skipmod
        mov     BYTE PTR [si], dl

skipmod:
        inc     si
        cmp     si, 0ff50h
        jge     modded
        jmp     nextmod
        
modded: ret
        endp

; string at dx
proc    outsc
        mov     ah, 09h
        int     21h
        ret
        endp

proc    setuplines
        
        ; 1bh,"#3Lovebyte 2025",13,10,'$'
        lea     dx, top
        call outsc
        
        ; line 2
        mov     di, dx
        add     di, 2
        mov     BYTE PTR [di], 34h
        ;1bh,"#4Lovebyte 2025",13,10,'$'
        call outsc
                
        add     dx, 11
        mov     cx, 21

        ;13,10,'$'
down:   call outsc
        loop    down
        
        sub     dx, 11
        ;1bh,"#4Lovebyte 2025",13,10,'$'
        inc     di
        mov     BYTE PTR [di], 24h
        ;1bh,"#4",'$'
        call outsc

        lea     dx, scrup
        call outsc

        lea     dx, top
        dec     di
        mov     BYTE PTR [di], 33h
        ;1bh,"#3",'$'
        call outsc
        
        lea     dx, scrup
        call outsc

        lea     dx, margins
        call outsc
        
        ret
        endp

proc    bline
        push ax
        call findline
        pop ax
        mov     cx, 35
        rep     stosb
        
        inc     di
        lea     si, year
        mov     cx, 4
        rep     movsb        
        
        ret
        endp

proc    tline
        push    ax
        call findline        
        pop     ax
        add     di, 9
        ;mov     al, 11h
        mov     cx, 31
        rep stosb
        ret
        endp

begin:  lea     dx, resetv
        call outsc
        
        ; So the OSSC can catch up
        mov     bx, onesec
        call    delay

        call setuplines

        ; Walk entire screen
        mov     dx, 0ee00h
        mov     es, dx
        
        ;mov     ah, 1
        mov     ax, 0111h
        call    tline
        ;call findline        

        ;add     di, 9
        ;mov     al, 11h
        ;mov     cx, 31
        ;rep stosb
        
        ;mov     ah, 2
        mov     ax, 0213h
        call    tline
        ;call findline
        
        ;add     di, 9    
        ;mov     al, 13h
        ;mov     cx, 31
        ;rep     stosb        

        ;mov     ah, 23
        ;mov     al, 11h
        mov     ax, 1711h
        call bline
                
        ;mov     ah, 24
        ;mov     al, 13h
        mov     ax, 1813h
        call bline
        
        call    heart
        
        mov     bx, onesec
        call    delay

        ; modify our string for symbol use
        ; chars   db      01h, 1ch, 1fh, 7eh 
        ; top     db      1bh,"#3Lovebyte",13,10,'$'

        lea     di, top
        mov     WORD PTR [di], 0201h
        add     di, 2
        mov     WORD PTR [di], 4c1fh
        
        ; scroll the heart
        mov     bx, 80h
        
scrh:   lea     dx, scrup
        ;push cx
        mov     ah, 22

        call findline
        push ds
        push es
        pop ds
        pop es
        push di
        pop si
        mov     di, 0ff00h
        mov     cx, 80
        rep movsb
        push es
        push ds
        pop es
        pop ds
        sub     si, 80
        mov     di, si
        
        call outsc
        
        call modline

        mov     ah, 3
        call findline
                
        mov     si, 0ff00h
        mov     cx, 80
        rep     movsb

        call tick
        
        inc     bx
        cmp     bx, 87h
        jle     norma
        mov     bx, 80h

norma:  call vol
        jmp     scrh
        
        
done:   
        ;mov     ah,4ch
        ;mov     al,0
        ;int     21h

        ret        
        end start
