;------------------------------
;Agricultural fields from above
;
;code by Gordian
;csdb.dk/scener/?id=37254
;
;128b intro
;Lovebyte 2025
;
;126 bytes of code
;2 bytes of header
;128 bytes total
;------------------------------

.TARGET_SIZE=128

INK=$09 ;must be>=8
BG=$05
LINES=24

*=$25e4 ;SYS 9700

.CODE_START
   sei
   
   lda #INK
   sta $d021
   sta $36
   jsr $e536
   
;Generate vertical
;scroll routine

   ldx #LINES-1
   stx $35
---   
   jsr $e9f0

   ldy #0
--   
   lda #$ad
   sta ($35),y
   iny
   lda $d1
   sta ($35),y
   iny
   lda $d2
   sta ($35),y
   iny
   
   lda #$8d
   sta ($35),y
   iny   
   lda $d1
   clc
   adc #40
   sta ($35),y
   iny
   lda $d2
   adc #0
   sta ($35),y  
   iny
   
   inc $d1
   bne +
   inc $d2
+   
   cpy #240
   bne --

   tya
   
   jsr $b699
  
   dex
   bpl ---
   
   lda #$60
   sta (INK*256+LINES-1)+LINES*40*6

MainLoop
   lda #$f0|BG
   sta $d020
   sta $d021    
-
   cmp $d012
   bne -
 
   lda #$18
   isc $d011
   bne +
   
;ShiftScreen
   lda #$10
   sta $d011

   jsr INK*256+23
   
   inc RndPtr

+  
;Draw line 0   
   ldy #39
-
   lda #$4e
RndPtr=*+1   
   ldx $00,y
   bmi +
   eor #3
+
   sta $0400,y
   dey
   bpl -
   
   bne MainLoop

.CODE_END

.DATA_START   
.DATA_END

!if(.TARGET_SIZE<=64){
.HEADER_SIZE=0
}else{
.HEADER_SIZE=2
}

!message "  ----- code section is ", (.CODE_END - .CODE_START), " bytes long"
!message "  ----- data section is ", (.DATA_END - .DATA_START), " bytes long"
!message "  ----- prg has ", (.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes, with basic has ", (.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes"
!message "  ----- w/o basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + .HEADER_SIZE) , " bytes free, with basic ", .TARGET_SIZE-(.DATA_END - .CODE_START + 12 + .HEADER_SIZE) , " bytes free"   