
struct PointLight
{
    vec3 position;
    vec3 color;
    float invSqRange;   // 1.0 / (range * range)
};

struct LightingInfo
{
    vec3 diffuse;
    vec3 specular;
    //float intensity;
};

LightingInfo EvalPointLight(PointLight light, vec3 inPosition, vec3 N, vec3 V)
{
    LightingInfo result;

#if 0
    vec3 L = normalize(light.position-inPosition);
    float atten = 1.0;
#else
    vec3 toLight = light.position-inPosition;
    float lenSqr = dot(toLight, toLight);
    float lenRecipSqr = inversesqrt(lenSqr);
    float atten = max(1.0 - lenSqr * light.invSqRange, 0.0);
    vec3 L = toLight * lenRecipSqr;
#endif

    vec3 R = reflect(-L, N);
    
    const float kPi = 3.14159265;
    const float kShininess = 22.0;  // phong exponent
    const float kEnergyConservation = ( 2.0 + kShininess ) / ( 2.0 * kPi );

    float lambert = max(dot(N, L), 0.0f) * atten;
    float phong = kEnergyConservation * pow(max(dot(V,R), 0.0), kShininess);

    //result.intensity = EvalLightGlow(inPosition, lightPos, cameraPosition, V, 2.2f);

    result.diffuse = lambert * light.color; // * intensity * lightProjector;
    result.specular = phong * vec3(1,1,1); // * 0.02f * specularAmount;

    return result;
}
