#version 130

uniform float iTime;
uniform vec3 topColor = vec3(0.2, 0.8, 0.2);    // Color for the top half
uniform vec3 bottomColor = vec3(0.2, 0.2, 0.8); // Color for the bottom half
uniform float waveFrequency = 0.8;       // Frequency of the wave
uniform float waveAmplitude = 0.2;       // Amplitude of the wave
uniform float waveDetailFrequency = 8.0; // Frequency for additional detail waves
uniform float waveDetailAmplitude = 0.1;  // Amplitude for additional detail waves

void main() {
    // Normalize coordinates
    // vec2 uv = fragCoord.xy / iResolution.xy;
    vec2 uv = gl_TexCoord[0].xy;
    
    // Calculate the main wave position based on sine function
    float wave = sin(uv.x * waveFrequency + iTime * 4) * waveAmplitude;
    
    // Calculate additional detail wave
    float detailWave = sin(uv.x * waveDetailFrequency + iTime*4) * waveDetailAmplitude;

    // Determine the y-position of the combined wave
    float waveY = 0.5 + wave + detailWave; // Centered in the screen

    // Set base color based on the position of the fragment
    vec3 color;
    if (uv.y > waveY) {
        color = bottomColor; // Color for the bottom half
    } else {
        color = topColor; // Color for the top half
    }

    // Create gradient for the wavy line
    float lineGradient = smoothstep(waveY - 0.02, waveY + 0.02, uv.y);
    color = mix(bottomColor, topColor, lineGradient); // Gradient along the line

    // Output the final color
    gl_FragColor = vec4(color, 1.0); // Output final color
}
