        output "VCC2024.COM"

        org  0x0100

BDOS:       equ     0x0005
C_WRITE:    equ     2
C_WRITESTR: equ     9

; data is executed as a meaningless code, but as a side effect E = 9
        db   "+-! "
str2:   db   9, "\\O/$"

        ; print bow on the top of the box
        ld   c, e       ; C = 9 (C_WRITESTR)
        ld   de, str2
        call BDOS

        ld   c, 19      ; Y
.loop2: ld   b, 19      ; X
        call PrintCrLf
.loop1: inc  h          ; H = 1 (after BDOS call, H = 0)
        ld   a, b
        call Mod9       ; A = SGN(X MOD 9)
        ld   e, a       ; save result
        ld   a, c
        call Mod9       ; A = SGN(Y MOD 9)
        add  a, a
        add  a, e

        ; get char from table
        ld   l, a
        ld   e, (hl)
        call PrintE

        djnz .loop1
        dec  c          ; Y = Y - 1
        jr   nz, .loop2
        ; falls to PrintCrLf

PrintCrLf:
        ld   e, 13
        call PrintE
        ld   e, 10
        ; falls to PrintE

PrintE: push bc
        ld   c, C_WRITE
        call BDOS
        pop  bc
        ret

Mod9:
; input:  A = 1..19 (X or Y coord)
; output: A = !!((A - 1) % 9)
        dec  a
        ret  z
        sub  9
        ret  z
        sub  9
        ret  z
        ld   a, h           ; A = 1
        ret

        end
