; Commodore C64 entry for VCCC2024 by GeirS, 2024-12-22.
; Size: 45 bytes excl. load address. Assemble using 64tass.
; Requires loading at specific address (e.g. LOAD "PRESENT",8,1) and SYS 2308 to start.

StrOut          = $ab1e             ; Print null-terminated string pointed to by A and Y
NewLine         = $aad7             ; Print new line char
BoxChars        = $fd8d             ; Contains values 32 and 45
EorValues       = $b91e             ; Contains values 1 and 6
Crsw            = $d0               ; Flag: INPUT or GET from keyboard
Pnt             = $d1               ; Pointer to current screen line
Pntr            = $d3               ; Cursor column on current line
Every9thRow     = $2b               ; Variable for determining every 9th row (1 at startup)
Every9thCol     = $11               ; Variable for determining every 9th column (0 at startup)

                * = $0900           ; Load address

; Code and data (45 bytes)
                .byte 205,79,47,0   ; '\', 'O', '/', 0
Start           ldy #9              ; Column number and hi byte of address of ribbon chars
                sty Pntr            ; Set cursor column
                jsr StrOut          ; Print ribbon
RowLoop         cpx #1              ; Set carry flag to 9th bit of Every9thRow
                ror Every9thRow
                rla Crsw            ; Set acc. to 1 if carry is set, else 0
                tax                 ; Index to 'BoxChars'
                jsr NewLine         ; Print new line char (also sets 'Crsw' to zero)
                inc Every9thCol     ; Set initial value for current row
                ldy #19             ; 19 columns per row
ColLoop         lda BoxChars,x      ; Get space or '-'
                ror Every9thCol
                bcc PutChar         ; Branch if not 0th, 9th or 18th column
                eor EorValues,x     ; Change space to '!' or '-' to '+'
PutChar         sta (Pnt),y         ; Put char on screen
                dey
                bne ColLoop         ; Loop for all columns
                asl $46,x           ; Contains word $2400 at startup
                bcc RowLoop         ; Loop for all rows
                rts
