; Logiker X-mas challenge 2024
; By DDT, on 20241224
; Use 64tass assembler and run on C64.

  * = $0801   ; C64
  .word end_BASIC
  .word 10
  .byte $9e ; SYS
    .text "2061", $00 ; C64
end_BASIC:
  .word 0

PTR_PACKED = $FA
ROWS_RUN_COUNTER = $FC

main:
        lda #<packed
        sta PTR_PACKED
        lda #>packed
        sta PTR_PACKED+1
        
next_rows_run:
        ldy #0
        lda (PTR_PACKED),y
        sta ROWS_RUN_COUNTER
        bne nxt_char
        
        ; End of packed data.
        ; Draw ribbon
        lda #$4e
        sta $0438
        lda #$4d
        sta $0436
        rts                     ; ALL DONE

nxt_char:
        iny ; Point to char
        cpy #6
        beq end_of_row
        
        ; Depack
depack: 
        tya
        and #1
        tax
        bne +
        ldx #8
+       lda (PTR_PACKED),y
scrst:  sta $0456               ; Unpack address.
        inc scrst+1
        bne +
        inc scrst+2
+       dex
        bne scrst
        ; Next char to depack.
        beq nxt_char            ; Branch always

end_of_row:     
+       ; Prepare next row.
        clc
        lda scrst+1
        adc #21
        sta scrst+1
        bcc +
        inc scrst+2
+       ldy #0
        ; Decrease rows run counter.
        dec ROWS_RUN_COUNTER
        bne nxt_char

end_of_rows_run:
        lda PTR_PACKED
        ;clc
        adc #6
        sta PTR_PACKED
        ;bcc +
        ;inc PTR_PACKED+1
;+
        bne next_rows_run       ; Branch always


packed:
.byte 1
.byte '+', '-', '+', '-', '+'
.byte 8
.byte '!', ' ', '!', ' ', '!'
.byte 1
.byte '+', '-', '+', '-', '+'
.byte 8
.byte '!', ' ', '!', ' ', '!'
.byte 1
.byte '+', '-', '+', '-', '+'
.byte 0
