; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the TRS80 Model 4 computer.
; -Dave / Bushy555.
;
; Execution assumptions:
; (First program to run immediately after emulator is ran)
;
; Binary Snapshot
; ================
;  12 bytes :  snapshot header. Not included in the source.
; 117 bytes :  code
; 129 bytes :  total file size.
; 485 bytes :  source size.
;
; Assemble with PASMO.EXE Z80 assembler.
; PASMO --alocal file.asm file.bin
; trs80-tool.exe convert --start 0x6000 file.bin file.cmd
;
;
; Execution/use/Instructions
; ===========================
; Use TRS80 Emulator "trs80gp.exe"
; Find/download/install/run
; Configure for 'TRS80 model 4' by FILE --> Chnage Model --> Model 4.
; File --> Run --> Select  'file.cmd'  (".\TRS80-4\CHRISTMAS_PRESENT.CMD)
; Program will autorun / autoexecute.
;
;
;
; NOTES
; ========
; Video ram is at $F800.

	org	$6000		; Program runs at $6000 in RAM.
				


	xor	a		; generic CLS for TRS80-4
	ld	hl, $f800
	ld	de, $f801
	ld	(hl), a
	ld	bc, 80*24
	ldir
	
	ld	hl, line1		; display first line (RIBBON)
	ld	de, $f808
	call	display


	inc	hl
	ld	de, $f800+80
	call	display

	

	ld	b, 2
loop1:	push	bc
	ld	b, 61			; dunno any of the TR80's ROM routines to "display HL" etc.
loop2:	inc	de
	djnz	loop2
	ld	b, 8
loop3:	push	bc
	ld	hl, line3
	call	display
	ld	b, 61			; dunno any of the TR80's ROM routines to "display HL" etc.
loop4:	inc	de
	djnz	loop4
	pop	bc
	djnz	loop3
	ld	hl, line2
	call	display
	pop	bc
	djnz	loop1


here:	jr	here


display:ld	a, (hl)			; Display message, character-by-character until reads a zero byte.
	and	a
	ret	z
	ld	(de), a
	inc	hl
	inc	de
	jr	display

	

line1 db '\O/',0
line2 db '+--------+--------+',0
line3 db '!        !        !',0






;
;        \0/
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;