; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the TRS80 Model 1 computer.
; -Dave / Bushy555.
;
; NOTE: TRS80 model 1 does not have the forward slash character.
; As such, the first line (the ribbon) was modified to have these characters:    >O<
;
;
; Execution assumptions:
; (First program to run immediately after emulator is ran)
;
; Binary Snapshot
; ---------------
;  12 bytes :  snapshot header. Not included in the source.
; 121 bytes :  code
; 133 bytes :  total file size.
; 505 bytes :  source size.
;
; Assemble with PASMO.EXE Z80 assembler.
; PASMO --alocal file.asm file.bin
; trs80-tool.exe convert --start 0x6000 file.bin file.cmd
;
;
; Execution/use/Instructions
; ===========================
; Use TRS80 Emulator "trs80gp.exe"
; Find/download/install/run
; Configure for 'TRS80 model 1' by FILE --> Change Model --> Model 1.
; File --> Run --> Select  'file.cmd'  (".\TRS80-1\CHRISTMAS_PRESENT.CMD)
; Program will autorun / autoexecute.

; Video ram is at $3C00.  Display is 64x16.

	org	$6000		; Program runs at $6000 in RAM.
				

	ld	a, 32		;TRS80-1 CLS
	ld	hl, $3C00
	ld	de, $3C01
	ld	(hl), a
	ld	bc, 64*16
	ldir
	
	ld	hl, line1		; display first line (modified RIBBON)
	ld	de, $3C08
	call	display


	inc	hl
	ld	hl, line2
	ld	de, $3C00+64
	call	display



	ld	b, 2
loop1:	push	bc
	ld	b, 45			; dunno any of the TR80's ROM routines to "display HL" etc.
loop2:	inc	de
	djnz	loop2

	ld	b, 8
loop3:	push	bc
	ld	hl, line3
	call	display

	ld	b, 45			; dunno any of the TR80's ROM routines to "display HL" etc.
loop4:	inc	de
	djnz	loop4

	pop	bc
	djnz	loop3
	ld	hl, line2
	call	display

	pop	bc
	djnz	loop1


here:	jr	here




display:ld	a, (hl)			; Display message, character-by-character until reads a zero byte.
	and	a
	ret	z
	ld	(de), a
	inc	hl
	inc	de
	jr	display


line1 db 62,79,60,0 
line2 db '+--------+--------+',0
line3 db '!        !        !',0




;
;        \0/
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;