; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the Jupiter Ace z80 computer.
; -Dave / Bushy555.
;
; Execution assumptions:
; (First program to run immediately after emulator is ran)
;
; Binary Snapshot
; ---------------
;  0  bytes :  Header
;  95 bytes :  code
;  95 bytes :  total file size.
; 325 bytes :  source size.
;
; Assemble with PASMO.EXE Z80 assembler.
; PASMO --alocal file.asm file.bin

	ORG	$4000
;		Program start  at    	$4000
; 		Video RAM is at 	$2400
CLS             equ     $0A24         	; Clear Screen ROM routine.


	call	CLS			; Jupiter ACE ROM CLS.


	ld	hl, d1			; Select Line 1 to display
	ld	de, $2408		; Position 9, top row in Video ram.
	ld	bc, 3			; 3 Characters of the ribbon to dispay.
	ldir				; display the ribbon. (Move 3 chars from Line 1 to video ram)
	
					; Display line 2.  Register HL already pointing to line 2 'e1' coz its after line 1 'd1'
	ld	hl, e1			; Select Line 1 to display
	call	display

	ld	e, 2			; Use register E as a two-loop counter. 
a1:	ld	b, 8			; Set register B as counter in order to display Line 3 eight times.
	
b1:	ld	hl, f1			; Select Line 3 to display.
	call	display
	djnz	b1			; Loop back for another go.  Two loops.  Reduces register B and jumps back to label 'b1'

	ld	hl, e1			; Select line 2 to display within the two counter loop.
	call	display

	dec	e			; Outer two counter loop. Reduces register from 2 to 1.
	jr	nz, a1			; Jumps if zero flag is not yet set. Ie, if register E is still 2 or 1. Will drop thru when E=0.

c1: 	jr	c1			; Forever loop to show screen. The opcode HALT doesnt work very well on the VZ/Laser.


display:ld	a, (hl)			
	and	a
	ret	z
	rst	8			; restart 8 is display char in Reg A to screen.
	inc	hl
	jr	display

d1: defb '\O/'				; Line 1 : Ribbon. 
e1: defb $d,'+--------+--------+',0	; Line 2 : Top and middle and bottom of the Christmas present box.
f1: defb $d,'!        !        !',0	; Line 3 : in between bits of the Christmas present box.


