;----------------------------------------------------------
	device zxspectrum48
;----------------------------------------------------------

	org 25619

;	47 bytes
;	bc: #6413
;	hl: #2d2b
				; y coordinate in c (#13 = 19)
loop_y:
	ld b,19			; initial x coorditate
loop_x:
	call #200a		; set coordinates (coordinates in bc)
				; after extcuting function x coordinate in accumulator
	call proc0		; put character ' ' in register e and checking value for 1, 10, 19; result in flag z
	ld d,h			; put character code into d from h ('-' (#2d) in h)
	jr nz,label1
	inc e			; replace character ' ' (code #20) with character '!' (code #21) in register e
	ld d,l			; put character code into d from l ('+' (#2b) in l)
label1:

	ld a,c			; y coordinate
	call proc		; checking value for 1, 10, 19; result in flag z
	ld a,e			; put character code in accumulator ('!' or ' ')
	jr nz,label2
	ld a,d			; if flag z is cleared, put another character code in accumulator ('+' or '-')
label2:

	rst 16			; print current character

	djnz loop_x		; decrease coordinate x and jump to loop_x if x != 0

	dec c
	jr nz,loop_y		; jump to loop_y if y != 0

	ld b,9			; in register bc coordinates of the "gift tie" (b = 9, c = 0)
	call #200a		; set coordinates (coordinates in bc)
	ld a,'\'		; put characters '\O/' in registers a and bc
	ld bc,'/' *256+ 'O'
	defb #c3		; #c31e20 - jp #201e; print three characters: "\O/" and completion of program
proc0:
	defb #1e		; #1e20 - ld e,#20 (character ' ')
	defb #20

; procedure returns the flag z with the counter is equal to 1 or a multiple of 9
; or exits on overflow
; in: coordinate in accumulator
proc:
	dec a
proc_loop:
	ret z
	ret m
	sub 9
	jr proc_loop

;----------------------------------------------------------
	savebin "vc24.bin",start,end-start
	savetap "vc24.tap",code,"vc24",start,end-start
;----------------------------------------------------------