#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct GPUHashMapInsertResult
{
    uint slot;
    bool duplicate;
};

struct InstancingGeneratorParams
{
    int seed;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float surface_distance;
    vec3 instance_scale;
    int alpha_to_modifier_factor;
    vec3 duplicate_elimination_position_decimation;
    int duplicate_elimination_position;
    vec3 duplicate_elimination_position_decimation_rcp;
    float duplicate_elimination_normal_decimation;
    float duplicate_elimination_normal_decimation_rcp;
    int duplicate_elimination_normal;
    float min_face_size;
    int _pad0;
};

struct ModifierFactorNormal_Params
{
    vec3 direction;
    int wraparound;
    uint modifier_function;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct InstanceModifierLookAt_Params
{
    vec3 ref_position;
    int look_away;
    int axis;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct InstanceModifierFactorToColor_Params
{
    vec3 color;
    int use_gradient;
    int color_gradient_idx;
    int mixing_mode;
};

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct ModifierFactorSet_Params
{
    float value;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _404;

layout(set = 0, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _463;

layout(set = 0, binding = 3, std430) buffer DuplicateEliminationHashMapKeysBuffer
{
    GPUHashMapHeader header;
    uint64_t keys[];
} duplicate_elimination_hashmap;

layout(set = 0, binding = 4, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _673;

layout(set = 0, binding = 11, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _2249;

layout(set = 0, binding = 12, std140) uniform VM0
{
    ModifierFactorNormal_Params VM0_params;
} _2457;

layout(set = 0, binding = 13, std140) uniform VM1
{
    layout(row_major) ModifierFactorDistancePlane_Params VM1_params;
} _2472;

layout(set = 0, binding = 14, std140) uniform VM2
{
    ModifierFactorMulAdd_Params VM2_params;
} _2487;

layout(set = 0, binding = 5, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _2641;

layout(set = 0, binding = 15, std140) uniform VM3
{
    ModifierFactorSet_Params VM3_params;
} _2720;

layout(set = 0, binding = 16, std140) uniform VM4
{
    InstanceModifierLookAt_Params VM4_params;
} _2727;

layout(set = 0, binding = 17, std140) uniform VM5
{
    layout(row_major) ModifierFactorNoise_Params VM5_params;
} _2753;

layout(set = 0, binding = 18, std140) uniform VM6
{
    InstanceModifierRandomizerV2_Params VM6_params;
} _2768;

layout(set = 0, binding = 6, std430) buffer VM7
{
    InstanceModifierFactorToColor_Params VM7_params;
} _2786;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _2802;

layout(set = 0, binding = 8, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2825;

layout(set = 0, binding = 9, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _2845;

layout(set = 0, binding = 10, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _2853;

layout(set = 0, binding = 19) uniform sampler2D s_Curves;
layout(set = 0, binding = 20) uniform sampler2D s_Gradients;

uint particle_emitter_geometry_get_first_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _673.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _673.transformed_data_location[tdl_idx].last_face_idx;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _463.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _463.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _463.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_404.in_vtx_data[coord_offset + 0u], _404.in_vtx_data[coord_offset + 1u], _404.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_404.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _382 = hash(param);
    uint param_1 = _382;
    float _384 = floatConstruct(param_1);
    return _384;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_normal(ModifierFactorNormal_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 normal = modifier_factor.normal;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = normal;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        normal = vector_transform_by_mat33(param, param_1);
    }
    float v = dot(normal, modifier_params.direction);
    if (modifier_params.wraparound != 0)
    {
        v = abs(v);
    }
    if (v < 0.0)
    {
        v = 0.0;
    }
    ModifierFactor param_2 = modifier_factor;
    uint param_3 = modifier_params.modifier_function;
    float param_4 = v;
    modifier_process_modifier_factor(param_2, param_3, param_4);
    modifier_factor = param_2;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _767 = vector_transform_by_mat43(param, param_1);
        coords = _767;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _774 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _774;
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_4 = modifier_params.falloff_curve_idx;
    float param_5 = influence;
    influence = curve_sample(param_4, param_5);
    float v = influence;
    ModifierFactor param_6 = modifier_factor;
    uint param_7 = uint(modifier_params.modifier_function);
    float param_8 = v;
    modifier_process_modifier_factor(param_6, param_7, param_8);
    modifier_factor = param_6;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

uint64_t GPUHashMapHash64(inout uint64_t h)
{
    h ^= (h >> 33);
    h *= 18397679294719823053ul;
    h ^= (h >> 33);
    h *= 14181476777654086739ul;
    h ^= (h >> 33);
    return h;
}

GPUHashMapInsertResult duplicate_elimination_hashmap_insert(uint64_t key)
{
    GPUHashMapInsertResult res;
    res.slot = 4294967295u;
    res.duplicate = false;
    uint64_t param = key;
    uint64_t _608 = GPUHashMapHash64(param);
    uint64_t hash_1 = _608;
    uint slot = uint(hash_1 & uint64_t(duplicate_elimination_hashmap.header.capacity - 1u));
    for (;;)
    {
        if (true)
        {
            uint64_t _634 = atomicCompSwap(duplicate_elimination_hashmap.keys[slot], 18446744073709551615ul, key);
            uint64_t prev = _634;
            if ((prev == 18446744073709551615ul) || (prev == key))
            {
                res.slot = slot;
                res.duplicate = prev == key;
                return res;
            }
            slot = (slot + 1u) & (duplicate_elimination_hashmap.header.capacity - 1u);
            continue;
        }
        else
        {
            break;
        }
    }
    return res;
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec4 _mat3ToQuaternion(mat3 r)
{
    float trace = (r[0].x + r[1].y) + r[2].z;
    vec4 q;
    if (trace > 0.0)
    {
        float s = sqrt(trace + 1.0) * 2.0;
        q.w = 0.25 * s;
        q.x = (r[2].y - r[1].z) / s;
        q.y = (r[0].z - r[2].x) / s;
        q.z = (r[1].x - r[0].y) / s;
    }
    else
    {
        bool _886 = r[0].x > r[1].y;
        bool _894;
        if (_886)
        {
            _894 = r[0].x > r[2].z;
        }
        else
        {
            _894 = _886;
        }
        if (_894)
        {
            float s_1 = sqrt(((1.0 + r[0].x) - r[1].y) - r[2].z) * 2.0;
            q.w = (r[2].y - r[1].z) / s_1;
            q.x = 0.25 * s_1;
            q.y = (r[0].y + r[1].x) / s_1;
            q.z = (r[0].z + r[2].x) / s_1;
        }
        else
        {
            if (r[1].y > r[2].z)
            {
                float s_2 = sqrt(((1.0 + r[1].y) - r[0].x) - r[2].z) * 2.0;
                q.w = (r[0].z - r[2].x) / s_2;
                q.x = (r[0].y + r[1].x) / s_2;
                q.y = 0.25 * s_2;
                q.z = (r[1].z + r[2].y) / s_2;
            }
            else
            {
                float s_3 = sqrt(((1.0 + r[2].z) - r[0].x) - r[1].y) * 2.0;
                q.w = (r[1].x - r[0].y) / s_3;
                q.x = (r[0].z + r[2].x) / s_3;
                q.y = (r[1].z + r[2].y) / s_3;
                q.z = 0.25 * s_3;
            }
        }
    }
    return q;
}

vec4 _slerp(inout vec4 q1, inout vec4 q2, float t)
{
    q1 = normalize(q1);
    q2 = normalize(q2);
    float _dot = dot(q1, q2);
    if (_dot < 0.0)
    {
        q2 = -q2;
        _dot = -_dot;
    }
    if (_dot > 0.999499976634979248046875)
    {
        vec4 result = mix(q1, q2, vec4(t));
        return normalize(result);
    }
    float theta_0 = acos(_dot);
    float theta = theta_0 * t;
    float sin_theta = sin(theta);
    float sin_theta_0 = sin(theta_0);
    float s1 = cos(theta) - ((_dot * sin_theta) / sin_theta_0);
    float s2 = sin_theta / sin_theta_0;
    return (q1 * s1) + (q2 * s2);
}

mat3 _quaternionToMat3(inout vec4 q)
{
    q = normalize(q);
    float xx = q.x * q.x;
    float yy = q.y * q.y;
    float zz = q.z * q.z;
    float xy = q.x * q.y;
    float xz = q.x * q.z;
    float yz = q.y * q.z;
    float wx = q.w * q.x;
    float wy = q.w * q.y;
    float wz = q.w * q.z;
    mat3 m;
    m[0].x = 1.0 - (2.0 * (yy + zz));
    m[0].y = 2.0 * (xy - wz);
    m[0].z = 2.0 * (xz + wy);
    m[1].x = 2.0 * (xy + wz);
    m[1].y = 1.0 - (2.0 * (xx + zz));
    m[1].z = 2.0 * (yz - wx);
    m[2].x = 2.0 * (xz - wy);
    m[2].y = 2.0 * (yz + wx);
    m[2].z = 1.0 - (2.0 * (xx + yy));
    return m;
}

void instance_modifier_look_at(InstanceModifierLookAt_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    vec3 ref_position = modifier_params.ref_position;
    vec3 pos = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    vec3 nx = vec3(instance.m0.x, instance.m1.x, instance.m2.x);
    vec3 ny = vec3(instance.m0.y, instance.m1.y, instance.m2.y);
    vec3 nz = vec3(instance.m0.z, instance.m1.z, instance.m2.z);
    vec3 dir = normalize(pos - ref_position);
    if (modifier_params.look_away != 0)
    {
        dir *= (-1.0);
    }
    vec3 nnx;
    vec3 nny;
    vec3 nnz;
    if (modifier_params.axis == 0)
    {
        nnx = dir;
        nny = normalize(ny);
        nnz = normalize(cross(nnx, nny));
        nny = cross(nnx, nnz);
    }
    else
    {
        if (modifier_params.axis == 1)
        {
            nny = dir;
            nnx = normalize(nx);
            nnz = normalize(cross(nny, nnx));
            nnx = cross(nny, nnz);
        }
        else
        {
            nnz = dir;
            nnx = normalize(nx);
            nny = normalize(cross(nnz, nnx));
            nnx = cross(nny, nnz);
        }
    }
    float nx_length = length(nx);
    float ny_length = length(ny);
    float nz_length = length(nz);
    mat3 m_src;
    m_src[0] = nx / vec3(nx_length);
    m_src[1] = ny / vec3(ny_length);
    m_src[2] = nz / vec3(nz_length);
    mat3 m_dst;
    m_dst[0] = nnx;
    m_dst[1] = nny;
    m_dst[2] = nnz;
    mat3 param = m_src;
    vec4 q_src = _mat3ToQuaternion(param);
    mat3 param_1 = m_dst;
    vec4 q_dst = _mat3ToQuaternion(param_1);
    vec4 param_2 = q_src;
    vec4 param_3 = q_dst;
    float param_4 = modifier_factor.factor;
    vec4 _1339 = _slerp(param_2, param_3, param_4);
    vec4 q_slerp = _1339;
    vec4 param_5 = q_slerp;
    mat3 _1343 = _quaternionToMat3(param_5);
    mat3 m_slerp = _1343;
    m_slerp[0] *= nx_length;
    m_slerp[1] *= ny_length;
    m_slerp[2] *= nz_length;
    vec3 _1365 = vec3(m_slerp[0].x, m_slerp[1].x, m_slerp[2].x);
    instance.m0.x = _1365.x;
    instance.m0.y = _1365.y;
    instance.m0.z = _1365.z;
    vec3 _1378 = vec3(m_slerp[0].y, m_slerp[1].y, m_slerp[2].y);
    instance.m1.x = _1378.x;
    instance.m1.y = _1378.y;
    instance.m1.z = _1378.z;
    vec3 _1391 = vec3(m_slerp[0].z, m_slerp[1].z, m_slerp[2].z);
    instance.m2.x = _1391.x;
    instance.m2.y = _1391.y;
    instance.m2.z = _1391.z;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1760 = vector_transform_by_mat43(param, param_1);
        coords = _1760;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1767 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1767;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _355 = hash(param);
    uint param_1 = v.z;
    uint _360 = hash(param_1);
    uint param_2 = (v.x ^ _355) ^ _360;
    uint _363 = hash(param_2);
    return _363;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _392 = floatConstruct(param_1);
    return _392;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void instance_modifier_factor_to_color(InstanceModifierFactorToColor_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance)
{
    vec3 c = vec3(1.0);
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = fract(modifier_factor.factor);
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color * modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 0)
    {
        instance.c.x = c.x;
        instance.c.y = c.y;
        instance.c.z = c.z;
    }
    if (modifier_params.mixing_mode == 1)
    {
        vec4 _2210 = instance.c;
        vec3 _2216 = mix(_2210.xyz, c, vec3(modifier_factor.factor));
        instance.c.x = _2216.x;
        instance.c.y = _2216.y;
        instance.c.z = _2216.z;
    }
    if (modifier_params.mixing_mode == 2)
    {
        vec4 _2230 = instance.c;
        vec3 _2232 = _2230.xyz + c;
        instance.c.x = _2232.x;
        instance.c.y = _2232.y;
        instance.c.z = _2232.z;
    }
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    InstancingGeneratorParams _2254;
    _2254.seed = _2249.instancing_generator_params.seed;
    _2254.transformed_data_location_idx = _2249.instancing_generator_params.transformed_data_location_idx;
    _2254.transformed_data_location_num = _2249.instancing_generator_params.transformed_data_location_num;
    _2254.surface_distance = _2249.instancing_generator_params.surface_distance;
    _2254.instance_scale = _2249.instancing_generator_params.instance_scale;
    _2254.alpha_to_modifier_factor = _2249.instancing_generator_params.alpha_to_modifier_factor;
    _2254.duplicate_elimination_position_decimation = _2249.instancing_generator_params.duplicate_elimination_position_decimation;
    _2254.duplicate_elimination_position = _2249.instancing_generator_params.duplicate_elimination_position;
    _2254.duplicate_elimination_position_decimation_rcp = _2249.instancing_generator_params.duplicate_elimination_position_decimation_rcp;
    _2254.duplicate_elimination_normal_decimation = _2249.instancing_generator_params.duplicate_elimination_normal_decimation;
    _2254.duplicate_elimination_normal_decimation_rcp = _2249.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
    _2254.duplicate_elimination_normal = _2249.instancing_generator_params.duplicate_elimination_normal;
    _2254.min_face_size = _2249.instancing_generator_params.min_face_size;
    _2254._pad0 = _2249.instancing_generator_params._pad0;
    InstancingGeneratorParams param = _2254;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    InstancingGeneratorParams _2260;
    _2260.seed = _2249.instancing_generator_params.seed;
    _2260.transformed_data_location_idx = _2249.instancing_generator_params.transformed_data_location_idx;
    _2260.transformed_data_location_num = _2249.instancing_generator_params.transformed_data_location_num;
    _2260.surface_distance = _2249.instancing_generator_params.surface_distance;
    _2260.instance_scale = _2249.instancing_generator_params.instance_scale;
    _2260.alpha_to_modifier_factor = _2249.instancing_generator_params.alpha_to_modifier_factor;
    _2260.duplicate_elimination_position_decimation = _2249.instancing_generator_params.duplicate_elimination_position_decimation;
    _2260.duplicate_elimination_position = _2249.instancing_generator_params.duplicate_elimination_position;
    _2260.duplicate_elimination_position_decimation_rcp = _2249.instancing_generator_params.duplicate_elimination_position_decimation_rcp;
    _2260.duplicate_elimination_normal_decimation = _2249.instancing_generator_params.duplicate_elimination_normal_decimation;
    _2260.duplicate_elimination_normal_decimation_rcp = _2249.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
    _2260.duplicate_elimination_normal = _2249.instancing_generator_params.duplicate_elimination_normal;
    _2260.min_face_size = _2249.instancing_generator_params.min_face_size;
    _2260._pad0 = _2249.instancing_generator_params._pad0;
    InstancingGeneratorParams param_1 = _2260;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float face_min_size_threshold = _2249.instancing_generator_params.min_face_size;
    float fid = float(id);
    float fid_seed = float(_2249.instancing_generator_params.seed);
    uint face_idx = id;
    face_idx += first_face_idx;
    uint param_2 = face_idx;
    RTFace rt_face = rt_get_face(param_2);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_3 = p0_idx;
    vec3 p0 = rt_get_vertex(param_3);
    uint param_4 = p1_idx;
    vec3 p1 = rt_get_vertex(param_4);
    uint param_5 = p2_idx;
    vec3 p2 = rt_get_vertex(param_5);
    float face_size = length(cross(p0 - p1, p0 - p2));
    if (face_size < face_min_size_threshold)
    {
        return;
    }
    uint param_6 = p0_idx;
    vec4 c0 = rt_get_vertex_color(param_6);
    uint param_7 = p1_idx;
    vec4 c1 = rt_get_vertex_color(param_7);
    uint param_8 = p2_idx;
    vec4 c2 = rt_get_vertex_color(param_8);
    float param_9 = fid_seed * 0.34130001068115234375;
    vec3 bc;
    bc.x = random(param_9);
    float param_10 = fid_seed * 0.1412999927997589111328125;
    bc.y = random(param_10);
    if ((bc.x + bc.y) >= 1.0)
    {
        bc.x = 1.0 - bc.x;
        bc.y = 1.0 - bc.y;
    }
    vec4 col = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
    vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
    vec3 nx = normalize(p0 - p2);
    vec3 ny = normalize(p0 - p1);
    vec3 nz = normalize(cross(nx, ny));
    ny = cross(nz, nx);
    ModifierFactor modifier_factor = modifier_factor_defaults();
    float _2427;
    if (_2249.instancing_generator_params.alpha_to_modifier_factor != 0)
    {
        _2427 = col.w;
    }
    else
    {
        _2427 = 1.0;
    }
    modifier_factor.factor = _2427;
    modifier_factor.hash = floatBitsToUint(fid_seed);
    modifier_factor.id = id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = true;
    modifier_factor.color = col;
    modifier_factor.normal = nz;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNormal_Params _2462;
    _2462.direction = _2457.VM0_params.direction;
    _2462.wraparound = _2457.VM0_params.wraparound;
    _2462.modifier_function = _2457.VM0_params.modifier_function;
    _2462.influence_scope = _2457.VM0_params.influence_scope;
    _2462._pad0 = _2457.VM0_params._pad0;
    _2462._pad1 = _2457.VM0_params._pad1;
    ModifierFactorNormal_Params param_11 = _2462;
    ModifierFactor param_12 = modifier_factor;
    CoordinateSystemTrasforms param_13 = cs_transforms;
    modifier_factor_normal(param_11, param_12, param_13);
    modifier_factor = param_12;
    ModifierFactorDistancePlane_Params _2477;
    _2477.transform_local_to_gizmo = _2472.VM1_params.transform_local_to_gizmo;
    _2477.falloff_curve_idx = _2472.VM1_params.falloff_curve_idx;
    _2477.falloff_inverse = _2472.VM1_params.falloff_inverse;
    _2477.domain_mirror = _2472.VM1_params.domain_mirror;
    _2477.domain_repeat = _2472.VM1_params.domain_repeat;
    _2477.influence_scope = _2472.VM1_params.influence_scope;
    _2477.modifier_function = _2472.VM1_params.modifier_function;
    ModifierFactorDistancePlane_Params param_14 = _2477;
    ModifierFactor param_15 = modifier_factor;
    CoordinateSystemTrasforms param_16 = cs_transforms;
    modifier_factor_distance_plane(param_14, param_15, param_16);
    modifier_factor = param_15;
    ModifierFactorMulAdd_Params _2492;
    _2492.multiply_value = _2487.VM2_params.multiply_value;
    _2492.add_value = _2487.VM2_params.add_value;
    ModifierFactorMulAdd_Params param_17 = _2492;
    ModifierFactor param_18 = modifier_factor;
    modifier_factor_mul_add(param_17, param_18);
    modifier_factor = param_18;
    bool _2500 = modifier_factor.factor <= 9.9999997473787516355514526367188e-05;
    bool _2507;
    if (!_2500)
    {
        _2507 = modifier_factor.is_discarded == true;
    }
    else
    {
        _2507 = _2500;
    }
    if (_2507)
    {
        return;
    }
    bool _2513 = _2249.instancing_generator_params.duplicate_elimination_position != 0;
    bool _2520;
    if (!_2513)
    {
        _2520 = _2249.instancing_generator_params.duplicate_elimination_normal != 0;
    }
    else
    {
        _2520 = _2513;
    }
    if (_2520)
    {
        vec3 kv = (pos * _2249.instancing_generator_params.duplicate_elimination_position_decimation_rcp) + vec3(0.5);
        vec3 kn = (nz * _2249.instancing_generator_params.duplicate_elimination_normal_decimation) + vec3(0.5);
        uint64_t k = 0ul;
        if (_2249.instancing_generator_params.duplicate_elimination_position != 0)
        {
            k += uint64_t(((int64_t(kv.x) * 8521703l) + (int64_t(kv.y) * 15150437l)) + (int64_t(kv.z) * 10072093l));
        }
        if (_2249.instancing_generator_params.duplicate_elimination_normal != 0)
        {
            k += uint64_t(((int64_t(kn.x) * 913273l) + (int64_t(kn.y) * 16320103l)) + (int64_t(kn.z) * 15850061l));
        }
        uint64_t param_19 = k;
        GPUHashMapInsertResult _2594 = duplicate_elimination_hashmap_insert(param_19);
        GPUHashMapInsertResult ires = _2594;
        if (ires.duplicate)
        {
            return;
        }
        else
        {
            if (_2249.instancing_generator_params.duplicate_elimination_position != 0)
            {
                pos = (vec3(ivec3(kv)) - vec3(0.5)) * _2249.instancing_generator_params.duplicate_elimination_position_decimation;
            }
            if (_2249.instancing_generator_params.duplicate_elimination_normal != 0)
            {
                nz = (vec3(ivec3(kn)) - vec3(0.5)) * _2249.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
                nz = normalize(nz);
                vec3 param_20 = nz;
                mat3 _2633 = matrixFromVector(param_20);
                mat3 _m = _2633;
                nx = _m[0];
                ny = _m[1];
            }
        }
    }
    if (_2641.instance_params.instance_count >= _2641.instance_params.buffer_capacity)
    {
        return;
    }
    int _2653 = atomicAdd(_2641.instance_params.instance_count, 1);
    uint instance_id = uint(_2653);
    if (instance_id >= uint(_2641.instance_params.buffer_capacity))
    {
        return;
    }
    pos -= (nz * _2249.instancing_generator_params.surface_distance);
    nx *= _2249.instancing_generator_params.instance_scale.x;
    ny *= _2249.instancing_generator_params.instance_scale.y;
    nz *= _2249.instancing_generator_params.instance_scale.z;
    Instance instance;
    instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
    instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
    instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(1.0);
    instance.flipbook_card = 0u;
    modifier_factor.factor = _2720.VM3_params.value;
    InstanceModifierLookAt_Params _2732;
    _2732.ref_position = _2727.VM4_params.ref_position;
    _2732.look_away = _2727.VM4_params.look_away;
    _2732.axis = _2727.VM4_params.axis;
    InstanceModifierLookAt_Params param_21 = _2732;
    ModifierFactor param_22 = modifier_factor;
    Instance param_23 = instance;
    uint param_24 = id;
    instance_modifier_look_at(param_21, param_22, param_23, param_24);
    modifier_factor = param_22;
    instance = param_23;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorNoise_Params _2758;
    _2758.transform_local_to_gizmo = _2753.VM5_params.transform_local_to_gizmo;
    _2758.noise_domain_scale = _2753.VM5_params.noise_domain_scale;
    _2758.modifier_function = _2753.VM5_params.modifier_function;
    _2758.noise_domain_offset = _2753.VM5_params.noise_domain_offset;
    _2758.noise_value_scale = _2753.VM5_params.noise_value_scale;
    _2758.noise_value_offset = _2753.VM5_params.noise_value_offset;
    _2758.influence_scope = _2753.VM5_params.influence_scope;
    _2758._pad0 = _2753.VM5_params._pad0;
    _2758._pad1 = _2753.VM5_params._pad1;
    ModifierFactorNoise_Params param_25 = _2758;
    ModifierFactor param_26 = modifier_factor;
    CoordinateSystemTrasforms param_27 = cs_transforms;
    modifier_factor_noise_default(param_25, param_26, param_27);
    modifier_factor = param_26;
    InstanceModifierRandomizerV2_Params _2773;
    _2773.replace_previous_rotation_scale = _2768.VM6_params.replace_previous_rotation_scale;
    _2773.randomness_seed = _2768.VM6_params.randomness_seed;
    _2773.replace_previous_position = _2768.VM6_params.replace_previous_position;
    _2773.randomization_input = _2768.VM6_params.randomization_input;
    _2773.position_modifier_base = _2768.VM6_params.position_modifier_base;
    _2773.position_modifier_base_modifier_factor = _2768.VM6_params.position_modifier_base_modifier_factor;
    _2773.position_modifier_range = _2768.VM6_params.position_modifier_range;
    _2773.position_modifier_range_modifier_factor = _2768.VM6_params.position_modifier_range_modifier_factor;
    _2773.rotation_modifier_base = _2768.VM6_params.rotation_modifier_base;
    _2773.rotation_modifier_base_modifier_factor = _2768.VM6_params.rotation_modifier_base_modifier_factor;
    _2773.rotation_modifier_range = _2768.VM6_params.rotation_modifier_range;
    _2773.rotation_modifier_range_modifier_factor = _2768.VM6_params.rotation_modifier_range_modifier_factor;
    _2773.scale_modifier_base = _2768.VM6_params.scale_modifier_base;
    _2773.scale_modifier_base_modifier_factor = _2768.VM6_params.scale_modifier_base_modifier_factor;
    _2773.scale_modifier_range = _2768.VM6_params.scale_modifier_range;
    _2773.scale_modifier_range_modifier_factor = _2768.VM6_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_28 = _2773;
    ModifierFactor param_29 = modifier_factor;
    Instance param_30 = instance;
    uint param_31 = id;
    instance_modifier_randomizer_v2(param_28, param_29, param_30, param_31);
    modifier_factor = param_29;
    instance = param_30;
    InstanceModifierFactorToColor_Params _2791;
    _2791.color = _2786.VM7_params.color;
    _2791.use_gradient = _2786.VM7_params.use_gradient;
    _2791.color_gradient_idx = _2786.VM7_params.color_gradient_idx;
    _2791.mixing_mode = _2786.VM7_params.mixing_mode;
    InstanceModifierFactorToColor_Params param_32 = _2791;
    ModifierFactor param_33 = modifier_factor;
    Instance param_34 = instance;
    instance_modifier_factor_to_color(param_32, param_33, param_34);
    modifier_factor = param_33;
    instance = param_34;
    _2802.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _2802.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _2802.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _2825.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _2825.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _2845.instance_hash[instance_id] = instance.hash;
    _2853.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 