#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 32, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float vtx_coords[];
} _86;

layout(set = 0, binding = 2, std430) buffer VTXCoordsCopy
{
    float vtx_coords_copy[];
} _112;

layout(set = 0, binding = 3, std430) buffer VTXNormals
{
    float vtx_normals[];
} _134;

layout(set = 0, binding = 4, std430) buffer VTXNormalsCopy
{
    float vtx_normals_copy[];
} _156;

layout(set = 0, binding = 5, std430) buffer VTXBonesWeights
{
    uint bones_weights[];
} vtx_bones_weights;

layout(set = 0, binding = 6, std430) buffer ApplySkinningParamsBuffer
{
    uint verts_num;
    uint flipbook_card;
    uint _pad1;
    uint _pad2;
    layout(row_major) mat4 joint_transforms[];
} _258;

vec3 vtx_coords_copy_load(uint idx)
{
    return vec3(_112.vtx_coords_copy[(idx * 3u) + 0u], _112.vtx_coords_copy[(idx * 3u) + 1u], _112.vtx_coords_copy[(idx * 3u) + 2u]);
}

vec3 vtx_normals_copy_load(uint idx)
{
    return vec3(_156.vtx_normals_copy[(idx * 3u) + 0u], _156.vtx_normals_copy[(idx * 3u) + 1u], _156.vtx_normals_copy[(idx * 3u) + 2u]);
}

void vtx_bones_weights_load(uint idx, out uvec4 bones, out vec4 weights)
{
    weights = vec4(float((vtx_bones_weights.bones_weights[(idx * 4u) + 0u] & 4294901760u) >> uint(16)) * 1.525902189314365386962890625e-05, float((vtx_bones_weights.bones_weights[(idx * 4u) + 1u] & 4294901760u) >> uint(16)) * 1.525902189314365386962890625e-05, float((vtx_bones_weights.bones_weights[(idx * 4u) + 2u] & 4294901760u) >> uint(16)) * 1.525902189314365386962890625e-05, float((vtx_bones_weights.bones_weights[(idx * 4u) + 3u] & 4294901760u) >> uint(16)) * 1.525902189314365386962890625e-05);
    bones = uvec4(vtx_bones_weights.bones_weights[(idx * 4u) + 0u] & 65535u, vtx_bones_weights.bones_weights[(idx * 4u) + 1u] & 65535u, vtx_bones_weights.bones_weights[(idx * 4u) + 2u] & 65535u, vtx_bones_weights.bones_weights[(idx * 4u) + 3u] & 65535u);
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

void vtx_coords_store(uint idx, vec3 coords)
{
    _86.vtx_coords[(idx * 3u) + 0u] = coords.x;
    _86.vtx_coords[(idx * 3u) + 1u] = coords.y;
    _86.vtx_coords[(idx * 3u) + 2u] = coords.z;
}

void vtx_normals_store(uint idx, vec3 normal)
{
    _134.vtx_normals[(idx * 3u) + 0u] = normal.x;
    _134.vtx_normals[(idx * 3u) + 1u] = normal.y;
    _134.vtx_normals[(idx * 3u) + 2u] = normal.z;
}

void main()
{
    uint idx = gl_GlobalInvocationID.x;
    if (idx >= _258.verts_num)
    {
        return;
    }
    uint param = idx;
    vec3 pos = vtx_coords_copy_load(param);
    uint param_1 = idx;
    vec3 norm = vtx_normals_copy_load(param_1);
    uint param_2 = idx;
    uvec4 param_3;
    vec4 param_4;
    vtx_bones_weights_load(param_2, param_3, param_4);
    uvec4 bones = param_3;
    vec4 weights = param_4;
    mat4 m0 = _258.joint_transforms[bones.x];
    mat4 m1 = _258.joint_transforms[bones.y];
    mat4 m2 = _258.joint_transforms[bones.z];
    mat4 m3 = _258.joint_transforms[bones.w];
    vec3 p = vec3(0.0);
    vec3 n = vec3(0.0);
    vec3 param_5 = pos;
    mat4 param_6 = m0;
    vec3 _312 = vector_transform_by_mat43(param_5, param_6);
    p += (_312 * weights.x);
    vec3 param_7 = pos;
    mat4 param_8 = m1;
    vec3 _322 = vector_transform_by_mat43(param_7, param_8);
    p += (_322 * weights.y);
    vec3 param_9 = pos;
    mat4 param_10 = m2;
    vec3 _332 = vector_transform_by_mat43(param_9, param_10);
    p += (_332 * weights.z);
    vec3 param_11 = pos;
    mat4 param_12 = m3;
    vec3 _342 = vector_transform_by_mat43(param_11, param_12);
    p += (_342 * weights.w);
    vec3 param_13 = norm;
    mat4 param_14 = m0;
    n += (vector_transform_by_mat33(param_13, param_14) * weights.x);
    vec3 param_15 = norm;
    mat4 param_16 = m1;
    n += (vector_transform_by_mat33(param_15, param_16) * weights.y);
    vec3 param_17 = norm;
    mat4 param_18 = m2;
    n += (vector_transform_by_mat33(param_17, param_18) * weights.z);
    vec3 param_19 = norm;
    mat4 param_20 = m3;
    n += (vector_transform_by_mat33(param_19, param_20) * weights.w);
    idx += (_258.flipbook_card * _258.verts_num);
    uint param_21 = idx;
    vec3 param_22 = p;
    vtx_coords_store(param_21, param_22);
    uint param_23 = idx;
    vec3 param_24 = n;
    vtx_normals_store(param_23, param_24);
}

 