#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct _288
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 8, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _81;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 9, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _200;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _212;

layout(set = 0, binding = 6, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _308;

layout(set = 0, binding = 7, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _389;

layout(set = 0, binding = 10, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _432;

layout(location = 1) out _288 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _81.geometry_information.attributes[0].stride;
    idx += _81.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _81.geometry_information.attributes[2].stride;
    idx += _81.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _81.geometry_information.attributes[1].stride;
    idx += _81.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _81.geometry_information.attributes[3].stride;
    idx += _81.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_200.instance_params.stride > 0)
    {
        uint flipbook_card = _212.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_81.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_81.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _237 = vtx_coords_load(param);
    vtx_input.pos = _237;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_81.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _260 = vtx_albedo_load(param_1);
        vtx_input.color.x = _260.x;
        vtx_input.color.y = _260.y;
        vtx_input.color.z = _260.z;
    }
    if ((_81.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _275 = vtx_normals_load(param_2);
        vtx_input.norm = _275;
    }
    if ((_81.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _286 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _286;
    }
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_200.instance_params.stride > 0)
    {
        vec4 inst_m0 = _308.instance_transform[(gl_InstanceIndex * _200.instance_params.stride) + 0];
        vec4 inst_m1 = _308.instance_transform[(gl_InstanceIndex * _200.instance_params.stride) + 1];
        vec4 inst_m2 = _308.instance_transform[(gl_InstanceIndex * _200.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0, v);
        vtx_input.pos.y = dot(inst_m1, v);
        vtx_input.pos.z = dot(inst_m2, v);
        vec3 param_4 = vtx_input.norm;
        mat4 param_5 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_4, param_5));
        vec2 _395 = unpackHalf2x16(_389.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _395.x;
        inst_c.y = _395.y;
        vec2 _405 = unpackHalf2x16(_389.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _405.x;
        inst_c.w = _405.y;
        vec4 _411 = vtx_input.color;
        vec3 _415 = _411.xyz * inst_c.xyz;
        vtx_input.color.x = _415.x;
        vtx_input.color.y = _415.y;
        vtx_input.color.z = _415.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_6 = vtx_input.pos;
    mat4 param_7 = _432.transform_params.mModel;
    vec3 _440 = vector_transform_by_mat43(param_6, param_7);
    vec3 vPosModel = _440;
    vec3 param_8 = vtx_input.norm;
    mat4 param_9 = _432.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_8, param_9);
    vec3 param_10 = vPosModel;
    mat4 param_11 = _432.transform_params.mView;
    vec3 _455 = vector_transform_by_mat43(param_10, param_11);
    vec3 vPosModelView = _455;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _432.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_432.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_432.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_432.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    if (gl_VertexIndex < 4)
    {
        vec3 param_12 = vtx_input.pos;
        mat4 param_13 = _432.transform_params.mModel;
        vPosModel = vector_transform_by_mat33(param_12, param_13);
        vec3 param_14 = vPosModel;
        mat4 param_15 = _432.transform_params.mView;
        vtx_output.vCoords = vector_transform_by_mat33(param_14, param_15);
        gl_Position = _432.transform_params.mProjection * vec4(vtx_output.vCoords, 0.0);
    }
    else
    {
        vec3 param_16 = vPosModel;
        mat4 param_17 = _432.transform_params.mView;
        vec3 _539 = vector_transform_by_mat43(param_16, param_17);
        vtx_output.vCoords = _539;
        gl_Position = _432.transform_params.mProjection * vec4(vtx_output.vCoords, 1.0);
    }
}

 