#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct TAAResolveParams
{
    float taa_blend;
    float taa_gamma;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _524;

layout(set = 0, binding = 2, std140) uniform TAAResolveParamsBuffer
{
    TAAResolveParams taa_resolve_setup;
} _744;

layout(set = 0, binding = 4) uniform sampler2D sTargetCurrent;
layout(set = 0, binding = 5) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 6) uniform sampler2D sTextureDepthPrevious;
layout(set = 0, binding = 7) uniform sampler2D sTargetPrevious;
layout(set = 0, binding = 3, rgba16f) uniform writeonly image2D imTarget;

float linearizeDepth(float d)
{
    return _524.dispatch_setup.near_far_plane.z / ((_524.dispatch_setup.near_far_plane.y + _524.dispatch_setup.near_far_plane.x) - (d * _524.dispatch_setup.near_far_plane.w));
}

vec3 local_position_from_depth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

vec3 positionFromDepthCurrent(vec3 vDirection, float depth)
{
    return (_524.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

float Luminance(vec3 x)
{
    return max(0.0, dot(x, vec3(0.21269999444484710693359375, 0.715200006961822509765625, 0.072200000286102294921875)));
}

vec3 tonemap_sample(vec3 v)
{
    vec3 param = v;
    float l = Luminance(param);
    return v / vec3(1.0 + l);
}

vec3 positionFromDepthPrevious(vec3 vDirection, float depth)
{
    return (_524.dispatch_setup.mat_model_previous * vec4(vDirection * depth, 1.0)).xyz;
}

vec4 SampleTextureCatmullRom(sampler2D tex, vec2 uv, vec2 texSize)
{
    vec2 samplePos = uv * texSize;
    vec2 texPos1 = floor(samplePos - vec2(0.5)) + vec2(0.5);
    vec2 f = samplePos - texPos1;
    vec2 w0 = f * (vec2(-0.5) + (f * (vec2(1.0) - (f * 0.5))));
    vec2 w1 = vec2(1.0) + ((f * f) * (vec2(-2.5) + (f * 1.5)));
    vec2 w2 = f * (vec2(0.5) + (f * (vec2(2.0) - (f * 1.5))));
    vec2 w3 = (f * f) * (vec2(-0.5) + (f * 0.5));
    vec2 w12 = w1 + w2;
    vec2 offset12 = w2 / (w1 + w2);
    vec2 texPos0 = texPos1 - vec2(1.0);
    vec2 texPos3 = texPos1 + vec2(2.0);
    vec2 texPos12 = texPos1 + offset12;
    texPos0 /= texSize;
    texPos3 /= texSize;
    texPos12 /= texSize;
    vec4 result = vec4(0.0);
    result += ((textureLod(tex, vec2(texPos0.x, texPos0.y), 0.0) * w0.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos0.y), 0.0) * w12.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos0.y), 0.0) * w3.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos0.x, texPos12.y), 0.0) * w0.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos12.y), 0.0) * w12.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos12.y), 0.0) * w3.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos0.x, texPos3.y), 0.0) * w0.x) * w3.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos3.y), 0.0) * w12.x) * w3.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos3.y), 0.0) * w3.x) * w3.y);
    return result;
}

float FilterCubic(float x, float B, float C)
{
    float y = 0.0;
    float x2 = x * x;
    float x3 = (x * x) * x;
    if (x < 1.0)
    {
        y = ((((12.0 - (9.0 * B)) - (6.0 * C)) * x3) + ((((-18.0) + (12.0 * B)) + (6.0 * C)) * x2)) + (6.0 - (2.0 * B));
    }
    else
    {
        if (x <= 2.0)
        {
            y = (((((-B) - (6.0 * C)) * x3) + (((6.0 * B) + (30.0 * C)) * x2)) + ((((-12.0) * B) - (48.0 * C)) * x)) + ((8.0 * B) + (24.0 * C));
        }
    }
    return y / 6.0;
}

float Mitchell(float x)
{
    bool rescaleCubic = true;
    float _421;
    if (rescaleCubic)
    {
        _421 = x * 2.0;
    }
    else
    {
        _421 = x;
    }
    float cubicX = _421;
    float param = cubicX;
    float param_1 = 0.3333333432674407958984375;
    float param_2 = 0.3333333432674407958984375;
    return FilterCubic(param, param_1, param_2);
}

vec3 ClipAABB(vec3 aabbMin, vec3 aabbMax, vec3 prevSample, vec3 avg)
{
    vec3 p_clip = (aabbMax + aabbMin) * 0.5;
    vec3 e_clip = (aabbMax - aabbMin) * 0.5;
    vec3 v_clip = prevSample - p_clip;
    vec3 v_unit = v_clip / e_clip;
    vec3 a_unit = abs(v_unit);
    float ma_unit = max(a_unit.x, max(a_unit.y, a_unit.z));
    if (ma_unit > 1.0)
    {
        return p_clip + (v_clip / vec3(ma_unit));
    }
    else
    {
        return prevSample;
    }
}

float rcp(float x)
{
    if (x != 0.0)
    {
        return 1.0 / x;
    }
    return 0.0;
}

vec3 taa_resolve(ivec2 position, inout vec3 history_sample, float history_depth)
{
    vec3 sourceSampleTotal = vec3(0.0);
    float sourceSampleWeight = 0.0;
    vec3 neighborhoodMin = vec3(100000000.0);
    vec3 neighborhoodMax = vec3(-100000000.0);
    vec3 m1 = vec3(0.0);
    vec3 m2 = vec3(0.0);
    float neighborhoodMinDepth = 100000000.0;
    float neighborhoodMaxDepth = -100000000.0;
    int x = -1;
    for (;;)
    {
        if (x <= 1)
        {
            int y = -1;
            for (;;)
            {
                if (y <= 1)
                {
                    ivec2 pixelPosition = position + ivec2(x, y);
                    pixelPosition = clamp(pixelPosition, ivec2(0), ivec2(_524.dispatch_setup.resolution - vec2(1.0)));
                    vec3 neighbor = max(vec3(0.0), texelFetch(sTargetCurrent, ivec2(pixelPosition), 0).xyz);
                    vec3 param = neighbor;
                    neighbor = tonemap_sample(param);
                    float subSampleDistance = length(vec2(float(x), float(y)));
                    float param_1 = subSampleDistance;
                    float subSampleWeight = Mitchell(param_1);
                    sourceSampleTotal += (neighbor * subSampleWeight);
                    sourceSampleWeight += subSampleWeight;
                    neighborhoodMin = min(neighborhoodMin, neighbor);
                    neighborhoodMax = max(neighborhoodMax, neighbor);
                    m1 += neighbor;
                    m2 += (neighbor * neighbor);
                    float currentDepth = texelFetch(sTextureDepth, ivec2(pixelPosition), 0).x;
                    neighborhoodMinDepth = min(neighborhoodMinDepth, currentDepth);
                    neighborhoodMaxDepth = max(neighborhoodMaxDepth, currentDepth);
                    y++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            x++;
            continue;
        }
        else
        {
            break;
        }
    }
    vec3 sourceSample = sourceSampleTotal / vec3(sourceSampleWeight);
    float oneDividedBySampleCount = 0.111111111938953399658203125;
    float gamma = _744.taa_resolve_setup.taa_gamma;
    vec3 mu = m1 * oneDividedBySampleCount;
    vec3 sigma = sqrt(abs((m2 * oneDividedBySampleCount) - (mu * mu)));
    vec3 minc = mu - (sigma * gamma);
    vec3 maxc = mu + (sigma * gamma);
    vec3 param_2 = minc;
    vec3 param_3 = maxc;
    vec3 param_4 = history_sample;
    vec3 param_5 = mu;
    history_sample = ClipAABB(param_2, param_3, param_4, param_5);
    float weightSource = _744.taa_resolve_setup.taa_blend;
    float weightHistory = 1.0 - weightSource;
    float param_6 = max(max(sourceSample.x, sourceSample.y), sourceSample.z) + 1.0;
    vec3 compressedSource = sourceSample * rcp(param_6);
    float param_7 = max(max(history_sample.x, history_sample.y), history_sample.z) + 1.0;
    vec3 compressedHistory = history_sample * rcp(param_7);
    vec3 param_8 = compressedSource;
    float luminanceSource = Luminance(param_8);
    vec3 param_9 = compressedHistory;
    float luminanceHistory = Luminance(param_9);
    weightSource *= (1.0 / (1.0 + luminanceSource));
    weightHistory *= (1.0 / (1.0 + luminanceHistory));
    vec3 result = ((sourceSample * weightSource) + (history_sample * weightHistory)) / vec3(max(weightSource + weightHistory, 9.9999997473787516355514526367188e-06));
    return result;
}

float ClipAABBAlpha(float aabbMin, float aabbMax, float prevSample, float avg)
{
    float p_clip = 0.5 * (aabbMax + aabbMin);
    float e_clip = 0.5 * (aabbMax - aabbMin);
    float v_clip = prevSample - p_clip;
    float v_unit = v_clip / e_clip;
    float a_unit = abs(v_unit);
    float ma_unit = a_unit;
    if (ma_unit > 1.0)
    {
        return p_clip + (v_clip / ma_unit);
    }
    else
    {
        return prevSample;
    }
}

float taa_resolve_alpha(ivec2 position, inout float history_sample, float history_depth)
{
    float sourceSampleTotal = 0.0;
    float sourceSampleWeight = 0.0;
    float neighborhoodMin = 100000000.0;
    float neighborhoodMax = -100000000.0;
    float m1 = 0.0;
    float m2 = 0.0;
    float closestDepth = 1.0;
    ivec2 closestDepthPixelPosition = ivec2(0);
    int x = -1;
    for (;;)
    {
        if (x <= 1)
        {
            int y = -1;
            for (;;)
            {
                if (y <= 1)
                {
                    ivec2 pixelPosition = position + ivec2(x, y);
                    pixelPosition = clamp(pixelPosition, ivec2(0), ivec2(_524.dispatch_setup.resolution - vec2(1.0)));
                    float neighbor = max(0.0, texelFetch(sTargetCurrent, ivec2(pixelPosition), 0).w);
                    float subSampleDistance = length(vec2(float(x), float(y)));
                    float param = subSampleDistance;
                    float subSampleWeight = Mitchell(param);
                    sourceSampleTotal += (neighbor * subSampleWeight);
                    sourceSampleWeight += subSampleWeight;
                    neighborhoodMin = min(neighborhoodMin, neighbor);
                    neighborhoodMax = max(neighborhoodMax, neighbor);
                    m1 += neighbor;
                    m2 += (neighbor * neighbor);
                    float currentDepth = texelFetch(sTextureDepth, ivec2(pixelPosition), 0).x;
                    if (currentDepth < closestDepth)
                    {
                        closestDepth = currentDepth;
                        closestDepthPixelPosition = pixelPosition;
                    }
                    y++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            x++;
            continue;
        }
        else
        {
            break;
        }
    }
    float sourceSample = sourceSampleTotal / sourceSampleWeight;
    float oneDividedBySampleCount = 0.111111111938953399658203125;
    float gamma = _744.taa_resolve_setup.taa_gamma;
    float mu = m1 * oneDividedBySampleCount;
    float sigma = sqrt(abs((m2 * oneDividedBySampleCount) - (mu * mu)));
    float minc = mu - (gamma * sigma);
    float maxc = mu + (gamma * sigma);
    float param_1 = minc;
    float param_2 = maxc;
    float param_3 = history_sample;
    float param_4 = mu;
    history_sample = ClipAABBAlpha(param_1, param_2, param_3, param_4);
    float weightSource = _744.taa_resolve_setup.taa_blend;
    float weightHistory = 1.0 - weightSource;
    float result = ((sourceSample * weightSource) + (history_sample * weightHistory)) / max(weightSource + weightHistory, 9.9999997473787516355514526367188e-06);
    return result;
}

vec3 reverse_tonemap_sample(vec3 v)
{
    vec3 param = v;
    float l = Luminance(param);
    return v / vec3(1.0 - l);
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    vec3 view_direction;
    view_direction.x = (-_524.dispatch_setup.camera_projection_params.z) + ((_524.dispatch_setup.camera_projection_params.x * float(pixel_pos.x)) * _524.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_524.dispatch_setup.camera_projection_params.w) + ((_524.dispatch_setup.camera_projection_params.y * float(pixel_pos.y)) * _524.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float nonlinear_depth = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
    float param = nonlinear_depth;
    float depth = linearizeDepth(param);
    float linear_depth = depth;
    vec3 param_1 = view_direction;
    float param_2 = depth;
    vec3 view_coords = local_position_from_depth(param_1, param_2);
    vec3 param_3 = view_direction;
    float param_4 = linear_depth;
    vec3 world = positionFromDepthCurrent(param_3, param_4);
    vec4 color = texelFetch(sTargetCurrent, ivec2(pixel_pos), 0);
    vec3 param_5 = color.xyz;
    vec3 _1105 = tonemap_sample(param_5);
    color.x = _1105.x;
    color.y = _1105.y;
    color.z = _1105.z;
    bool reprojected = false;
    if (true)
    {
        vec3 param_6 = view_direction;
        float param_7 = linear_depth;
        vec4 view_prev = vec4(positionFromDepthCurrent(param_6, param_7), 1.0);
        view_prev = _524.dispatch_setup.mat_view_previous * view_prev;
        view_prev = _524.dispatch_setup.mat_projection * view_prev;
        vec3 proj_prev = vec3(0.5) + ((view_prev.xyz / vec3(view_prev.w)) * 0.5);
        vec2 screen_prev = proj_prev.xy;
        proj_prev.y = 1.0 - proj_prev.y;
        bool _1154 = screen_prev.x >= 0.0;
        bool _1160;
        if (_1154)
        {
            _1160 = screen_prev.y >= 0.0;
        }
        else
        {
            _1160 = _1154;
        }
        bool _1166;
        if (_1160)
        {
            _1166 = screen_prev.x < 1.0;
        }
        else
        {
            _1166 = _1160;
        }
        bool _1172;
        if (_1166)
        {
            _1172 = screen_prev.y < 1.0;
        }
        else
        {
            _1172 = _1166;
        }
        if (_1172)
        {
            vec3 view_direction_prev;
            view_direction_prev.x = (-_524.dispatch_setup.camera_projection_params.z) + (_524.dispatch_setup.camera_projection_params.x * screen_prev.x);
            view_direction_prev.y = (-_524.dispatch_setup.camera_projection_params.w) + (_524.dispatch_setup.camera_projection_params.y * screen_prev.y);
            view_direction_prev.z = 1.0;
            view_direction_prev.y = -view_direction_prev.y;
            float depth_prev = texelFetch(sTextureDepthPrevious, ivec2(proj_prev.xy * _524.dispatch_setup.resolution), 0).x;
            float param_8 = depth_prev;
            float depth_prev_linear = linearizeDepth(param_8);
            vec3 param_9 = view_direction_prev;
            float param_10 = depth_prev_linear;
            vec3 world_prev = positionFromDepthPrevious(param_9, param_10);
            float tolerance = 1.0;
            vec2 history_sample_pos = proj_prev.xy + (_524.dispatch_setup.inv_resolution * 0.5);
            vec2 param_11 = history_sample_pos;
            vec2 param_12 = vec2(_524.dispatch_setup.resolution);
            vec4 history_sample = SampleTextureCatmullRom(sTargetPrevious, param_11, param_12);
            vec3 param_13 = history_sample.xyz;
            vec3 _1245 = tonemap_sample(param_13);
            history_sample.x = _1245.x;
            history_sample.y = _1245.y;
            history_sample.z = _1245.z;
            vec4 _1252 = history_sample;
            vec3 _1254 = max(_1252.xyz, vec3(0.0));
            history_sample.x = _1254.x;
            history_sample.y = _1254.y;
            history_sample.z = _1254.z;
            ivec2 param_14 = ivec2(pixel_pos);
            vec3 param_15 = history_sample.xyz;
            float param_16 = depth_prev;
            vec3 _1269 = taa_resolve(param_14, param_15, param_16);
            color.x = _1269.x;
            color.y = _1269.y;
            color.z = _1269.z;
            ivec2 param_17 = ivec2(pixel_pos);
            float param_18 = history_sample.w;
            float param_19 = depth_prev;
            float _1284 = taa_resolve_alpha(param_17, param_18, param_19);
            color.w = _1284;
            reprojected = true;
        }
        else
        {
            vec4 history_sample_1 = color;
            vec4 _1289 = history_sample_1;
            vec3 _1291 = max(_1289.xyz, vec3(0.0));
            history_sample_1.x = _1291.x;
            history_sample_1.y = _1291.y;
            history_sample_1.z = _1291.z;
            ivec2 param_20 = ivec2(pixel_pos);
            vec3 param_21 = history_sample_1.xyz;
            float param_22 = nonlinear_depth;
            vec3 _1306 = taa_resolve(param_20, param_21, param_22);
            color.x = _1306.x;
            color.y = _1306.y;
            color.z = _1306.z;
            ivec2 param_23 = ivec2(pixel_pos);
            float param_24 = history_sample_1.w;
            float param_25 = nonlinear_depth;
            float _1321 = taa_resolve_alpha(param_23, param_24, param_25);
            color.w = _1321;
        }
    }
    vec3 param_26 = color.xyz;
    vec3 _1326 = reverse_tonemap_sample(param_26);
    color.x = _1326.x;
    color.y = _1326.y;
    color.z = _1326.z;
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 