#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 4, local_size_y = 4, local_size_z = 2) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, rgba8) uniform readonly image3D imSourceColor;
layout(set = 0, binding = 2, r8) uniform readonly image3D imSourceOccupancy;
layout(set = 0, binding = 3, rgba8) uniform writeonly image3D imTarget0Color;
layout(set = 0, binding = 4, r8) uniform writeonly image3D imTarget0Occupancy;
layout(set = 0, binding = 5, rgba8) uniform writeonly image3D imTarget1Color;
layout(set = 0, binding = 6, r8) uniform writeonly image3D imTarget1Occupancy;

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _70 = v;
    float _73 = v.w;
    vec3 _75 = (_70.xyz * _73) * 128.0;
    v.x = _75.x;
    v.y = _75.y;
    v.z = _75.z;
    return v.xyz * v.xyz;
}

vec4 color_convert_rgb_rgbm(inout vec3 v)
{
    v = sqrt(v);
    v /= vec3(128.0);
    vec4 rgbm;
    rgbm.w = clamp(max(max(v.x, v.y), max(v.z, 9.9999999747524270787835121154785e-07)), 0.0, 1.0);
    rgbm.w = ceil(rgbm.w * 256.0) / 255.0;
    float _58 = rgbm.w;
    vec3 _60 = v / vec3(_58);
    rgbm.x = _60.x;
    rgbm.y = _60.y;
    rgbm.z = _60.z;
    return rgbm;
}

void main()
{
    ivec3 grid_pos_16x16x16 = ivec3(gl_WorkGroupID);
    ivec3 grid_pos = (grid_pos_16x16x16 * ivec3(16, 16, 8)) + (ivec3(gl_LocalInvocationID) * ivec3(4));
    int grid_size = int((4u * gl_NumWorkGroups.x) * 4u);
    vec4 cube_samples_mip1[2][2][2];
    int iz = 0;
    for (;;)
    {
        if (iz < 2)
        {
            int iy = 0;
            for (;;)
            {
                if (iy < 2)
                {
                    int ix = 0;
                    for (;;)
                    {
                        if (ix < 2)
                        {
                            cube_samples_mip1[iz][iy][ix] = vec4(0.0);
                            ix++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    iy++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            iz++;
            continue;
        }
        else
        {
            break;
        }
    }
    ivec3 store_pos = grid_pos;
    vec4 v;
    int iz_1 = 0;
    for (;;)
    {
        if (iz_1 < 4)
        {
            int iy_1 = 0;
            for (;;)
            {
                if (iy_1 < 4)
                {
                    int ix_1 = 0;
                    for (;;)
                    {
                        if (ix_1 < 4)
                        {
                            int source_off = (store_pos.x + (store_pos.y * grid_size)) + ((store_pos.z * grid_size) * grid_size);
                            vec4 param = imageLoad(imSourceColor, store_pos);
                            vec3 _214 = color_convert_rgbm_rgb(param);
                            v.x = _214.x;
                            v.y = _214.y;
                            v.z = _214.z;
                            v.w = imageLoad(imSourceOccupancy, store_pos).x;
                            int _230 = iz_1 / 2;
                            int _232 = iy_1 / 2;
                            int _234 = ix_1 / 2;
                            cube_samples_mip1[_230][_232][_234] += v;
                            store_pos.x++;
                            ix_1++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    store_pos.x -= 4;
                    store_pos.y++;
                    iy_1++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            store_pos.y -= 4;
            store_pos.z++;
            iz_1++;
            continue;
        }
        else
        {
            break;
        }
    }
    vec4 cube_samples_mip2 = vec4(0.0);
    int iz_2 = 0;
    for (;;)
    {
        if (iz_2 < 2)
        {
            int iy_2 = 0;
            for (;;)
            {
                if (iy_2 < 2)
                {
                    int ix_2 = 0;
                    for (;;)
                    {
                        if (ix_2 < 2)
                        {
                            store_pos = (grid_pos / ivec3(2)) + ivec3(ix_2, iy_2, iz_2);
                            vec4 samples_color = vec4(0.0);
                            samples_color.w = cube_samples_mip1[iz_2][iy_2][ix_2].w;
                            if (samples_color.w > 0.0)
                            {
                                float _315 = samples_color.w;
                                vec3 _317 = cube_samples_mip1[iz_2][iy_2][ix_2].xyz / vec3(_315);
                                samples_color.x = _317.x;
                                samples_color.y = _317.y;
                                samples_color.z = _317.z;
                            }
                            samples_color.w *= 0.25;
                            vec3 param_1 = samples_color.xyz;
                            vec4 _335 = color_convert_rgb_rgbm(param_1);
                            imageStore(imTarget0Color, store_pos, _335);
                            imageStore(imTarget0Occupancy, store_pos, samples_color.wwww);
                            cube_samples_mip2 += samples_color;
                            ix_2++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    iy_2++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            iz_2++;
            continue;
        }
        else
        {
            break;
        }
    }
    vec4 samples_color_1 = vec4(0.0);
    samples_color_1.w = cube_samples_mip2.w;
    if (samples_color_1.w > 0.0)
    {
        float _362 = samples_color_1.w;
        vec3 _364 = cube_samples_mip2.xyz / vec3(_362);
        samples_color_1.x = _364.x;
        samples_color_1.y = _364.y;
        samples_color_1.z = _364.z;
    }
    samples_color_1.w *= 0.25;
    vec3 param_2 = samples_color_1.xyz;
    vec4 _383 = color_convert_rgb_rgbm(param_2);
    imageStore(imTarget1Color, grid_pos / ivec3(4), _383);
    imageStore(imTarget1Occupancy, grid_pos / ivec3(4), samples_color_1.wwww);
}

 