#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct VXFogParams
{
    float average_position_factor;
    float average_normals_factor;
    float average_colors_factor;
    float light_falloff_factor;
    float occlusion_falloff_factor;
    float light_trace_distance_scale;
    float trace_range;
    float reprojection_tolerance;
    float scattering_factor;
    float sampling_mip;
    float trace_step;
    int filter_step;
    vec3 noise_offset;
    float _pad0;
    vec3 tint_color;
    float noise_base;
    float noise_strength;
    float accumulation_factor;
};

const uvec2 _884[4] = uvec2[](uvec2(0u), uvec2(0u, 1u), uvec2(1u, 0u), uvec2(1u));

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _492;

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 3, std140) uniform VoxelFogParams
{
    VXFogParams voxel_lighting_setup;
} _701;

layout(set = 0, binding = 4, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _991;

layout(set = 0, binding = 8) uniform sampler2D s_NoiseRGBA;
layout(set = 0, binding = 9) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 0, binding = 10) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 5, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 11) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 6, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 12) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 13) uniform sampler2D sTextureDepthPrevious;
layout(set = 0, binding = 14) uniform sampler2D sTargetPrevious;
layout(set = 0, binding = 7, rgba16f) uniform writeonly image2D imTarget;

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((ddp.frustum_shift * ddp.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-ddp.camera_projection_params.z) + ((ddp.camera_projection_params.x * vd_pos.x) * ddp.inv_resolution.x);
    view_direction.y = (-ddp.camera_projection_params.w) + ((ddp.camera_projection_params.y * vd_pos.y) * ddp.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _423;
    if (nor.x > 0.0)
    {
        _423 = -t;
    }
    else
    {
        _423 = t;
    }
    nor.x += _423;
    float _438;
    if (nor.y > 0.0)
    {
        _438 = -t;
    }
    else
    {
        _438 = t;
    }
    nor.y += _438;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

float linearizeDepth(float d)
{
    return _492.dispatch_setup.near_far_plane.z / ((_492.dispatch_setup.near_far_plane.y + _492.dispatch_setup.near_far_plane.x) - (d * _492.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_492.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

float noise_fast(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = (f * f) * (vec3(3.0) - (f * 2.0));
    vec2 uv = (p.xy + (vec2(37.0, 17.0) * p.z)) + f.xy;
    vec2 rg = textureLod(s_NoiseRGBA, (uv + vec2(0.5)) / vec2(256.0), 0.0).yx;
    return (mix(rg.x, rg.y, f.z) * 2.0) - 1.0;
}

vec4 evaluate_fog(vec3 ro, vec3 rd, inout float t, float max_t, vec2 hash, int frame, vec3 noise_offset)
{
    vec3 grid_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 grid_size = in_bbox_data.grid_size_voxelize.xyz;
    int grid_res = 256;
    vec4 occlusion = vec4(0.0);
    vec3 ird;
    int i = 0;
    for (;;)
    {
        if (i < 16)
        {
            vec3 p = ro + (rd * t);
            float noise_scale = 2.0;
            vec3 noise_p = (p + noise_offset) * noise_scale;
            vec3 param = noise_p * 0.0024999999441206455230712890625;
            float n1 = 0.5 + noise_fast(param);
            vec3 param_1 = ((noise_p * 0.0024999999441206455230712890625) * 0.5) + vec3(0.1240999996662139892578125);
            float n2 = 0.5 + noise_fast(param_1);
            vec3 param_2 = ((noise_p * 0.0024999999441206455230712890625) * 0.25) + vec3(0.1240999996662139892578125);
            float n3 = 0.5 + noise_fast(param_2);
            vec2 _668 = (fract((hash + vec2(1.61803400516510009765625 * float(i))) + vec2(float(frame))) * 2.0) - vec2(1.0);
            ird.x = _668.x;
            ird.y = _668.y;
            ird.z = (1.0 - ird.x) - ird.y;
            ird = normalize(ird);
            vec4 r_occlusion = vec4(0.0);
            int j = 0;
            for (;;)
            {
                if (j < 2)
                {
                    vec3 ip = p + (((ird * (float(j) + (hash.x * _701.voxel_lighting_setup.scattering_factor))) * _701.voxel_lighting_setup.scattering_factor) * 0.5);
                    vec3 grid_p = (ip - grid_origin) / grid_size;
                    vec3 sample_p = (grid_p + vec3(0.5)) / vec3(float(grid_res));
                    bool _730 = all(greaterThanEqual(sample_p, vec3(0.0)));
                    bool _737;
                    if (_730)
                    {
                        _737 = all(lessThan(sample_p, vec3(1.0)));
                    }
                    else
                    {
                        _737 = _730;
                    }
                    if (_737)
                    {
                        float go = textureLod(s_voxel_occupancy_filtered, sample_p, _701.voxel_lighting_setup.sampling_mip).x;
                        vec3 gc = textureLod(s_voxel_colors_filtered, sample_p, _701.voxel_lighting_setup.sampling_mip).xyz;
                        r_occlusion.w += (go * 0.5);
                        vec4 _769 = r_occlusion;
                        vec3 _771 = _769.xyz + (gc * (1.0 - go));
                        r_occlusion.x = _771.x;
                        r_occlusion.y = _771.y;
                        r_occlusion.z = _771.z;
                    }
                    j++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            float f = _701.voxel_lighting_setup.noise_base + (_701.voxel_lighting_setup.noise_strength * (((n1 * 0.100000001490116119384765625) + ((n2 * 0.100000001490116119384765625) * 0.25)) + (n3 * 0.120999999344348907470703125)));
            occlusion += ((r_occlusion * f) * 10.0);
            occlusion += (vec4(_701.voxel_lighting_setup.tint_color, 1.0) * ((f * 0.100000001490116119384765625) * _701.voxel_lighting_setup.noise_strength));
            t += _701.voxel_lighting_setup.trace_step;
            if (t >= max_t)
            {
                break;
            }
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    return occlusion;
}

vec3 positionFromDepthPrevious(vec3 vDirection, float depth)
{
    return (_492.dispatch_setup.mat_model_previous * vec4(vDirection * depth, 1.0)).xyz;
}

vec4 SampleTextureCatmullRom(sampler2D tex, vec2 uv, vec2 texSize)
{
    vec2 samplePos = uv * texSize;
    vec2 texPos1 = floor(samplePos - vec2(0.5)) + vec2(0.5);
    vec2 f = samplePos - texPos1;
    vec2 w0 = f * (vec2(-0.5) + (f * (vec2(1.0) - (f * 0.5))));
    vec2 w1 = vec2(1.0) + ((f * f) * (vec2(-2.5) + (f * 1.5)));
    vec2 w2 = f * (vec2(0.5) + (f * (vec2(2.0) - (f * 1.5))));
    vec2 w3 = (f * f) * (vec2(-0.5) + (f * 0.5));
    vec2 w12 = w1 + w2;
    vec2 offset12 = w2 / (w1 + w2);
    vec2 texPos0 = texPos1 - vec2(1.0);
    vec2 texPos3 = texPos1 + vec2(2.0);
    vec2 texPos12 = texPos1 + offset12;
    texPos0 /= texSize;
    texPos3 /= texSize;
    texPos12 /= texSize;
    vec4 result = vec4(0.0);
    result += ((textureLod(tex, vec2(texPos0.x, texPos0.y), 0.0) * w0.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos0.y), 0.0) * w12.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos0.y), 0.0) * w3.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos0.x, texPos12.y), 0.0) * w0.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos12.y), 0.0) * w12.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos12.y), 0.0) * w3.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos0.x, texPos3.y), 0.0) * w0.x) * w3.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos3.y), 0.0) * w12.x) * w3.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos3.y), 0.0) * w3.x) * w3.y);
    return result;
}

void main()
{
    float range = min(in_bbox_data.grid_size_voxelize.x, min(in_bbox_data.grid_size_voxelize.y, in_bbox_data.grid_size_voxelize.z));
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    float param_9;
    float param_10;
    uint param_11;
    vec3 view_direction_prev;
    int i = 0;
    for (;;)
    {
        if (i < 4)
        {
            ivec2 pos = ivec2((pixel_pos * uvec2(2u)) + _884[i]);
            ivec2 noise_pos = pos & ivec2(127);
            uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
            uint param = encoded_normal_material;
            int materialId = decode_material(param);
            bool is_background = (materialId & 1) == 1;
            if (is_background)
            {
            }
            DispatchDeferredParams _925;
            _925.mat_projection = _492.dispatch_setup.mat_projection;
            _925.mat_projection_previous = _492.dispatch_setup.mat_projection_previous;
            _925.mat_model = _492.dispatch_setup.mat_model;
            _925.mat_model_previous = _492.dispatch_setup.mat_model_previous;
            _925.mat_view_inverse = _492.dispatch_setup.mat_view_inverse;
            _925.mat_view_previous = _492.dispatch_setup.mat_view_previous;
            _925.camera_position = _492.dispatch_setup.camera_position;
            _925.camera_projection_params = _492.dispatch_setup.camera_projection_params;
            _925.camera_projection_params_previous = _492.dispatch_setup.camera_projection_params_previous;
            _925.near_far_plane = _492.dispatch_setup.near_far_plane;
            _925.resolution = _492.dispatch_setup.resolution;
            _925.inv_resolution = _492.dispatch_setup.inv_resolution;
            _925.frustum_shift = _492.dispatch_setup.frustum_shift;
            DispatchDeferredParams param_1 = _925;
            vec2 param_2 = vec2(pos);
            vec3 view_direction = deferred_get_view_direction_from_screen_pos(param_1, param_2);
            uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
            uint param_3 = encoded_normal_material_1;
            vec3 _936 = decode_normal(param_3);
            vec3 vNorm = _936;
            uint param_4 = encoded_normal_material_1;
            int materialId_1 = decode_material(param_4);
            float param_5 = texelFetch(sTextureDepth, pos, 0).x;
            float depth = linearizeDepth(param_5);
            vec3 param_6 = view_direction;
            float param_7 = depth;
            vec3 world = positionFromDepth(param_6, param_7);
            uvec2 param_8 = imageLoad(imMetalnessRoughnessMaterialTags, pos).xy;
            decode_metalness_roughness_material(param_8, param_9, param_10, param_11);
            float metalness = param_9;
            float roughness = param_10;
            uint material = param_11;
            vec3 dir = world - _492.dispatch_setup.camera_position;
            float max_t = length(dir);
            dir /= vec3(max_t);
            int frame = _991.globals.monotonic;
            vec2 hash = texelFetch(s_BlueNoise, ivec3(noise_pos, frame & 15), 0).xy;
            vec3 ro = _492.dispatch_setup.camera_position;
            vec3 rd = dir;
            float t1 = 0.0 + ((fract(0.5 + (hash.x * 2.0)) * _701.voxel_lighting_setup.trace_step) * 3.0);
            float t2 = 0.0 + ((fract(0.5 + (hash.y * 2.0)) * _701.voxel_lighting_setup.trace_step) * 3.0);
            vec3 param_12 = ro;
            vec3 param_13 = rd;
            float param_14 = t1;
            float param_15 = max_t;
            vec2 param_16 = hash;
            int param_17 = frame;
            vec3 param_18 = _701.voxel_lighting_setup.noise_offset;
            vec4 _1054 = evaluate_fog(param_12, param_13, param_14, param_15, param_16, param_17, param_18);
            vec4 occlusion = _1054;
            if (true)
            {
                vec4 view_prev = vec4(world, 1.0);
                view_prev = _492.dispatch_setup.mat_view_previous * view_prev;
                view_prev = _492.dispatch_setup.mat_projection_previous * view_prev;
                vec3 proj_prev = vec3(0.5) + ((view_prev.xyz / vec3(view_prev.w)) * 0.5);
                proj_prev.y = 1.0 - proj_prev.y;
                vec2 screen_prev = proj_prev.xy;
                bool _1092 = screen_prev.x >= 0.0;
                bool _1098;
                if (_1092)
                {
                    _1098 = screen_prev.y >= 0.0;
                }
                else
                {
                    _1098 = _1092;
                }
                bool _1104;
                if (_1098)
                {
                    _1104 = screen_prev.x < 1.0;
                }
                else
                {
                    _1104 = _1098;
                }
                bool _1110;
                if (_1104)
                {
                    _1110 = screen_prev.y < 1.0;
                }
                else
                {
                    _1110 = _1104;
                }
                if (_1110)
                {
                    view_direction_prev.x = (-_492.dispatch_setup.camera_projection_params.z) + (_492.dispatch_setup.camera_projection_params_previous.x * screen_prev.x);
                    view_direction_prev.y = (-_492.dispatch_setup.camera_projection_params.w) + (_492.dispatch_setup.camera_projection_params_previous.y * screen_prev.y);
                    view_direction_prev.z = 1.0;
                    view_direction_prev.y = -view_direction_prev.y;
                    float param_19 = texelFetch(sTextureDepthPrevious, ivec2((proj_prev.xy * _492.dispatch_setup.resolution) + vec2(0.5)), 0).x;
                    float depth_prev = linearizeDepth(param_19);
                    vec3 param_20 = view_direction_prev;
                    float param_21 = depth_prev;
                    vec3 world_prev = positionFromDepthPrevious(param_20, param_21);
                    float tolerance = _701.voxel_lighting_setup.reprojection_tolerance;
                    if ((length(world - world_prev) <= tolerance) || is_background)
                    {
                        vec2 param_22 = proj_prev.xy + (_492.dispatch_setup.inv_resolution * 0.5);
                        vec2 param_23 = vec2(_492.dispatch_setup.resolution);
                        vec4 occlusion_prev = SampleTextureCatmullRom(sTargetPrevious, param_22, param_23);
                        float f = 0.0;
                        occlusion = mix(occlusion_prev, occlusion, vec4(_701.voxel_lighting_setup.accumulation_factor));
                    }
                    else
                    {
                        int additional_samples = 2;
                        int nfi = 0;
                        for (;;)
                        {
                            if (nfi < additional_samples)
                            {
                                frame++;
                                vec2 hash_1 = fract(texelFetch(s_BlueNoise, ivec3(noise_pos, 0), 0).xy + vec2(float(frame) * 1.61803400516510009765625));
                                float t = 0.0 + ((hash_1.y * _701.voxel_lighting_setup.trace_step) * 3.0);
                                vec3 param_24 = ro;
                                vec3 param_25 = rd;
                                float param_26 = t;
                                float param_27 = max_t;
                                vec2 param_28 = hash_1;
                                int param_29 = frame;
                                vec3 param_30 = _701.voxel_lighting_setup.noise_offset;
                                vec4 _1250 = evaluate_fog(param_24, param_25, param_26, param_27, param_28, param_29, param_30);
                                occlusion += _1250;
                                nfi++;
                                continue;
                            }
                            else
                            {
                                break;
                            }
                        }
                        occlusion /= vec4(float(1 + additional_samples));
                        occlusion.w = clamp(occlusion.w, 0.0, 1.0);
                    }
                }
            }
            if (false)
            {
                vec3 hash_2 = texelFetch(s_BlueNoise, ivec3(noise_pos, 0), 0).xyz;
                occlusion.x = hash_2.x;
                occlusion.y = hash_2.y;
                occlusion.z = hash_2.z;
                occlusion.w = hash_2.x;
            }
            imageStore(imTarget, pos, clamp(occlusion, vec4(0.0), vec4(1.0)));
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
}

 