#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryCopyDeformParams
{
    int surfaces_num;
    int surface_idx;
    int attribute_mask;
    int create_copy;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

layout(set = 0, binding = 8, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _222;

layout(set = 0, binding = 1, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 2, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 3, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 4, std430) readonly buffer InVTXAlbedo
{
    float data[];
} in_vtx_albedo;

layout(set = 0, binding = 5, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 9, std140) uniform VM9
{
    layout(row_major) ModifierFactorNoise_Params VM9_params;
} _912;

layout(set = 0, binding = 10, std140) uniform VM10
{
    layout(row_major) ModifierFactorNoise_Params VM10_params;
} _926;

layout(set = 0, binding = 11, std140) uniform VM11
{
    ModifierFactorMulAdd_Params VM11_params;
} _940;

layout(set = 0, binding = 12, std140) uniform VM12
{
    layout(row_major) ModifierFactorDistancePlane_Params VM12_params;
} _953;

layout(set = 0, binding = 13, std140) uniform GeometryCopyDeformParamsBuffer
{
    GeometryCopyDeformParams geometry_copy_deform_params;
} _985;

layout(set = 0, binding = 6, std430) buffer VertexCopyFlagBuffer
{
    uint data[];
} vtx_copy_flag_data;

layout(set = 0, binding = 7, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _1083;

layout(set = 0, binding = 14) uniform sampler2D s_Curves;

uint get_idx(inout uint idx)
{
    idx += _222.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

vec3 get_coords(inout uint idx)
{
    idx *= _222.input_geometry_information.attributes[0].stride;
    idx += _222.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

vec3 get_normal(inout uint idx)
{
    idx *= _222.input_geometry_information.attributes[1].stride;
    idx += _222.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint get_custom0(inout uint idx)
{
    idx *= _222.input_geometry_information.attributes[6].stride;
    idx += _222.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

vec3 get_albedo(inout uint idx)
{
    idx *= _222.input_geometry_information.attributes[2].stride;
    idx += _222.input_geometry_information.attributes[2].offset;
    return vec3(in_vtx_albedo.data[idx + 0u], in_vtx_albedo.data[idx + 1u], in_vtx_albedo.data[idx + 2u]);
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _702 = vector_transform_by_mat43(param, param_1);
        coords = _702;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _709 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _709;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _782 = vector_transform_by_mat43(param, param_1);
        coords = _782;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _789 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _789;
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_4 = modifier_params.falloff_curve_idx;
    float param_5 = influence;
    influence = curve_sample(param_4, param_5);
    float v = influence;
    ModifierFactor param_6 = modifier_factor;
    uint param_7 = uint(modifier_params.modifier_function);
    float param_8 = v;
    modifier_process_modifier_factor(param_6, param_7, param_8);
    modifier_factor = param_6;
}

bool apply_copy_modifier_for_vtx(uint i0)
{
    uint param = i0;
    vec3 _837 = get_coords(param);
    vec3 v0_coords = _837;
    vec3 v0_normal = vec3(0.0, 0.0, 1.0);
    if ((_222.input_geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_1 = i0;
        vec3 _848 = get_normal(param_1);
        v0_normal = _848;
    }
    bool copy_vtx_flag = true;
    VertexInput vtx_input;
    vtx_input.pos = v0_coords;
    vtx_input.norm = v0_normal;
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_instance_model;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = i0;
    modifier_factor.id = i0;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    if ((_222.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_2 = i0;
        uint _884 = get_custom0(param_2);
        modifier_factor.custom0 = _884;
    }
    if ((_222.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_3 = i0;
        vec3 _894 = get_albedo(param_3);
        modifier_factor.color.x = _894.x;
        modifier_factor.color.y = _894.y;
        modifier_factor.color.z = _894.z;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _917;
    _917.transform_local_to_gizmo = _912.VM9_params.transform_local_to_gizmo;
    _917.noise_domain_scale = _912.VM9_params.noise_domain_scale;
    _917.modifier_function = _912.VM9_params.modifier_function;
    _917.noise_domain_offset = _912.VM9_params.noise_domain_offset;
    _917.noise_value_scale = _912.VM9_params.noise_value_scale;
    _917.noise_value_offset = _912.VM9_params.noise_value_offset;
    _917.influence_scope = _912.VM9_params.influence_scope;
    _917._pad0 = _912.VM9_params._pad0;
    _917._pad1 = _912.VM9_params._pad1;
    ModifierFactorNoise_Params param_4 = _917;
    ModifierFactor param_5 = modifier_factor;
    CoordinateSystemTrasforms param_6 = cs_transforms;
    modifier_factor_noise_default(param_4, param_5, param_6);
    modifier_factor = param_5;
    ModifierFactorNoise_Params _930;
    _930.transform_local_to_gizmo = _926.VM10_params.transform_local_to_gizmo;
    _930.noise_domain_scale = _926.VM10_params.noise_domain_scale;
    _930.modifier_function = _926.VM10_params.modifier_function;
    _930.noise_domain_offset = _926.VM10_params.noise_domain_offset;
    _930.noise_value_scale = _926.VM10_params.noise_value_scale;
    _930.noise_value_offset = _926.VM10_params.noise_value_offset;
    _930.influence_scope = _926.VM10_params.influence_scope;
    _930._pad0 = _926.VM10_params._pad0;
    _930._pad1 = _926.VM10_params._pad1;
    ModifierFactorNoise_Params param_7 = _930;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_noise_default(param_7, param_8, param_9);
    modifier_factor = param_8;
    ModifierFactorMulAdd_Params _945;
    _945.multiply_value = _940.VM11_params.multiply_value;
    _945.add_value = _940.VM11_params.add_value;
    ModifierFactorMulAdd_Params param_10 = _945;
    ModifierFactor param_11 = modifier_factor;
    modifier_factor_mul_add(param_10, param_11);
    modifier_factor = param_11;
    ModifierFactorDistancePlane_Params _958;
    _958.transform_local_to_gizmo = _953.VM12_params.transform_local_to_gizmo;
    _958.falloff_curve_idx = _953.VM12_params.falloff_curve_idx;
    _958.falloff_inverse = _953.VM12_params.falloff_inverse;
    _958.domain_mirror = _953.VM12_params.domain_mirror;
    _958.domain_repeat = _953.VM12_params.domain_repeat;
    _958.influence_scope = _953.VM12_params.influence_scope;
    _958.modifier_function = _953.VM12_params.modifier_function;
    ModifierFactorDistancePlane_Params param_12 = _958;
    ModifierFactor param_13 = modifier_factor;
    CoordinateSystemTrasforms param_14 = cs_transforms;
    modifier_factor_distance_plane(param_12, param_13, param_14);
    modifier_factor = param_13;
    if (modifier_factor.factor <= 0.001000000047497451305389404296875)
    {
        copy_vtx_flag = false;
    }
    return copy_vtx_flag;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = uint(_985.geometry_copy_deform_params.surface_idx);
    uint src_faces_num = _222.input_geometry_information.faces_num_per_surface[surface_idx];
    uint src_face_idx = thread_idx;
    for (;;)
    {
        if (src_face_idx < src_faces_num)
        {
            uint param = (src_face_idx * 3u) + 0u;
            uint _1009 = get_idx(param);
            uint i0 = _1009;
            uint param_1 = (src_face_idx * 3u) + 1u;
            uint _1015 = get_idx(param_1);
            uint i1 = _1015;
            uint param_2 = (src_face_idx * 3u) + 2u;
            uint _1021 = get_idx(param_2);
            uint i2 = _1021;
            uint param_3 = i0;
            bool i0_copy = apply_copy_modifier_for_vtx(param_3);
            uint param_4 = i1;
            bool i1_copy = apply_copy_modifier_for_vtx(param_4);
            uint param_5 = i2;
            bool i2_copy = apply_copy_modifier_for_vtx(param_5);
            if ((i0_copy && i1_copy) && i2_copy)
            {
                uint _1048 = atomicCompSwap(vtx_copy_flag_data.data[i0], 0u, 1u);
                bool is_i0_new_vtx = _1048 == 0u;
                uint _1053 = atomicCompSwap(vtx_copy_flag_data.data[i1], 0u, 1u);
                bool is_i1_new_vtx = _1053 == 0u;
                uint _1058 = atomicCompSwap(vtx_copy_flag_data.data[i2], 0u, 1u);
                bool is_i2_new_vtx = _1058 == 0u;
                uint new_vtx_cnt = 0u;
                if (is_i0_new_vtx)
                {
                    new_vtx_cnt++;
                }
                if (is_i1_new_vtx)
                {
                    new_vtx_cnt++;
                }
                if (is_i2_new_vtx)
                {
                    new_vtx_cnt++;
                }
                if (new_vtx_cnt > 0u)
                {
                    uint _1086 = atomicAdd(_1083.output_geometry_information.vtx_num, new_vtx_cnt);
                    uint vtx_count = _1086;
                    if (is_i0_new_vtx)
                    {
                        uint _1091 = vtx_count;
                        uint _1092 = _1091 + uint(1);
                        vtx_count = _1092;
                        vtx_copy_flag_data.data[i0] = _1092;
                    }
                    if (is_i1_new_vtx)
                    {
                        uint _1098 = vtx_count;
                        uint _1099 = _1098 + uint(1);
                        vtx_count = _1099;
                        vtx_copy_flag_data.data[i1] = _1099;
                    }
                    if (is_i2_new_vtx)
                    {
                        uint _1105 = vtx_count;
                        uint _1106 = _1105 + uint(1);
                        vtx_count = _1106;
                        vtx_copy_flag_data.data[i2] = _1106;
                    }
                }
                uint _1110 = atomicAdd(_1083.output_geometry_information.faces_num_per_surface[surface_idx], 1u);
            }
            src_face_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
}

 