#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GPUHashMapLookupResult
{
    uint slot;
    bool found;
};

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometrySubdivideParams
{
    uint max_faces_num;
    uint surfaces_num;
    uint surface_idx;
    uint attribute_mask;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer EdgeHashMapKeysBuffer
{
    GPUHashMapHeader header;
    uint64_t keys[];
} edge_hashmap;

layout(set = 0, binding = 2, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _170;

layout(set = 0, binding = 3, std430) buffer OutIndexBuffer
{
    uint data[];
} out_idx_data;

layout(set = 0, binding = 4, std430) buffer OutVTXCoords
{
    float data[];
} out_vtx_coords;

layout(set = 0, binding = 5, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 6, std430) buffer OutVTXCustom0
{
    uint data[];
} out_vtx_custom0;

layout(set = 0, binding = 12, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _301;

layout(set = 0, binding = 7, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 8, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 9, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 10, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 13, std140) uniform GeometrySubdivideParamsBuffer
{
    GeometrySubdivideParams geometry_subdivide_params;
} _430;

layout(set = 0, binding = 11, std430) buffer EdgeHashMapValuesBuffer
{
    uint values[];
} edge_hashmap_values;

uint get_idx(inout uint idx)
{
    idx += _301.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

vec3 get_coords(inout uint idx)
{
    idx *= _301.input_geometry_information.attributes[0].stride;
    idx += _301.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

void put_coords(inout uint idx, vec3 v)
{
    idx *= _170.output_geometry_information.attributes[0].stride;
    idx += _170.output_geometry_information.attributes[0].offset;
    out_vtx_coords.data[idx + 0u] = v.x;
    out_vtx_coords.data[idx + 1u] = v.y;
    out_vtx_coords.data[idx + 2u] = v.z;
}

vec3 get_normal(inout uint idx)
{
    idx *= _301.input_geometry_information.attributes[1].stride;
    idx += _301.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

void put_normal(inout uint idx, vec3 v)
{
    idx *= _170.output_geometry_information.attributes[1].stride;
    idx += _170.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

uint get_custom0(inout uint idx)
{
    idx *= _301.input_geometry_information.attributes[6].stride;
    idx += _301.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

void put_custom0(inout uint idx, uint v)
{
    idx *= _170.output_geometry_information.attributes[6].stride;
    idx += _170.output_geometry_information.attributes[6].offset;
    out_vtx_custom0.data[idx + 0u] = v;
}

uint64_t build_edge_key(uint a, uint b)
{
    if (a < b)
    {
        return (uint64_t(a) << 32) | uint64_t(b);
    }
    else
    {
        return (uint64_t(b) << 32) | uint64_t(a);
    }
}

uint64_t GPUHashMapHash64(inout uint64_t h)
{
    h ^= (h >> 33);
    h *= 18397679294719823053ul;
    h ^= (h >> 33);
    h *= 14181476777654086739ul;
    h ^= (h >> 33);
    return h;
}

GPUHashMapLookupResult edge_hashmap_lookup(uint64_t key)
{
    GPUHashMapLookupResult res;
    res.slot = 0u;
    res.found = false;
    uint64_t param = key;
    uint64_t _110 = GPUHashMapHash64(param);
    uint64_t hash = _110;
    uint slot = uint(hash & uint64_t(edge_hashmap.header.capacity - 1u));
    for (;;)
    {
        if (true)
        {
            uint64_t map_key = edge_hashmap.keys[slot];
            if (map_key == 18446744073709551615ul)
            {
                break;
            }
            if (map_key == key)
            {
                res.slot = slot;
                res.found = true;
                return res;
            }
            slot = (slot + 1u) & (edge_hashmap.header.capacity - 1u);
            continue;
        }
        else
        {
            break;
        }
    }
    return res;
}

bool is_edge_key_swapped(uint a, uint b)
{
    if (a < b)
    {
        return false;
    }
    else
    {
        return true;
    }
}

void put_idx(inout uint idx, uint v)
{
    idx += _170.output_geometry_information.idx_buffer_offset;
    out_idx_data.data[idx] = v;
}

uint put_face_idx_check_degenerate(uint dst_face_idx, uint i0, uint i1, uint i2)
{
    if (((i0 == i1) || (i0 == i2)) || (i1 == i2))
    {
        return dst_face_idx;
    }
    uint param = (dst_face_idx * 3u) + 0u;
    uint param_1 = i0;
    put_idx(param, param_1);
    uint param_2 = (dst_face_idx * 3u) + 1u;
    uint param_3 = i1;
    put_idx(param_2, param_3);
    uint param_4 = (dst_face_idx * 3u) + 2u;
    uint param_5 = i2;
    put_idx(param_4, param_5);
    return dst_face_idx + 1u;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = _430.geometry_subdivide_params.surface_idx;
    uint src_faces_num = _301.input_geometry_information.faces_num_per_surface[surface_idx];
    bool input_has_normals = (_301.input_geometry_information.builtin_attribute_mask & 2u) != 0u;
    bool input_has_custom0 = (_301.input_geometry_information.builtin_attribute_mask & 64u) != 0u;
    float w0;
    float w1;
    float w0_1;
    float w1_1;
    float w0_2;
    float w1_2;
    uint ie1_3;
    uint ie2;
    uint ie4;
    uint ie5;
    uint ie7;
    uint ie8;
    uint added_faces;
    uint src_face_idx = thread_idx;
    for (;;)
    {
        if (src_face_idx < src_faces_num)
        {
            uint param = (src_face_idx * 3u) + 0u;
            uint _464 = get_idx(param);
            uint i0 = _464;
            uint param_1 = (src_face_idx * 3u) + 1u;
            uint _470 = get_idx(param_1);
            uint i1 = _470;
            uint param_2 = (src_face_idx * 3u) + 2u;
            uint _476 = get_idx(param_2);
            uint i2 = _476;
            uint param_3 = i0;
            vec3 _480 = get_coords(param_3);
            vec3 v0_coords = _480;
            uint param_4 = i1;
            vec3 _484 = get_coords(param_4);
            vec3 v1_coords = _484;
            uint param_5 = i2;
            vec3 _488 = get_coords(param_5);
            vec3 v2_coords = _488;
            uint param_6 = i0;
            vec3 param_7 = v0_coords;
            put_coords(param_6, param_7);
            uint param_8 = i1;
            vec3 param_9 = v1_coords;
            put_coords(param_8, param_9);
            uint param_10 = i2;
            vec3 param_11 = v2_coords;
            put_coords(param_10, param_11);
            if ((_170.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
            {
                vec3 v0_normal = vec3(0.0, 0.0, 1.0);
                vec3 v1_normal = vec3(0.0, 0.0, 1.0);
                vec3 v2_normal = vec3(0.0, 0.0, 1.0);
                if (input_has_normals)
                {
                    uint param_12 = i0;
                    vec3 _521 = get_normal(param_12);
                    v0_normal = _521;
                    uint param_13 = i1;
                    vec3 _524 = get_normal(param_13);
                    v1_normal = _524;
                    uint param_14 = i2;
                    vec3 _527 = get_normal(param_14);
                    v2_normal = _527;
                }
                uint param_15 = i0;
                vec3 param_16 = v0_normal;
                put_normal(param_15, param_16);
                uint param_17 = i1;
                vec3 param_18 = v1_normal;
                put_normal(param_17, param_18);
                uint param_19 = i2;
                vec3 param_20 = v2_normal;
                put_normal(param_19, param_20);
            }
            if ((_170.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
            {
                uint v0_custom0 = 0u;
                uint v1_custom0 = 0u;
                uint v2_custom0 = 0u;
                if (input_has_custom0)
                {
                    uint param_21 = i0;
                    uint _557 = get_custom0(param_21);
                    v0_custom0 = _557;
                    uint param_22 = i1;
                    uint _560 = get_custom0(param_22);
                    v1_custom0 = _560;
                    uint param_23 = i2;
                    uint _563 = get_custom0(param_23);
                    v2_custom0 = _563;
                }
                uint param_24 = i0;
                uint param_25 = v0_custom0;
                put_custom0(param_24, param_25);
                uint param_26 = i1;
                uint param_27 = v1_custom0;
                put_custom0(param_26, param_27);
                uint param_28 = i2;
                uint param_29 = v2_custom0;
                put_custom0(param_28, param_29);
            }
            uint param_30 = i0;
            uint param_31 = i1;
            uint64_t edge0 = build_edge_key(param_30, param_31);
            uint param_32 = i1;
            uint param_33 = i2;
            uint64_t edge1 = build_edge_key(param_32, param_33);
            uint param_34 = i2;
            uint param_35 = i0;
            uint64_t edge2 = build_edge_key(param_34, param_35);
            uint64_t param_36 = edge0;
            GPUHashMapLookupResult ires0 = edge_hashmap_lookup(param_36);
            uint64_t param_37 = edge1;
            GPUHashMapLookupResult ires1 = edge_hashmap_lookup(param_37);
            uint64_t param_38 = edge2;
            GPUHashMapLookupResult ires2 = edge_hashmap_lookup(param_38);
            uint split_edges = 0u;
            split_edges += uint(int(ires0.found));
            split_edges += uint(int(ires1.found));
            split_edges += uint(int(ires2.found));
            if (ires0.found)
            {
                uint ie0 = edge_hashmap_values.values[ires0.slot];
                uint ie1 = ie0 + 1u;
                ie0 += _301.input_geometry_information.vtx_num;
                ie1 += _301.input_geometry_information.vtx_num;
                uint param_39 = i0;
                uint param_40 = i1;
                if (is_edge_key_swapped(param_39, param_40) == false)
                {
                    w0 = 0.3333333432674407958984375;
                    w1 = 0.666666686534881591796875;
                }
                else
                {
                    w0 = 0.666666686534881591796875;
                    w1 = 0.3333333432674407958984375;
                }
                uint param_41 = ie0;
                vec3 param_42 = mix(v0_coords, v1_coords, vec3(w0));
                put_coords(param_41, param_42);
                uint param_43 = ie1;
                vec3 param_44 = mix(v0_coords, v1_coords, vec3(w1));
                put_coords(param_43, param_44);
                if ((_170.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                {
                    vec3 v0_normal_1 = vec3(0.0, 0.0, 1.0);
                    vec3 v1_normal_1 = vec3(0.0, 0.0, 1.0);
                    vec3 v2_normal_1 = vec3(0.0, 0.0, 1.0);
                    if (input_has_normals)
                    {
                        uint param_45 = i0;
                        vec3 _697 = get_normal(param_45);
                        v0_normal_1 = _697;
                        uint param_46 = i1;
                        vec3 _700 = get_normal(param_46);
                        v1_normal_1 = _700;
                        uint param_47 = i2;
                        vec3 _703 = get_normal(param_47);
                        v2_normal_1 = _703;
                    }
                    uint param_48 = ie0;
                    vec3 param_49 = normalize(mix(v0_normal_1, v1_normal_1, vec3(w0)));
                    put_normal(param_48, param_49);
                    uint param_50 = ie1;
                    vec3 param_51 = normalize(mix(v0_normal_1, v1_normal_1, vec3(w1)));
                    put_normal(param_50, param_51);
                }
                if ((_170.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                {
                    uint v0_custom0_1 = 0u;
                    uint v1_custom0_1 = 0u;
                    if (input_has_custom0)
                    {
                        uint param_52 = i0;
                        uint _737 = get_custom0(param_52);
                        v0_custom0_1 = _737;
                        uint param_53 = i1;
                        uint _740 = get_custom0(param_53);
                        v1_custom0_1 = _740;
                    }
                    uint param_54 = ie0;
                    uint param_55 = v0_custom0_1;
                    put_custom0(param_54, param_55);
                    uint param_56 = ie1;
                    uint param_57 = v0_custom0_1;
                    put_custom0(param_56, param_57);
                }
            }
            if (ires1.found)
            {
                uint ie0_1 = edge_hashmap_values.values[ires1.slot];
                uint ie1_1 = ie0_1 + 1u;
                ie0_1 += _301.input_geometry_information.vtx_num;
                ie1_1 += _301.input_geometry_information.vtx_num;
                uint param_58 = i1;
                uint param_59 = i2;
                if (is_edge_key_swapped(param_58, param_59) == false)
                {
                    w0_1 = 0.3333333432674407958984375;
                    w1_1 = 0.666666686534881591796875;
                }
                else
                {
                    w0_1 = 0.666666686534881591796875;
                    w1_1 = 0.3333333432674407958984375;
                }
                uint param_60 = ie0_1;
                vec3 param_61 = mix(v1_coords, v2_coords, vec3(w0_1));
                put_coords(param_60, param_61);
                uint param_62 = ie1_1;
                vec3 param_63 = mix(v1_coords, v2_coords, vec3(w1_1));
                put_coords(param_62, param_63);
                if ((_170.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                {
                    vec3 v1_normal_2 = vec3(0.0, 0.0, 1.0);
                    vec3 v2_normal_2 = vec3(0.0, 0.0, 1.0);
                    if (input_has_normals)
                    {
                        uint param_64 = i1;
                        vec3 _813 = get_normal(param_64);
                        v1_normal_2 = _813;
                        uint param_65 = i2;
                        vec3 _816 = get_normal(param_65);
                        v2_normal_2 = _816;
                    }
                    uint param_66 = ie0_1;
                    vec3 param_67 = normalize(mix(v1_normal_2, v2_normal_2, vec3(w0_1)));
                    put_normal(param_66, param_67);
                    uint param_68 = ie1_1;
                    vec3 param_69 = normalize(mix(v1_normal_2, v2_normal_2, vec3(w1_1)));
                    put_normal(param_68, param_69);
                }
                if ((_170.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                {
                    uint v1_custom0_2 = 0u;
                    uint v2_custom0_1 = 0u;
                    if (input_has_custom0)
                    {
                        uint param_70 = i1;
                        uint _850 = get_custom0(param_70);
                        v1_custom0_2 = _850;
                        uint param_71 = i2;
                        uint _853 = get_custom0(param_71);
                        v2_custom0_1 = _853;
                    }
                    uint param_72 = ie0_1;
                    uint param_73 = v1_custom0_2;
                    put_custom0(param_72, param_73);
                    uint param_74 = ie1_1;
                    uint param_75 = v1_custom0_2;
                    put_custom0(param_74, param_75);
                }
            }
            if (ires2.found)
            {
                uint ie0_2 = edge_hashmap_values.values[ires2.slot];
                uint ie1_2 = ie0_2 + 1u;
                ie0_2 += _301.input_geometry_information.vtx_num;
                ie1_2 += _301.input_geometry_information.vtx_num;
                uint param_76 = i0;
                uint param_77 = i2;
                if (is_edge_key_swapped(param_76, param_77))
                {
                    w0_2 = 0.3333333432674407958984375;
                    w1_2 = 0.666666686534881591796875;
                }
                else
                {
                    w0_2 = 0.666666686534881591796875;
                    w1_2 = 0.3333333432674407958984375;
                }
                uint param_78 = ie0_2;
                vec3 param_79 = mix(v2_coords, v0_coords, vec3(w0_2));
                put_coords(param_78, param_79);
                uint param_80 = ie1_2;
                vec3 param_81 = mix(v2_coords, v0_coords, vec3(w1_2));
                put_coords(param_80, param_81);
                if ((_170.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                {
                    vec3 v2_normal_3 = vec3(0.0, 0.0, 1.0);
                    vec3 v0_normal_2 = vec3(0.0, 0.0, 1.0);
                    if (input_has_normals)
                    {
                        uint param_82 = i2;
                        vec3 _925 = get_normal(param_82);
                        v2_normal_3 = _925;
                        uint param_83 = i0;
                        vec3 _928 = get_normal(param_83);
                        v0_normal_2 = _928;
                    }
                    uint param_84 = ie0_2;
                    vec3 param_85 = normalize(mix(v2_normal_3, v0_normal_2, vec3(w0_2)));
                    put_normal(param_84, param_85);
                    uint param_86 = ie1_2;
                    vec3 param_87 = normalize(mix(v2_normal_3, v0_normal_2, vec3(w1_2)));
                    put_normal(param_86, param_87);
                }
                if ((_170.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                {
                    uint v2_custom0_2 = 0u;
                    uint v0_custom0_2 = 0u;
                    if (input_has_custom0)
                    {
                        uint param_88 = i2;
                        uint _962 = get_custom0(param_88);
                        v2_custom0_2 = _962;
                        uint param_89 = i0;
                        uint _965 = get_custom0(param_89);
                        v0_custom0_2 = _965;
                    }
                    uint param_90 = ie0_2;
                    uint param_91 = v2_custom0_2;
                    put_custom0(param_90, param_91);
                    uint param_92 = ie1_2;
                    uint param_93 = v2_custom0_2;
                    put_custom0(param_92, param_93);
                }
            }
            if (split_edges > 0u)
            {
                uint _983 = atomicAdd(_170.output_geometry_information.aux_tracking_1, 1u);
                uint iec = _983;
                uint param_94 = iec;
                vec3 param_95 = ((v0_coords + v1_coords) + v2_coords) / vec3(3.0);
                put_coords(param_94, param_95);
                if ((_170.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                {
                    vec3 v0_normal_3 = vec3(0.0, 0.0, 1.0);
                    vec3 v1_normal_3 = vec3(0.0, 0.0, 1.0);
                    vec3 v2_normal_4 = vec3(0.0, 0.0, 1.0);
                    if (input_has_normals)
                    {
                        uint param_96 = i0;
                        vec3 _1010 = get_normal(param_96);
                        v0_normal_3 = _1010;
                        uint param_97 = i1;
                        vec3 _1013 = get_normal(param_97);
                        v1_normal_3 = _1013;
                        uint param_98 = i2;
                        vec3 _1016 = get_normal(param_98);
                        v2_normal_4 = _1016;
                    }
                    uint param_99 = iec;
                    vec3 param_100 = normalize(((v0_normal_3 + v1_normal_3) + v2_normal_4) / vec3(3.0));
                    put_normal(param_99, param_100);
                }
                if ((_170.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                {
                    uint v0_custom0_3 = 0u;
                    uint v1_custom0_3 = 0u;
                    uint v2_custom0_3 = 0u;
                    if (input_has_custom0)
                    {
                        uint param_101 = i0;
                        uint _1043 = get_custom0(param_101);
                        v0_custom0_3 = _1043;
                        uint param_102 = i1;
                        uint _1046 = get_custom0(param_102);
                        v1_custom0_3 = _1046;
                        uint param_103 = i2;
                        uint _1049 = get_custom0(param_103);
                        v2_custom0_3 = _1049;
                    }
                    uint param_104 = iec;
                    uint param_105 = v0_custom0_3;
                    put_custom0(param_104, param_105);
                }
                uint ie0_3 = i0;
                uint ie3 = i1;
                uint ie6 = i2;
                if (ires0.found)
                {
                    uint param_106 = i0;
                    uint param_107 = i1;
                    if (is_edge_key_swapped(param_106, param_107) == false)
                    {
                        ie1_3 = edge_hashmap_values.values[ires0.slot] + 0u;
                        ie2 = edge_hashmap_values.values[ires0.slot] + 1u;
                    }
                    else
                    {
                        ie1_3 = edge_hashmap_values.values[ires0.slot] + 1u;
                        ie2 = edge_hashmap_values.values[ires0.slot] + 0u;
                    }
                    ie1_3 += _301.input_geometry_information.vtx_num;
                    ie2 += _301.input_geometry_information.vtx_num;
                }
                else
                {
                    ie1_3 = i0;
                    ie2 = i1;
                }
                if (ires1.found)
                {
                    uint param_108 = i1;
                    uint param_109 = i2;
                    if (is_edge_key_swapped(param_108, param_109) == false)
                    {
                        ie4 = edge_hashmap_values.values[ires1.slot] + 0u;
                        ie5 = edge_hashmap_values.values[ires1.slot] + 1u;
                    }
                    else
                    {
                        ie4 = edge_hashmap_values.values[ires1.slot] + 1u;
                        ie5 = edge_hashmap_values.values[ires1.slot] + 0u;
                    }
                    ie4 += _301.input_geometry_information.vtx_num;
                    ie5 += _301.input_geometry_information.vtx_num;
                }
                else
                {
                    ie4 = i1;
                    ie5 = i2;
                }
                if (ires2.found)
                {
                    uint param_110 = i2;
                    uint param_111 = i0;
                    if (is_edge_key_swapped(param_110, param_111) == false)
                    {
                        ie7 = edge_hashmap_values.values[ires2.slot] + 0u;
                        ie8 = edge_hashmap_values.values[ires2.slot] + 1u;
                    }
                    else
                    {
                        ie7 = edge_hashmap_values.values[ires2.slot] + 1u;
                        ie8 = edge_hashmap_values.values[ires2.slot] + 0u;
                    }
                    ie7 += _301.input_geometry_information.vtx_num;
                    ie8 += _301.input_geometry_information.vtx_num;
                }
                else
                {
                    ie7 = i2;
                    ie8 = i0;
                }
                if (split_edges == 1u)
                {
                    added_faces = 5u;
                }
                else
                {
                    if (split_edges == 2u)
                    {
                        added_faces = 7u;
                    }
                    else
                    {
                        added_faces = 9u;
                    }
                }
                uint _1217 = atomicAdd(_170.output_geometry_information.faces_num_per_surface[surface_idx], added_faces);
                uint dst_face_idx = _1217;
                uint dummy_face_idx = dst_face_idx;
                uint ui = 0u;
                for (;;)
                {
                    if (ui < added_faces)
                    {
                        uint param_112 = (dummy_face_idx * 3u) + 0u;
                        uint param_113 = 0u;
                        put_idx(param_112, param_113);
                        uint param_114 = (dummy_face_idx * 3u) + 1u;
                        uint param_115 = 0u;
                        put_idx(param_114, param_115);
                        uint param_116 = (dummy_face_idx * 3u) + 2u;
                        uint param_117 = 0u;
                        put_idx(param_116, param_117);
                        dummy_face_idx++;
                        ui++;
                        continue;
                    }
                    else
                    {
                        break;
                    }
                }
                uint param_118 = dst_face_idx;
                uint param_119 = ie0_3;
                uint param_120 = ie1_3;
                uint param_121 = ie8;
                uint _1259 = put_face_idx_check_degenerate(param_118, param_119, param_120, param_121);
                dst_face_idx = _1259;
                uint param_122 = dst_face_idx;
                uint param_123 = ie8;
                uint param_124 = ie1_3;
                uint param_125 = iec;
                uint _1268 = put_face_idx_check_degenerate(param_122, param_123, param_124, param_125);
                dst_face_idx = _1268;
                uint param_126 = dst_face_idx;
                uint param_127 = iec;
                uint param_128 = ie1_3;
                uint param_129 = ie2;
                uint _1277 = put_face_idx_check_degenerate(param_126, param_127, param_128, param_129);
                dst_face_idx = _1277;
                uint param_130 = dst_face_idx;
                uint param_131 = iec;
                uint param_132 = ie2;
                uint param_133 = ie4;
                uint _1286 = put_face_idx_check_degenerate(param_130, param_131, param_132, param_133);
                dst_face_idx = _1286;
                uint param_134 = dst_face_idx;
                uint param_135 = ie4;
                uint param_136 = ie2;
                uint param_137 = ie3;
                uint _1295 = put_face_idx_check_degenerate(param_134, param_135, param_136, param_137);
                dst_face_idx = _1295;
                uint param_138 = dst_face_idx;
                uint param_139 = ie5;
                uint param_140 = iec;
                uint param_141 = ie4;
                uint _1304 = put_face_idx_check_degenerate(param_138, param_139, param_140, param_141);
                dst_face_idx = _1304;
                uint param_142 = dst_face_idx;
                uint param_143 = ie5;
                uint param_144 = ie7;
                uint param_145 = iec;
                uint _1313 = put_face_idx_check_degenerate(param_142, param_143, param_144, param_145);
                dst_face_idx = _1313;
                uint param_146 = dst_face_idx;
                uint param_147 = ie7;
                uint param_148 = ie8;
                uint param_149 = iec;
                uint _1322 = put_face_idx_check_degenerate(param_146, param_147, param_148, param_149);
                dst_face_idx = _1322;
                uint param_150 = dst_face_idx;
                uint param_151 = ie5;
                uint param_152 = ie6;
                uint param_153 = ie7;
                uint _1331 = put_face_idx_check_degenerate(param_150, param_151, param_152, param_153);
                dst_face_idx = _1331;
                uint max_ie = _301.input_geometry_information.vtx_num;
                max_ie = max(max_ie, max(ie0_3, max(ie1_3, ie2)));
                max_ie = max(max_ie, max(ie3, max(ie4, ie5)));
                max_ie = max(max_ie, max(ie6, max(ie7, ie8)));
                max_ie = max(max_ie, iec) + 1u;
                uint _1362 = atomicMax(_170.output_geometry_information.vtx_num, max_ie);
            }
            else
            {
                uint _1367 = atomicAdd(_170.output_geometry_information.faces_num_per_surface[surface_idx], 1u);
                uint dst_face_idx_1 = _1367;
                uint param_154 = (dst_face_idx_1 * 3u) + 0u;
                uint param_155 = i0;
                put_idx(param_154, param_155);
                uint param_156 = (dst_face_idx_1 * 3u) + 1u;
                uint param_157 = i1;
                put_idx(param_156, param_157);
                uint param_158 = (dst_face_idx_1 * 3u) + 2u;
                uint param_159 = i2;
                put_idx(param_158, param_159);
            }
            src_face_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
    if (thread_idx == 0u)
    {
        uint _1399 = atomicMax(_170.output_geometry_information.vtx_num, _301.input_geometry_information.vtx_num);
    }
}

 