#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

const float _394[7] = float[](0.071303434669971466064453125, 0.13151411712169647216796875, 0.189879238605499267578125, 0.2146064341068267822265625, 0.189879238605499267578125, 0.13151411712169647216796875, 0.071303434669971466064453125);

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float occlusion_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float rt_strength;
    float ibl_intensity;
    uint transparency_blend;
    float taa_blend;
    float taa_gamma;
    float _pad0;
    float _pad1;
    float _pad2;
    vec2 taa_jitter;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct CompositeParams
{
    float ssr_scaling_factor;
    int composite_output_mode;
    float raytrace_scaling_factor;
    float _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _307;

layout(set = 0, binding = 2, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _500;

layout(set = 0, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 4, std140) uniform CompositeParamsBuffer
{
    CompositeParams composite_params;
} _877;

layout(set = 0, binding = 10) uniform sampler2D sVolumetricFog;
layout(set = 0, binding = 11) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 12) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 13) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 14) uniform sampler2D sAlbedo;
layout(set = 0, binding = 15) uniform sampler2D sShadow;
layout(set = 0, binding = 16) uniform sampler2D sVoxelLighting;
layout(set = 0, binding = 17) uniform sampler2D sVoxelOcclusion;
layout(set = 0, binding = 18) uniform sampler2D sScreenSpaceOcclusion;
layout(set = 0, binding = 19) uniform sampler2D sParticles;
layout(set = 0, binding = 5, rgba32f) uniform readonly image2D imRaytraceHitDirectionPrimitiveIdReflection;
layout(set = 0, binding = 6, rgba32f) uniform readonly image2D imRaytraceHitDirectionPrimitiveIdTransparency;
layout(set = 0, binding = 7, rgba16f) uniform readonly image2D imRaytraceShadedReflection;
layout(set = 0, binding = 8, rgba16f) uniform readonly image2D imRaytraceShadedTransparency;
layout(set = 0, binding = 9, rgba16f) uniform writeonly image2D imTarget;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _136;
    if (nor.x > 0.0)
    {
        _136 = -t;
    }
    else
    {
        _136 = t;
    }
    nor.x += _136;
    float _151;
    if (nor.y > 0.0)
    {
        _151 = -t;
    }
    else
    {
        _151 = t;
    }
    nor.y += _151;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _307.dispatch_setup.near_far_plane.z / ((_307.dispatch_setup.near_far_plane.y + _307.dispatch_setup.near_far_plane.x) - (d * _307.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepthCurrent(vec3 vDirection, float depth)
{
    return (_307.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

vec4 calculate_lighting_fill(vec3 pos, vec3 normal, vec3 light_pos, vec3 cam_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    vec3 specular = vec3(0.0);
    if (d > 0.0)
    {
        specular = _500.composite_setup.fill_color.xxx * pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0);
    }
    return vec4((vec3(d) * _500.composite_setup.fill_color.xyz) + specular, 1.0);
}

vec4 sample_volumetric_fog(uvec2 pixel_pos, float ref_depth, uint ref_material_idx)
{
    vec4 c0 = texelFetch(sVolumetricFog, ivec2(pixel_pos), 0);
    vec4 vc = vec4(0.0);
    float total_w = 1.0;
    int y = -3;
    for (;;)
    {
        if (y <= 3)
        {
            int x = -3;
            for (;;)
            {
                if (x <= 3)
                {
                    if ((x == 0) && (y == 0))
                    {
                        int _456 = x;
                        x = _456 + 1;
                        continue;
                    }
                    ivec2 sampling_pos = ivec2(pixel_pos) + ivec2(x, y);
                    float w = _394[x + 3] * _394[y + 3];
                    uvec4 param = texelFetch(sMetalnessRoughnessMaterialTags, sampling_pos, 0);
                    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
                    if (ref_material_idx != metalness_roughness_material_tags.material_index)
                    {
                        w = 0.0;
                    }
                    float depth = texelFetch(sTextureDepth, sampling_pos, 0).x;
                    if (abs(depth - ref_depth) > 0.00999999977648258209228515625)
                    {
                        w = 0.0;
                    }
                    if (w > 0.0)
                    {
                        vec4 c = texelFetch(sVolumetricFog, sampling_pos, 0);
                        vc += (c * w);
                        total_w += w;
                    }
                    int _456 = x;
                    x = _456 + 1;
                    continue;
                }
                else
                {
                    break;
                }
            }
            y++;
            continue;
        }
        else
        {
            break;
        }
    }
    return (c0 + vc) / vec4(total_w);
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 TurboColormap(inout float x)
{
    x = clamp(x, 0.0, 1.0);
    vec4 v4 = vec4(1.0, x, x * x, (x * x) * x);
    vec2 v2 = v4.zw * v4.z;
    return vec3(dot(v4, vec4(0.135721385478973388671875, 4.6153926849365234375, -42.6603240966796875, 132.1310882568359375)) + dot(v2, vec2(-152.9423980712890625, 59.286380767822265625)), dot(v4, vec4(0.091402612626552581787109375, 2.1941883563995361328125, 4.842966556549072265625, -14.1850337982177734375)) + dot(v2, vec2(4.277298450469970703125, 2.82956600189208984375)), dot(v4, vec4(0.106673300266265869140625, 12.64194583892822265625, -60.5820465087890625, 110.36277008056640625)) + dot(v2, vec2(-89.903106689453125, 27.3482494354248046875)));
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 pixel_pos_inv_y = pixel_pos;
    pixel_pos_inv_y.y = uint(_307.dispatch_setup.resolution.y) - pixel_pos_inv_y.y;
    vec3 view_direction;
    view_direction.x = (-_307.dispatch_setup.camera_projection_params.z) + ((_307.dispatch_setup.camera_projection_params.x * float(pixel_pos.x)) * _307.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_307.dispatch_setup.camera_projection_params.w) + ((_307.dispatch_setup.camera_projection_params.y * float(pixel_pos.y)) * _307.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float dither = 0.0;
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(pixel_pos), 0).x;
    uint param = encoded_normal_material;
    vec3 _593 = decode_normal(param);
    vec3 normal = _593;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    MaterialPropertiesGPU material;
    material.flags = 0u;
    bool is_background = false;
    float depth = 0.0;
    vec4 albedo;
    vec4 color;
    if ((materialId & 1) == 1)
    {
        is_background = true;
        albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
        color = albedo;
    }
    vec3 local_normal = vec3(0.0, 0.0, -1.0);
    vec4 shadow = vec4(1.0, 1.0, 1.0, 0.0);
    vec4 voxel_light = vec4(0.0);
    float voxel_occlusion_diffuse = 0.0;
    float voxel_occlusion_specular = 0.0;
    float voxel_occlusion_combined = 0.0;
    albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
    if (is_background == false)
    {
        local_normal.x = dot(normal, _307.dispatch_setup.mat_model[0].xyz);
        local_normal.y = dot(normal, _307.dispatch_setup.mat_model[1].xyz);
        local_normal.z = dot(normal, _307.dispatch_setup.mat_model[2].xyz);
        depth = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
        shadow = texelFetch(sShadow, ivec2(pixel_pos), 0);
        voxel_light = texelFetch(sVoxelLighting, ivec2(pixel_pos), 0);
        voxel_occlusion_combined = voxel_light.w;
        vec2 voxel_occlusion = texelFetch(sVoxelOcclusion, ivec2(pixel_pos), 0).xy;
        voxel_occlusion_diffuse = voxel_occlusion.x;
        voxel_occlusion_specular = voxel_occlusion.y;
        vec4 color_1 = vec4(0.0);
        vec3 _691 = abs(local_normal);
        color_1.x = _691.x;
        color_1.y = _691.y;
        color_1.z = _691.z;
    }
    float param_2 = depth;
    float linear_depth = linearizeDepth(param_2);
    float hbao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
    if (_500.composite_setup.sso_strength > 0.0)
    {
        hbao = pow(hbao, _500.composite_setup.sso_strength);
    }
    vec4 ssr = vec4(0.0);
    vec4 particles = texelFetch(sParticles, ivec2(pixel_pos), 0);
    float ssr_factor = 0.0;
    vec3 param_3 = view_direction;
    float param_4 = linear_depth;
    vec3 world = positionFromDepthCurrent(param_3, param_4);
    uvec4 param_5 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_5);
    uint materialIndex = metalness_roughness_material_tags.material_index;
    if (is_background == false)
    {
        MaterialPropertiesGPU _761;
        _761.diffuse = materials.material_properties[materialIndex].diffuse;
        _761.transparency = materials.material_properties[materialIndex].transparency;
        _761.emissive = materials.material_properties[materialIndex].emissive;
        _761.roughness = materials.material_properties[materialIndex].roughness;
        _761.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _761.refraction = materials.material_properties[materialIndex].refraction;
        _761.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _761.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _761.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _761.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _761.metalness = materials.material_properties[materialIndex].metalness;
        _761.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _761.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _761.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _761.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _761.flags = materials.material_properties[materialIndex].flags;
        _761._pad0 = materials.material_properties[materialIndex]._pad0;
        _761._pad1 = materials.material_properties[materialIndex]._pad1;
        material = _761;
    }
    vec4 _762 = shadow;
    vec4 _770 = shadow;
    vec3 _772 = _770.xyz + ((_762.xyz * voxel_light.xyz) * _500.composite_setup.global_illumination_strength);
    shadow.x = _772.x;
    shadow.y = _772.y;
    shadow.z = _772.z;
    vec4 _784 = shadow;
    vec3 _786 = _784.xyz + (voxel_light.xyz * _500.composite_setup.global_illumination_base_strength);
    shadow.x = _786.x;
    shadow.y = _786.y;
    shadow.z = _786.z;
    vec3 param_6 = world;
    vec3 param_7 = local_normal;
    vec3 param_8 = vec3(0.0);
    vec3 param_9 = vec3(0.0);
    float param_10 = dot(local_normal, normalize(-world));
    vec4 fill_color = calculate_lighting_fill(param_6, param_7, param_8, param_9, param_10);
    vec4 _809 = shadow;
    vec3 _811 = _809.xyz + fill_color.xyz;
    shadow.x = _811.x;
    shadow.y = _811.y;
    shadow.z = _811.z;
    color.w = 1.0;
    if (is_background == false)
    {
        vec3 _834 = (vec3(max(0.0, 1.0 - shadow.w)) * shadow.xyz) + _500.composite_setup.ambient_color.xyz;
        color.x = _834.x;
        color.y = _834.y;
        color.z = _834.z;
    }
    shadow.w = pow((shadow.w * linear_depth) / 10.0, 2.0);
    vec4 _853 = color;
    vec3 _855 = _853.xyz + (ssr.xyz * 4.0);
    color.x = _855.x;
    color.y = _855.y;
    color.z = _855.z;
    vec4 _864 = color;
    vec3 _867 = _864.xyz + vec3(shadow.w);
    color.x = _867.x;
    color.y = _867.y;
    color.z = _867.z;
    if (_877.composite_params.composite_output_mode == 0)
    {
        float fog_density = linear_depth;
        if (_500.composite_setup.fog_range > 0.0)
        {
            fog_density /= _500.composite_setup.fog_range;
        }
        else
        {
            fog_density = 0.0;
        }
        float fog_height_density = (1.0 - clamp(abs(world.y) / _500.composite_setup.fog_height, 0.0, 1.0)) * _500.composite_setup.fog_height_density;
        fog_density = exp(fog_density + fog_height_density) - 1.0;
        float fog_density_margin = 0.00999999977648258209228515625;
        fog_density = clamp(fog_density, fog_density_margin, 1.0 - fog_density_margin);
        vec3 fog_color = _500.composite_setup.fog_color.xyz;
        vec4 _924 = color;
        vec3 _929 = mix(_924.xyz, fog_color, vec3(fog_density));
        color.x = _929.x;
        color.y = _929.y;
        color.z = _929.z;
        uvec2 param_11 = pixel_pos;
        float param_12 = depth;
        uint param_13 = materialIndex;
        vec4 volumetric_fog_color = sample_volumetric_fog(param_11, param_12, param_13);
        if (_500.composite_setup.volumetric_fog_intensity > 0.0)
        {
            vec4 _950 = volumetric_fog_color;
            vec3 _955 = pow(_950.xyz, vec3(_500.composite_setup.volumetric_fog_intensity));
            volumetric_fog_color.x = _955.x;
            volumetric_fog_color.y = _955.y;
            volumetric_fog_color.z = _955.z;
        }
        float volumetric_fog_blend = volumetric_fog_color.w;
        if (true)
        {
            volumetric_fog_blend = 1.0 - volumetric_fog_blend;
            if (_500.composite_setup.volumetric_fog_strength > 0.0)
            {
                volumetric_fog_blend = exp((-volumetric_fog_blend) / _500.composite_setup.volumetric_fog_strength);
            }
            else
            {
                volumetric_fog_blend = 0.0;
            }
            volumetric_fog_blend = clamp(volumetric_fog_blend * _500.composite_setup.volumetric_fog_intensity, 0.0, 1.0);
        }
        vec4 _987 = color;
        vec3 _993 = mix(_987.xyz, volumetric_fog_color.xyz, vec3(volumetric_fog_blend));
        color.x = _993.x;
        color.y = _993.y;
        color.z = _993.z;
        if (_500.composite_setup.transparency_blend == 0u)
        {
            vec4 _1012 = color;
            vec3 _1014 = _1012.xyz + (particles.xyz * (1.0 - volumetric_fog_blend));
            color.x = _1014.x;
            color.y = _1014.y;
            color.z = _1014.z;
        }
        if (_500.composite_setup.transparency_blend == 1u)
        {
            vec4 _1026 = color;
            vec3 _1034 = mix(_1026.xyz, particles.xyz, vec3(1.0 - particles.w));
            color.x = _1034.x;
            color.y = _1034.y;
            color.z = _1034.z;
        }
    }
    if (false)
    {
        vec4 hit_direction_primitiveID = imageLoad(imRaytraceHitDirectionPrimitiveIdReflection, ivec2(pixel_pos));
        float param_14 = hit_direction_primitiveID.w;
        uint hit_primitiveID = asuint(param_14);
        if (hit_primitiveID != 4294967295u)
        {
            float param_15 = fract(float(hit_primitiveID) * 0.13452999293804168701171875);
            vec3 _1067 = TurboColormap(param_15);
            vec3 _1071 = vec3(_1067);
            color.x = _1071.x;
            color.y = _1071.y;
            color.z = _1071.z;
        }
    }
    if (false)
    {
        vec4 hit_direction_primitiveID_1 = imageLoad(imRaytraceHitDirectionPrimitiveIdTransparency, ivec2(pixel_pos));
        float param_16 = hit_direction_primitiveID_1.w;
        uint hit_primitiveID_1 = asuint(param_16);
        if (hit_primitiveID_1 != 4294967295u)
        {
            float param_17 = fract(float(hit_primitiveID_1) * 0.13452999293804168701171875);
            vec3 _1100 = TurboColormap(param_17);
            vec3 _1104 = vec3(_1100);
            color.x = _1104.x;
            color.y = _1104.y;
            color.z = _1104.z;
        }
        else
        {
            color.x = 0.0;
        }
    }
    if (false)
    {
        vec4 rt_shaded_reflection = imageLoad(imRaytraceShadedReflection, ivec2(pixel_pos));
        if (rt_shaded_reflection.w != 0.0)
        {
            color.x = rt_shaded_reflection.xyz.x;
            color.y = rt_shaded_reflection.xyz.y;
            color.z = rt_shaded_reflection.xyz.z;
        }
    }
    if (false)
    {
        vec4 rt_shaded_transparency = imageLoad(imRaytraceShadedTransparency, ivec2(pixel_pos));
        if (rt_shaded_transparency.w != 0.0)
        {
            color.x = rt_shaded_transparency.xyz.x;
            color.y = rt_shaded_transparency.xyz.y;
            color.z = rt_shaded_transparency.xyz.z;
        }
    }
    if (false)
    {
        vec4 rt_shaded_reflection_1 = imageLoad(imRaytraceShadedReflection, ivec2(pixel_pos));
        vec4 rt_shaded_transparency_1 = imageLoad(imRaytraceShadedTransparency, ivec2(pixel_pos));
        if (rt_shaded_transparency_1.w != 0.0)
        {
            color.x = rt_shaded_transparency_1.xyz.x;
            color.y = rt_shaded_transparency_1.xyz.y;
            color.z = rt_shaded_transparency_1.xyz.z;
            vec4 _1184 = color;
            vec3 _1186 = _1184.xyz + rt_shaded_reflection_1.xyz;
            color.x = _1186.x;
            color.y = _1186.y;
            color.z = _1186.z;
        }
        else
        {
            color.x = 1.0;
            color.y = 1.0;
            color.z = 1.0;
        }
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 