#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct LTCRect
{
    vec3 center;
    vec3 dirx;
    vec3 diry;
    float halfx;
    float halfy;
    vec4 plane;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct VoxelizationDispatchParams
{
    int lights_num;
    uint component_tags;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

layout(set = 1, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _192;

layout(set = 1, binding = 2, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _218;

layout(set = 1, binding = 3, std430) buffer VoxelLightBuffer
{
    uint in_voxel_light_data[];
} _287;

layout(set = 1, binding = 4, std430) buffer VoxelOcclusionBuffer
{
    uint in_voxel_occlusion_data[];
} _311;

layout(set = 1, binding = 5, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 6, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 7, std140) uniform VoxelizationDispatchParamsBuffer
{
    VoxelizationDispatchParams dispatch_params;
} _2660;

layout(set = 1, binding = 8, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 9) uniform sampler2D s_LTC2;
layout(set = 1, binding = 10) uniform sampler2D material_textures[64];
layout(set = 1, binding = 74) uniform sampler2DShadow LightShadowmapCmpSamplers[16];

layout(location = 0) flat in int vOrientationIndex;
layout(location = 5) flat in uint vTriIndex[3];
layout(location = 1) in vec3 vGridCoords;
layout(location = 3) flat in vec3 vTriNormal;
layout(location = 8) in vec4 vColor;
layout(location = 2) in vec2 vUV0;
layout(location = 4) flat in vec3 vTriNormalForLighting;
bool twoSided;
bool clipless;

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_192.in_vtx_data[coord_offset + 0u], _192.in_vtx_data[coord_offset + 1u], _192.in_vtx_data[coord_offset + 2u]);
    return p;
}

uint build_step_dir()
{
    if (vOrientationIndex == 0)
    {
        return 1u;
    }
    else
    {
        if (vOrientationIndex == 1)
        {
            return 2u;
        }
        else
        {
            return 4u;
        }
    }
}

ivec3 unpack_step_dir(uint step_dir)
{
    return ivec3(int((step_dir & 1u) != 0u), int((step_dir & 2u) != 0u), int((step_dir & 4u) != 0u));
}

int planeBoxOverlap(vec3 normal, vec3 vert, vec3 maxbox)
{
    vec3 s = step(vec3(0.0), normal);
    vec3 sgn = (s * 2.0) - vec3(1.0);
    vec3 vmin = ((-sgn) * maxbox) - vert;
    vec3 vmax = (sgn * maxbox) - vert;
    if (dot(normal, vmin) > 0.0)
    {
        return 0;
    }
    if (dot(normal, vmax) >= 0.0)
    {
        return 1;
    }
    return 0;
}

int triBoxOverlap(vec3 boxcenter, vec3 boxhalfsize, vec3 tv0, vec3 tv1, vec3 tv2, vec3 normal)
{
    vec3 v0 = tv0 - boxcenter;
    vec3 v1 = tv1 - boxcenter;
    vec3 v2 = tv2 - boxcenter;
    vec3 e0 = v1 - v0;
    vec3 e1 = v2 - v1;
    vec3 e2 = v0 - v2;
    float fex = abs(e0.x);
    float fey = abs(e0.y);
    float fez = abs(e0.z);
    float p0 = (e0.z * v0.y) - (e0.y * v0.z);
    float p2 = (e0.z * v2.y) - (e0.y * v2.z);
    float mi;
    float ma;
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    float rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _692 = mi > rad;
    bool _700;
    if (!_692)
    {
        _700 = ma < (-rad);
    }
    else
    {
        _700 = _692;
    }
    if (_700)
    {
        return 0;
    }
    p0 = ((-e0.z) * v0.x) + (e0.x * v0.z);
    p2 = ((-e0.z) * v2.x) + (e0.x * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _749 = mi > rad;
    bool _757;
    if (!_749)
    {
        _757 = ma < (-rad);
    }
    else
    {
        _757 = _749;
    }
    if (_757)
    {
        return 0;
    }
    float p1 = (e0.y * v1.x) - (e0.x * v1.y);
    p2 = (e0.y * v2.x) - (e0.x * v2.y);
    if (p2 < p1)
    {
        mi = p2;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p2;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _805 = mi > rad;
    bool _813;
    if (!_805)
    {
        _813 = ma < (-rad);
    }
    else
    {
        _813 = _805;
    }
    if (_813)
    {
        return 0;
    }
    fex = abs(e1.x);
    fey = abs(e1.y);
    fez = abs(e1.z);
    p0 = (e1.z * v0.y) - (e1.y * v0.z);
    p2 = (e1.z * v2.y) - (e1.y * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _869 = mi > rad;
    bool _877;
    if (!_869)
    {
        _877 = ma < (-rad);
    }
    else
    {
        _877 = _869;
    }
    if (_877)
    {
        return 0;
    }
    p0 = ((-e1.z) * v0.x) + (e1.x * v0.z);
    p2 = ((-e1.z) * v2.x) + (e1.x * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _926 = mi > rad;
    bool _934;
    if (!_926)
    {
        _934 = ma < (-rad);
    }
    else
    {
        _934 = _926;
    }
    if (_934)
    {
        return 0;
    }
    p0 = (e1.y * v0.x) - (e1.x * v0.y);
    p1 = (e1.y * v1.x) - (e1.x * v1.y);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _981 = mi > rad;
    bool _989;
    if (!_981)
    {
        _989 = ma < (-rad);
    }
    else
    {
        _989 = _981;
    }
    if (_989)
    {
        return 0;
    }
    fex = abs(e2.x);
    fey = abs(e2.y);
    fez = abs(e2.z);
    p0 = (e2.z * v0.y) - (e2.y * v0.z);
    p1 = (e2.z * v1.y) - (e2.y * v1.z);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _1045 = mi > rad;
    bool _1053;
    if (!_1045)
    {
        _1053 = ma < (-rad);
    }
    else
    {
        _1053 = _1045;
    }
    if (_1053)
    {
        return 0;
    }
    p0 = ((-e2.z) * v0.x) + (e2.x * v0.z);
    p1 = ((-e2.z) * v1.x) + (e2.x * v1.z);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _1102 = mi > rad;
    bool _1110;
    if (!_1102)
    {
        _1110 = ma < (-rad);
    }
    else
    {
        _1110 = _1102;
    }
    if (_1110)
    {
        return 0;
    }
    p1 = (e2.y * v1.x) - (e2.x * v1.y);
    p2 = (e2.y * v2.x) - (e2.x * v2.y);
    if (p2 < p1)
    {
        mi = p2;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p2;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _1157 = mi > rad;
    bool _1165;
    if (!_1157)
    {
        _1165 = ma < (-rad);
    }
    else
    {
        _1165 = _1157;
    }
    if (_1165)
    {
        return 0;
    }
    vec3 mi3 = min(v0, min(v1, v2));
    vec3 ma3 = max(v0, max(v1, v2));
    bool _1186 = any(greaterThan(mi3, boxhalfsize));
    bool _1195;
    if (!_1186)
    {
        _1195 = any(lessThan(ma3, -boxhalfsize));
    }
    else
    {
        _1195 = _1186;
    }
    bool no_overlap = _1195;
    if (no_overlap)
    {
        return 0;
    }
    vec3 param = normal;
    vec3 param_1 = v0;
    vec3 param_2 = boxhalfsize;
    return planeBoxOverlap(param, param_1, param_2);
}

bool checkTriCellOverlap(vec3 p0, vec3 p1, vec3 p2, vec3 normal, vec3 ccenter, vec3 csize)
{
    vec3 param = ccenter;
    vec3 param_1 = csize;
    vec3 param_2 = p0;
    vec3 param_3 = p1;
    vec3 param_4 = p2;
    vec3 param_5 = normal;
    return triBoxOverlap(param, param_1, param_2, param_3, param_4, param_5) != 0;
}

uint rt_calculate_grid_cell_idx(uint cx, uint cy, uint cz)
{
    return (cx + (cy * 256u)) + ((cz * 256u) * 256u);
}

void rt_store_voxel_occlusion(uint cx, uint cy, uint cz, float v)
{
    uint param = cx;
    uint param_1 = cy;
    uint param_2 = cz;
    uint idx = rt_calculate_grid_cell_idx(param, param_1, param_2);
    uint _318 = atomicMax(_311.in_voxel_occlusion_data[idx], uint(v * 1024.0));
}

int rt_get_triangle_material(uint idx)
{
    int p = int(_218.transformed_data_faces[idx].material_idx);
    return p;
}

vec3 calculate_lighting_world(LightProperties light, vec3 pos, vec3 normal, vec3 light_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    return vec3(vec3(d) * light.diffuse.xyz);
}

float sampleShadowPCF(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, int samples, float sampling_range)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _334 = coords.x < (-coords.w);
    bool _343;
    if (!_334)
    {
        _343 = coords.x > coords.w;
    }
    else
    {
        _343 = _334;
    }
    bool _353;
    if (!_343)
    {
        _353 = coords.y < (-coords.w);
    }
    else
    {
        _353 = _343;
    }
    bool _362;
    if (!_353)
    {
        _362 = coords.y > coords.w;
    }
    else
    {
        _362 = _353;
    }
    bool _369;
    if (!_362)
    {
        _369 = coords.z < 0.0;
    }
    else
    {
        _369 = _362;
    }
    if (_369)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _373 = coords;
    float _379 = coords.w;
    vec2 _381 = (_373.xy * vec2(0.5)) + (vec2(0.5) * _379);
    coords.x = _381.x;
    coords.y = _381.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    float sampling_r = 1.0;
    float _412 = -sampling_r;
    float y = _412;
    int iy = 0;
    for (;;)
    {
        if (iy < samples)
        {
            float _424 = -sampling_r;
            float x = _424;
            int ix = 0;
            for (;;)
            {
                if (ix < samples)
                {
                    vec4 _450 = coords + vec4((x * sampling_range) * coords.w, (y * sampling_range) * coords.w, 0.0, 0.0);
                    vec4 _453 = _450;
                    _453.z = _450.w;
                    float shadow = textureProjLod(smpl, vec4(_453.xy, _450.z, _453.z), 0.0);
                    fact += shadow;
                    ix++;
                    x += ((2.0 * sampling_r) / float(samples - 1));
                    continue;
                }
                else
                {
                    break;
                }
            }
            iy++;
            y += ((2.0 * sampling_r) / float(samples - 1));
            continue;
        }
        else
        {
            break;
        }
    }
    float f = fact * (1.0 / float(samples * samples));
    return f;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    float attenuation = 0.0;
    bool _516 = falloff > cutoff;
    bool _523;
    if (_516)
    {
        _523 = light_distance < light.range;
    }
    else
    {
        _523 = _516;
    }
    if (_523)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

void InitRect(LightProperties light, inout LTCRect rect)
{
    rect.dirx = -light.right;
    rect.diry = light.up;
    rect.center = light.position;
    rect.halfx = 0.5 * light.dimensions.x;
    rect.halfy = 0.5 * light.dimensions.y;
    vec3 rectNormal = cross(rect.dirx, rect.diry);
    rect.plane = vec4(rectNormal, -dot(rectNormal, rect.center));
}

void InitRectPoints(LTCRect rect, inout vec3 points[4])
{
    vec3 ex = rect.dirx * rect.halfx;
    vec3 ey = rect.diry * rect.halfy;
    points[0] = (rect.center - ex) - ey;
    points[1] = (rect.center + ex) - ey;
    points[2] = (rect.center + ex) + ey;
    points[3] = (rect.center - ex) + ey;
}

mat3 mul(mat3 m1, mat3 m2)
{
    return m1 * m2;
}

vec3 mul(mat3 m, vec3 v)
{
    return m * v;
}

vec3 IntegrateEdgeVec(vec3 v1, vec3 v2)
{
    float x = dot(v1, v2);
    float y = abs(x);
    float a = 0.8543984889984130859375 + ((0.4965155124664306640625 + (0.01452060043811798095703125 * y)) * y);
    float b = 3.41759395599365234375 + ((4.1616725921630859375 + y) * y);
    float v = a / b;
    float _1267;
    if (x > 0.0)
    {
        _1267 = v;
    }
    else
    {
        _1267 = (0.5 * inversesqrt(max(1.0 - (x * x), 1.0000000116860974230803549289703e-07))) - v;
    }
    float theta_sintheta = _1267;
    return cross(v1, v2) * theta_sintheta;
}

void ClipQuadToHorizon(inout vec3 L[5], inout int n)
{
    int config = 0;
    if (L[0].z > 0.0)
    {
        config++;
    }
    if (L[1].z > 0.0)
    {
        config += 2;
    }
    if (L[2].z > 0.0)
    {
        config += 4;
    }
    if (L[3].z > 0.0)
    {
        config += 8;
    }
    n = 0;
    if (config == 0)
    {
    }
    else
    {
        if (config == 1)
        {
            n = 3;
            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
            L[2] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
        }
        else
        {
            if (config == 2)
            {
                n = 3;
                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
            }
            else
            {
                if (config == 3)
                {
                    n = 4;
                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                    L[3] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                }
                else
                {
                    if (config == 4)
                    {
                        n = 3;
                        L[0] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                    }
                    else
                    {
                        if (config == 5)
                        {
                            n = 0;
                        }
                        else
                        {
                            if (config == 6)
                            {
                                n = 4;
                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                            }
                            else
                            {
                                if (config == 7)
                                {
                                    n = 5;
                                    L[4] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                                    L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                                }
                                else
                                {
                                    if (config == 8)
                                    {
                                        n = 3;
                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                        L[1] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        L[2] = L[3];
                                    }
                                    else
                                    {
                                        if (config == 9)
                                        {
                                            n = 4;
                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                            L[2] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        }
                                        else
                                        {
                                            if (config == 10)
                                            {
                                                n = 0;
                                            }
                                            else
                                            {
                                                if (config == 11)
                                                {
                                                    n = 5;
                                                    L[4] = L[3];
                                                    L[3] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                                                }
                                                else
                                                {
                                                    if (config == 12)
                                                    {
                                                        n = 4;
                                                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                    }
                                                    else
                                                    {
                                                        if (config == 13)
                                                        {
                                                            n = 5;
                                                            L[4] = L[3];
                                                            L[3] = L[2];
                                                            L[2] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                                        }
                                                        else
                                                        {
                                                            if (config == 14)
                                                            {
                                                                n = 5;
                                                                L[4] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                                            }
                                                            else
                                                            {
                                                                if (config == 15)
                                                                {
                                                                    n = 4;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (n == 3)
    {
        L[3] = L[0];
    }
    if (n == 4)
    {
        L[4] = L[0];
    }
}

float IntegrateEdge(vec3 v1, vec3 v2)
{
    vec3 param = v1;
    vec3 param_1 = v2;
    return IntegrateEdgeVec(param, param_1).z;
}

vec3 LTC_Evaluate_DiffuseOnly(vec3 N, vec3 P, inout mat3 Minv, vec3 points[4], bool twoSided_1)
{
    vec3 V = vec3(0.0, 0.0, 1.0);
    vec3 T1 = normalize(V - (N * dot(V, N)));
    vec3 T2 = cross(N, T1);
    mat3 param = Minv;
    mat3 param_1 = transpose(mat3(vec3(T1), vec3(T2), vec3(N)));
    Minv = mul(param, param_1);
    mat3 param_2 = Minv;
    vec3 param_3 = points[0] - P;
    vec3 L[5];
    L[0] = mul(param_2, param_3);
    mat3 param_4 = Minv;
    vec3 param_5 = points[1] - P;
    L[1] = mul(param_4, param_5);
    mat3 param_6 = Minv;
    vec3 param_7 = points[2] - P;
    L[2] = mul(param_6, param_7);
    mat3 param_8 = Minv;
    vec3 param_9 = points[3] - P;
    L[3] = mul(param_8, param_9);
    float sum = 0.0;
    if (clipless)
    {
        vec3 dir = points[0] - P;
        vec3 lightNormal = cross(points[1] - points[0], points[3] - points[0]);
        bool behind = dot(dir, lightNormal) < 0.0;
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        vec3 vsum = vec3(0.0);
        vec3 param_10 = L[0];
        vec3 param_11 = L[1];
        vsum += IntegrateEdgeVec(param_10, param_11);
        vec3 param_12 = L[1];
        vec3 param_13 = L[2];
        vsum += IntegrateEdgeVec(param_12, param_13);
        vec3 param_14 = L[2];
        vec3 param_15 = L[3];
        vsum += IntegrateEdgeVec(param_14, param_15);
        vec3 param_16 = L[3];
        vec3 param_17 = L[0];
        vsum += IntegrateEdgeVec(param_16, param_17);
        float len = length(vsum);
        float z = vsum.z / len;
        if (behind)
        {
            z = -z;
        }
        vec2 uv = vec2((z * 0.5) + 0.5, len);
        uv = (uv * 0.984375) + vec2(0.0078125);
        float scale = texture(s_LTC2, uv).w;
        sum = len * scale;
        if (behind && (!twoSided_1))
        {
            sum = 0.0;
        }
    }
    else
    {
        vec3 param_18[5] = L;
        int param_19;
        ClipQuadToHorizon(param_18, param_19);
        L = param_18;
        int n = param_19;
        if (n == 0)
        {
            return vec3(0.0);
        }
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        L[4] = normalize(L[4]);
        vec3 param_20 = L[0];
        vec3 param_21 = L[1];
        sum += IntegrateEdge(param_20, param_21);
        vec3 param_22 = L[1];
        vec3 param_23 = L[2];
        sum += IntegrateEdge(param_22, param_23);
        vec3 param_24 = L[2];
        vec3 param_25 = L[3];
        sum += IntegrateEdge(param_24, param_25);
        if (n >= 4)
        {
            vec3 param_26 = L[3];
            vec3 param_27 = L[4];
            sum += IntegrateEdge(param_26, param_27);
        }
        if (n == 5)
        {
            vec3 param_28 = L[4];
            vec3 param_29 = L[0];
            sum += IntegrateEdge(param_28, param_29);
        }
        float _2038;
        if (twoSided_1)
        {
            _2038 = abs(sum);
        }
        else
        {
            _2038 = max(0.0, sum);
        }
        sum = _2038;
    }
    vec3 Lo_i = vec3(sum, sum, sum);
    return Lo_i;
}

float light_calculate_area_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0 - clamp(light_distance / light.range, 0.0, 1.0);
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

void rt_store_voxel_color(uint cx, uint cy, uint cz, inout vec4 v)
{
    uint param = cx;
    uint param_1 = cy;
    uint param_2 = cz;
    uint idx = rt_calculate_grid_cell_idx(param, param_1, param_2);
    float v_mag = ceil(length(v.xyz));
    vec4 _240 = v;
    vec3 _244 = _240.xyz / vec3(v_mag);
    v.x = _244.x;
    v.y = _244.y;
    v.z = _244.z;
    v_mag = min(127.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    vi |= 2147483648u;
    uint _291 = atomicCompSwap(_287.in_voxel_light_data[idx], 0u, vi);
    uint prev_vi = _291;
    if (prev_vi != 0u)
    {
        uint _299 = atomicMin(_287.in_voxel_light_data[idx], vi);
    }
}

void main()
{
    twoSided = false;
    clipless = false;
    vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;
    uint param = vTriIndex[0];
    vec3 vTriCoords[3];
    vTriCoords[0] = rt_get_vertex(param);
    uint param_1 = vTriIndex[1];
    vTriCoords[1] = rt_get_vertex(param_1);
    uint param_2 = vTriIndex[2];
    vTriCoords[2] = rt_get_vertex(param_2);
    vec3 s = -bbox_origin;
    vTriCoords[0] += s;
    vTriCoords[1] += s;
    vTriCoords[2] += s;
    vec3 f = vec3(1.0) / bbox_grid_size;
    vTriCoords[0] *= f;
    vTriCoords[1] *= f;
    vTriCoords[2] *= f;
    vec3 pos = vGridCoords;
    vec3 gc = (gl_FragCoord.xyz / vec3(1.0, 1.0, 0.00390625)) + vec3(0.0);
    gc.y = 255.5 - gc.y;
    gc.z = (gc.z * 0.5) + 128.0;
    ivec3 mi = ivec3(floor(min(vTriCoords[0], min(vTriCoords[1], vTriCoords[2]))));
    ivec3 ma = ivec3(ceil(max(vTriCoords[0], max(vTriCoords[1], vTriCoords[2]))));
    mi = clamp(mi, ivec3(0), ivec3(255));
    ma = clamp(ma, ivec3(0), ivec3(255));
    uint stepDir = 0u;
    uvec3 stepStart = uvec3(0u);
    uint cy;
    uint cz;
    uint cx;
    int steps;
    if (vOrientationIndex == 0)
    {
        cy = uint(gc.x);
        cz = uint(gc.y);
        cx = uint(gc.z);
        stepStart = uvec3(uint(mi.x), cy, cz);
        steps = ma.x - mi.x;
    }
    else
    {
        if (vOrientationIndex == 1)
        {
            cz = uint(gc.x);
            cx = uint(gc.y);
            cy = uint(gc.z);
            stepStart = uvec3(cx, uint(mi.y), cz);
            steps = ma.y - mi.y;
        }
        else
        {
            cx = uint(gc.x);
            cy = uint(gc.y);
            cz = uint(gc.z);
            stepStart = uvec3(cx, cy, uint(mi.z));
            steps = ma.z - mi.z;
        }
    }
    stepDir = build_step_dir();
    int stepMin = -1;
    int stepCount = 0;
    int s_1 = 0;
    for (;;)
    {
        if (s_1 < steps)
        {
            uint param_3 = stepDir;
            uvec3 cc = stepStart + uvec3(unpack_step_dir(param_3) * ivec3(s_1));
            vec3 cellPos = vec3(cc);
            vec3 cellSize = vec3(1.0);
            vec3 param_4 = vTriCoords[0];
            vec3 param_5 = vTriCoords[1];
            vec3 param_6 = vTriCoords[2];
            vec3 param_7 = vTriNormal;
            vec3 param_8 = cellPos + (cellSize * 0.5);
            vec3 param_9 = cellSize * 0.5;
            if (checkTriCellOverlap(param_4, param_5, param_6, param_7, param_8, param_9))
            {
                if (stepMin == (-1))
                {
                    stepMin = s_1;
                }
                uint ccx = cc.x;
                uint ccy = cc.y;
                uint ccz = cc.z;
                float d = -dot(vTriNormal, vTriCoords[0]);
                float _distance = dot(vTriNormal, cellPos + (cellSize * 0.5)) + d;
                uint param_10 = ccx;
                uint param_11 = ccy;
                uint param_12 = ccz;
                float param_13 = 1.0 - clamp(0.5 + _distance, 0.0, 1.0);
                rt_store_voxel_occlusion(param_10, param_11, param_12, param_13);
                if (vOrientationIndex == 0)
                {
                    ccx = uint(clamp(float(int(ccx)) - sign(vTriNormal.x), 0.0, 255.0));
                }
                else
                {
                    if (vOrientationIndex == 1)
                    {
                        ccy = uint(clamp(float(int(ccy)) - sign(vTriNormal.y), 0.0, 255.0));
                    }
                    else
                    {
                        if (vOrientationIndex == 2)
                        {
                            ccz = uint(clamp(float(int(ccz)) - sign(vTriNormal.z), 0.0, 255.0));
                        }
                    }
                }
                uint param_14 = ccx;
                uint param_15 = ccy;
                uint param_16 = ccz;
                float param_17 = 1.0;
                rt_store_voxel_occlusion(param_14, param_15, param_16, param_17);
                stepCount++;
            }
            s_1++;
            continue;
        }
        else
        {
            break;
        }
    }
    if (stepCount == 0)
    {
        return;
    }
    uint param_18 = stepDir;
    stepStart += uvec3(unpack_step_dir(param_18) * ivec3(stepMin));
    vec3 voxel_color = vec3(0.0);
    uint param_19 = uint(gl_PrimitiveID);
    int materialIndex = rt_get_triangle_material(param_19);
    MaterialPropertiesGPU _2562;
    _2562.diffuse = materials.material_properties[materialIndex].diffuse;
    _2562.transparency = materials.material_properties[materialIndex].transparency;
    _2562.emissive = materials.material_properties[materialIndex].emissive;
    _2562.roughness = materials.material_properties[materialIndex].roughness;
    _2562.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
    _2562.refraction = materials.material_properties[materialIndex].refraction;
    _2562.normal_factor = materials.material_properties[materialIndex].normal_factor;
    _2562.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
    _2562.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
    _2562.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
    _2562.metalness = materials.material_properties[materialIndex].metalness;
    _2562.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
    _2562.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
    _2562.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
    _2562.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
    _2562.flags = materials.material_properties[materialIndex].flags;
    _2562._pad0 = materials.material_properties[materialIndex]._pad0;
    _2562._pad1 = materials.material_properties[materialIndex]._pad1;
    MaterialPropertiesGPU material = _2562;
    float roughness = material.roughness;
    vec3 world = (vec3(stepStart) * in_bbox_data.grid_size_voxelize.xyz) + in_bbox_data.bbox_voxelize_min.xyz;
    vec3 pplane = (vTriCoords[0] * in_bbox_data.grid_size_voxelize.xyz) + in_bbox_data.bbox_voxelize_min.xyz;
    world = (world - (vTriNormal * dot(world - pplane, vTriNormal))) + (vTriNormal * 0.20000000298023223876953125);
    vec3 base_albedo = vColor.xyz;
    vec3 base_emissive = vec3(1.0);
    bool _2608 = material.albedo_sampler >= 0;
    bool _2614;
    if (_2608)
    {
        _2614 = material.albedo_sampler < 16;
    }
    else
    {
        _2614 = _2608;
    }
    if (_2614)
    {
        base_albedo *= textureLod(material_textures[material.albedo_sampler], vUV0, 2.0).xyz;
    }
    bool _2634 = material.emissive_sampler >= 0;
    bool _2640;
    if (_2634)
    {
        _2640 = material.emissive_sampler < 16;
    }
    else
    {
        _2640 = _2634;
    }
    if (_2640)
    {
        base_emissive = textureLod(material_textures[material.emissive_sampler], vUV0, 2.0).xyz;
    }
    float param_26;
    LTCRect param_32;
    vec3 param_34[4];
    int light_idx = 0;
    for (;;)
    {
        if (light_idx < _2660.dispatch_params.lights_num)
        {
            LightProperties _2678;
            _2678.diffuse = lights.light_properties[light_idx].diffuse;
            _2678.direction = lights.light_properties[light_idx].direction;
            _2678.position = lights.light_properties[light_idx].position;
            _2678.up = lights.light_properties[light_idx].up;
            _2678.right = lights.light_properties[light_idx].right;
            _2678.dimensions = lights.light_properties[light_idx].dimensions;
            _2678.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
            _2678.intensity = lights.light_properties[light_idx].intensity;
            _2678.range = lights.light_properties[light_idx].range;
            _2678.cutoff = lights.light_properties[light_idx].cutoff;
            _2678.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
            _2678.is_area = lights.light_properties[light_idx].is_area;
            _2678.type = lights.light_properties[light_idx].type;
            _2678.projector_sampler = lights.light_properties[light_idx].projector_sampler;
            _2678.projector_intensity = lights.light_properties[light_idx].projector_intensity;
            _2678.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
            _2678.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
            _2678.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
            _2678.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
            _2678.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
            _2678.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
            _2678.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
            _2678.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
            _2678.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
            _2678.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
            _2678.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
            _2678.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
            _2678.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
            _2678.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
            _2678.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
            _2678.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
            _2678.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
            _2678.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
            LightProperties light = _2678;
            if ((light.lighting_exclusion_tags & _2660.dispatch_params.component_tags) != 0u)
            {
                int _2901 = light_idx;
                light_idx = _2901 + 1;
                continue;
            }
            vec3 light_color = vec3(0.0);
            vec4 projector_color = vec4(0.0);
            vec3 pointToLight = light.position - world;
            if ((light.type & 1) != 0)
            {
                pointToLight = -light.direction;
            }
            float NdotL = dot(vTriNormalForLighting, normalize(pointToLight));
            LightProperties param_20 = light;
            vec3 param_21 = world;
            vec3 param_22 = vTriNormalForLighting;
            vec3 param_23 = light.position;
            float param_24 = NdotL;
            vec3 lighting = material.diffuse * calculate_lighting_world(param_20, param_21, param_22, param_23, param_24);
            float shadow = 0.0;
            if (NdotL <= 0.0)
            {
                shadow = 1.0;
            }
            else
            {
                bool _2738 = (material.flags & 512u) != 0u;
                bool _2745;
                if (_2738)
                {
                    _2745 = (light.type & 8) != 0;
                }
                else
                {
                    _2745 = _2738;
                }
                bool calculate_shadows = _2745;
                if (((light.type & 3) != 0) && calculate_shadows)
                {
                    float penumbra_scaling_factor = 0.5;
                    vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
                    float penumbraSampleNoise = 0.0;
                    float penumbra = 0.5;
                    float in_frustum = 0.0;
                    vec4 param_25 = vShadowCoords;
                    int param_27 = 3;
                    float param_28 = (((penumbra_scaling_factor * roughness) * penumbra) * light.roughness_modifier) / 1024.0;
                    float _2789 = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param_25, param_26, param_27, param_28);
                    in_frustum = param_26;
                    shadow = _2789;
                }
            }
            lighting = (lighting * light.diffuse.xyz) * light.intensity;
            light_color = vec3(vec3(1.0 - shadow)) * lighting;
            if ((light.type & 130) == 130)
            {
                LightProperties param_29 = light;
                vec3 param_30 = world;
                float attenuation = light_calculate_spot_attenuation(param_29, param_30);
                light_color *= attenuation;
            }
            if (light.is_area != 0)
            {
                LightProperties param_31 = light;
                InitRect(param_31, param_32);
                LTCRect rect = param_32;
                LTCRect param_33 = rect;
                InitRectPoints(param_33, param_34);
                vec3 points[4] = param_34;
                float ltc_roughness = roughness;
                float ltc_intensity = light.intensity;
                vec3 lcol = vec3(ltc_intensity);
                vec3 dcol = light.diffuse.xyz;
                vec3 col = vec3(0.0);
                vec3 pos_1 = world;
                vec3 N = vTriNormal;
                vec3 param_35 = N;
                vec3 param_36 = pos_1;
                mat3 param_37 = mat3(vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0));
                vec3 param_38[4] = points;
                bool param_39 = twoSided;
                vec3 _2871 = LTC_Evaluate_DiffuseOnly(param_35, param_36, param_37, param_38, param_39);
                vec3 diff = _2871;
                col = lcol * (dcol * diff);
                light_color = col;
                if ((light.type & 128) == 128)
                {
                    LightProperties param_40 = light;
                    vec3 param_41 = world;
                    float attenuation_1 = light_calculate_area_attenuation(param_40, param_41);
                    light_color *= attenuation_1;
                }
            }
            voxel_color += vec3(light_color);
            int _2901 = light_idx;
            light_idx = _2901 + 1;
            continue;
        }
        else
        {
            break;
        }
    }
    voxel_color *= base_albedo;
    voxel_color += ((material.emissive * base_emissive) * material.emissive_factor);
    for (;;)
    {
        int _2920 = stepCount;
        stepCount = _2920 - 1;
        if (_2920 > 0)
        {
            uint ccx_1 = stepStart.x;
            uint ccy_1 = stepStart.y;
            uint ccz_1 = stepStart.z;
            uint param_42 = ccx_1;
            uint param_43 = ccy_1;
            uint param_44 = ccz_1;
            vec4 param_45 = vec4(voxel_color, 1.0);
            rt_store_voxel_color(param_42, param_43, param_44, param_45);
            if (vOrientationIndex == 0)
            {
                ccx_1 -= uint(int(sign(vTriNormal.x)));
            }
            else
            {
                if (vOrientationIndex == 1)
                {
                    ccy_1 -= uint(int(sign(vTriNormal.y)));
                }
                else
                {
                    if (vOrientationIndex == 2)
                    {
                        ccz_1 -= uint(int(sign(vTriNormal.z)));
                    }
                }
            }
            ccx_1 = clamp(ccx_1, 0u, 255u);
            ccy_1 = clamp(ccy_1, 0u, 255u);
            ccz_1 = clamp(ccz_1, 0u, 255u);
            uint param_46 = stepDir;
            stepStart += uvec3(unpack_step_dir(param_46));
            steps--;
            continue;
        }
        else
        {
            break;
        }
    }
}

 