#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _27;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    vec2 tc = vTexcoord0;
    float t = tc.x + ((tc.y * _27.params.param1) * 0.100000001490116119384765625);
    t *= _27.params.param2;
    t = fract(t);
    t = step(t, 0.5);
    vec3 _56 = vec3(t) * vec3(0.300000011920928955078125);
    outColor.x = _56.x;
    outColor.y = _56.y;
    outColor.z = _56.z;
}

 