#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ColorMixerParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec4 r_input;
    vec4 g_input;
    vec4 b_input;
    float hue_shift;
};

layout(set = 1, binding = 1, std140) uniform ColorMixerParamsBuffer
{
    ColorMixerParams params;
} _180;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

float luminance(vec3 x)
{
    return max(0.0, dot(x, vec3(0.21269999444484710693359375, 0.715200006961822509765625, 0.072200000286102294921875)));
}

vec3 rgb2hsv(vec3 c)
{
    vec4 K = vec4(0.0, -0.3333333432674407958984375, 0.666666686534881591796875, -1.0);
    vec4 p = mix(vec4(c.zy, K.wz), vec4(c.yz, K.xy), vec4(step(c.z, c.y)));
    vec4 q = mix(vec4(p.xyw, c.x), vec4(c.x, p.yzx), vec4(step(p.x, c.x)));
    float d = q.x - min(q.w, q.y);
    float e = 1.0000000133514319600180897396058e-10;
    return vec3(abs(q.z + ((q.w - q.y) / ((6.0 * d) + e))), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 0.666666686534881591796875, 0.3333333432674407958984375, 3.0);
    vec3 p = abs((fract(c.xxx + K.xyz) * 6.0) - K.www);
    return mix(K.xxx, clamp(p - K.xxx, vec3(0.0), vec3(1.0)), vec3(c.y)) * c.z;
}

void main()
{
    vec4 base_color = max(vec4(0.0), texelFetch(s_texture0, ivec2(vTexcoord0 * _180.params.resolution), 0));
    vec3 color;
    color.x = dot(base_color.xyz, _180.params.r_input.xyz);
    color.y = dot(base_color.xyz, _180.params.g_input.xyz);
    color.z = dot(base_color.xyz, _180.params.b_input.xyz);
    if (_180.params.hue_shift != 0.0)
    {
        vec3 param = color;
        float l = luminance(param);
        if (l > 0.0)
        {
            vec3 color_01 = color / vec3(1.0 + l);
            vec3 param_1 = color_01;
            vec3 hsv = rgb2hsv(param_1);
            hsv.x += _180.params.hue_shift;
            if (hsv.x < 0.0)
            {
                hsv.x += 1.0;
            }
            if (hsv.x > 1.0)
            {
                hsv.x -= 1.0;
            }
            vec3 param_2 = hsv;
            color_01 = hsv2rgb(param_2);
            vec3 param_3 = color_01;
            color = color_01 / vec3(max(9.9999997473787516355514526367188e-05, 1.0 - luminance(param_3)));
        }
    }
    base_color.x = color.x;
    base_color.y = color.y;
    base_color.z = color.z;
    outColor = base_color;
}

 