#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _30;

layout(set = 0, binding = 3, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _40;

layout(set = 0, binding = 2, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _60;

layout(set = 0, binding = 4, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _116;

void main()
{
    if (gl_GlobalInvocationID.x != 0u)
    {
        return;
    }
    uint faces_per_instance = _30.geometry_information.faces_num_per_surface[_40.transform_geometry_params.surface_idx];
    uint points_per_instance = _30.geometry_information.vtx_num;
    uint prim_idx = _40.transform_geometry_params.instance_idx;
    _60.transformed_data_location[prim_idx].surface_idx = _40.transform_geometry_params.surface_idx;
    _60.transformed_data_location[prim_idx].material_idx = _40.transform_geometry_params.material_idx;
    _60.transformed_data_location[prim_idx].raytrace = _40.transform_geometry_params.raytrace;
    _60.transformed_data_location[prim_idx].voxelize = _40.transform_geometry_params.voxelize;
    if (_40.transform_geometry_params.initialize_bbox != 0u)
    {
        _60.transformed_data_location[prim_idx].bbox_min = ivec4(1073741824, 1073741824, 1073741824, 0);
        _60.transformed_data_location[prim_idx].bbox_max = ivec4(-1073741824, -1073741824, -1073741824, 0);
    }
    if (_40.transform_geometry_params.surface_idx > 0u)
    {
        _60.transformed_data_location[prim_idx].last_vtx_idx = _60.transformed_data_location[prim_idx - 1u].last_vtx_idx;
    }
    if (prim_idx == 0u)
    {
        if (_116.instance_params.instance_count > 0)
        {
            _60.transformed_data_location[prim_idx].last_face_idx = (uint(_116.instance_params.instance_count) * faces_per_instance) - 1u;
        }
        else
        {
            _60.transformed_data_location[prim_idx].last_face_idx = 0u;
            _60.transformed_data_location[prim_idx].last_vtx_idx = 0u;
        }
    }
    else
    {
        if (_116.instance_params.instance_count > 0)
        {
            _60.transformed_data_location[prim_idx].last_face_idx = ((_60.transformed_data_location[prim_idx - 1u].last_face_idx + 1u) + (uint(_116.instance_params.instance_count) * faces_per_instance)) - 1u;
        }
        else
        {
            _60.transformed_data_location[prim_idx].last_face_idx = _60.transformed_data_location[prim_idx - 1u].last_face_idx;
            _60.transformed_data_location[prim_idx].last_vtx_idx = _60.transformed_data_location[prim_idx - 1u].last_vtx_idx;
        }
    }
}

 