#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryRebuildNormalsParams
{
    uint surfaces_num;
    uint surface_idx;
    uint _pad0;
    uint _pad1;
};

layout(set = 0, binding = 1, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _25;

layout(set = 0, binding = 2, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 4, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _73;

layout(set = 0, binding = 3, std430) buffer AccumulationBuffer
{
    uint values[];
} accumulation_buffer;

void put_normal(inout uint idx, vec3 v)
{
    idx *= _25.output_geometry_information.attributes[1].stride;
    idx += _25.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint src_vtx_num = _73.input_geometry_information.vtx_num;
    vec3 n;
    uint src_vtx_idx = thread_idx;
    for (;;)
    {
        if (src_vtx_idx < src_vtx_num)
        {
            uint v0 = accumulation_buffer.values[(src_vtx_idx * 2u) + 0u];
            uint v1 = accumulation_buffer.values[(src_vtx_idx * 2u) + 1u];
            uint cnt = v0 >> uint(16);
            uint nx = v0 & 65535u;
            uint ny = v1 >> uint(16);
            uint nz = v1 & 65535u;
            n.x = (float(nx) / float(cnt * 4096u)) - 1.0;
            n.y = (float(ny) / float(cnt * 4096u)) - 1.0;
            n.z = (float(nz) / float(cnt * 4096u)) - 1.0;
            if ((_25.output_geometry_information.builtin_attribute_mask & 2u) == 0u)
            {
            }
            uint param = src_vtx_idx;
            vec3 param_1 = n;
            put_normal(param, param_1);
            src_vtx_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
}

 