#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _38;

layout(set = 0, binding = 2, std430) buffer GPUOnlyMemoryAllocatorInfoBuffer
{
    uint offset;
    uint num_allocations;
    uint _pad0;
    uint _pad1;
} gpu_allocator_data;

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint allocation_size = 0u;
    uint faces_num = 0u;
    int i = 0;
    for (;;)
    {
        if (uint(i) < _38.geometry_information.surfaces_num)
        {
            faces_num += _38.geometry_information.faces_num_per_surface[i];
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    uint _64 = atomicAdd(gpu_allocator_data.offset, (faces_num * 3u) * 4u);
    uint idx_buffer_offset = _64;
    _38.geometry_information.idx_buffer_offset = idx_buffer_offset / 4u;
    allocation_size += ((faces_num * 3u) * 4u);
    int i_1 = 0;
    for (;;)
    {
        if (uint(i_1) < 8u)
        {
            if (_38.geometry_information.attributes[i_1].stride > 0u)
            {
                uint _99 = atomicAdd(gpu_allocator_data.offset, (_38.geometry_information.vtx_num * _38.geometry_information.attributes[i_1].stride) * 4u);
                uint attribute_buffer_offset = _99;
                _38.geometry_information.attributes[i_1].offset = attribute_buffer_offset / 4u;
                allocation_size += ((_38.geometry_information.vtx_num * _38.geometry_information.attributes[i_1].stride) * 4u);
            }
            i_1++;
            continue;
        }
        else
        {
            break;
        }
    }
    _38.geometry_information.vtx_num = 0u;
    int i_2 = 0;
    for (;;)
    {
        if (uint(i_2) < _38.geometry_information.surfaces_num)
        {
            _38.geometry_information.faces_num_per_surface[i_2] = 0u;
            i_2++;
            continue;
        }
        else
        {
            break;
        }
    }
    _38.geometry_information.gpu_memory_allocation_size = allocation_size;
    _38.geometry_information.gpu_memory_allocation_size_total = gpu_allocator_data.offset;
    _38.geometry_information.is_gpu_allocated = 1u;
    uint _141 = atomicAdd(gpu_allocator_data.num_allocations, 1u);
}

 