#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

const uvec2 _1266[4] = uvec2[](uvec2(0u), uvec2(0u, 1u), uvec2(1u, 0u), uvec2(1u));

struct VXParams
{
    float average_position_factor;
    float average_normals_factor;
    float average_colors_factor;
    float light_falloff_factor;
    float occlusion_falloff_factor;
    float light_trace_distance_scale;
    float trace_range;
    float reprojection_tolerance;
    int filter_step;
    int compute_diffuse;
    int compute_specular;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _565;

layout(set = 0, binding = 3, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _736;

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 4, std140) uniform VoxelLightingParams
{
    VXParams voxel_lighting_setup;
} _1376;

layout(set = 0, binding = 5, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 11) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 6, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 7, rgba16f) uniform writeonly image2D imTargetLighting;
layout(set = 0, binding = 8, rgba16f) uniform writeonly image2D imTargetOcclusion;
layout(set = 0, binding = 9, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 12) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 13) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 14) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 0, binding = 10, rgba8) uniform image2D imDebug;
layout(set = 0, binding = 15) uniform sampler2D sTextureDepthPrevious;
layout(set = 0, binding = 16) uniform sampler2D sTargetLightingPrevious;

int decode_material(uint data)
{
    return int(data >> 31u);
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((ddp.frustum_shift * ddp.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-ddp.camera_projection_params.z) + ((ddp.camera_projection_params.x * vd_pos.x) * ddp.inv_resolution.x);
    view_direction.y = (-ddp.camera_projection_params.w) + ((ddp.camera_projection_params.y * vd_pos.y) * ddp.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _466;
    if (nor.x > 0.0)
    {
        _466 = -t;
    }
    else
    {
        _466 = t;
    }
    nor.x += _466;
    float _481;
    if (nor.y > 0.0)
    {
        _481 = -t;
    }
    else
    {
        _481 = t;
    }
    nor.y += _481;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

float linearizeDepth(float d)
{
    return _565.dispatch_setup.near_far_plane.z / ((_565.dispatch_setup.near_far_plane.y + _565.dispatch_setup.near_far_plane.x) - (d * _565.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_565.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

vec4 rt_cone_trace_sample_cubemap(sampler3D smp, int texture_size, vec3 p, float mip)
{
    return textureLod(smp, p, mip);
}

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _532 = v;
    float _535 = v.w;
    vec3 _538 = (_532.xyz * _535) * 128.0;
    v.x = _538.x;
    v.y = _538.y;
    v.z = _538.z;
    return v.xyz * v.xyz;
}

vec4 rt_cone_trace_occlusion(ivec2 screen_pos, sampler3D voxel_color_texture, sampler3D voxel_occupancy_texture, vec3 grid_size, int grid_res, vec3 grid_origin, vec3 origin, vec3 surface_normal, vec3 dir, float range, float lightTraceDistanceScale, float roughness, int rays, float color_falloff, float occlusion_falloff, float trace_range)
{
    if (range <= 0.0)
    {
        return vec4(0.0);
    }
    float occ = 0.0;
    vec3 occ_color = vec3(0.0);
    int si = 0;
    for (;;)
    {
        if (si < rays)
        {
            vec3 c_color = vec3(0.0);
            float c_occlusion = 0.0;
            int frame = _736.globals.monotonic;
            vec2 _noise = texelFetch(s_BlueNoise, ivec3(screen_pos, frame & 15), 0).xy;
            _noise = fract(_noise + vec2(float(si) * 1.61803400516510009765625));
            vec2 hash = _noise;
            vec3 param = dir;
            mat3 _771 = matrixFromVector(param);
            mat3 vecSpace = _771;
            float param_1 = hash.x * roughness;
            float param_2 = hash.y;
            vec3 V = CosineSampleHemisphere(param_1, param_2);
            V = vecSpace * V;
            float VdotN = dot(V, surface_normal);
            if ((VdotN < 0.0) && true)
            {
                hash = fract(_noise + vec2(float(frame + 10) * 1.61803400516510009765625));
                float param_3 = hash.x * roughness;
                float param_4 = hash.y;
                V = CosineSampleHemisphere(param_3, param_4);
                V = vecSpace * V;
                VdotN = dot(V, surface_normal);
                if (VdotN < 0.0)
                {
                    return vec4(0.0);
                }
            }
            vec3 p = origin;
            float prestep_distance = 3.0;
            p += ((surface_normal * range) * prestep_distance);
            float base_V = hash.x;
            float l = base_V * range;
            float max_l = 0.0;
            float coneAperture = tan(((roughness * 3.1415927410125732421875) * 0.5) * 0.100000001490116119384765625);
            float range_rcp = 1.0 / range;
            int steps = 0;
            bool is_inside = false;
            int iter = 0;
            bool loop = true;
            for (;;)
            {
                if (loop)
                {
                    float diameter = max(range, (2.0 * coneAperture) * l);
                    float mip = min(3.5, log2(diameter * range_rcp));
                    vec3 grid_p = ((p + (V * l)) - grid_origin) / grid_size;
                    vec3 sample_p = (grid_p + vec3(0.5)) / vec3(float(grid_res));
                    if (is_inside == false)
                    {
                        bool _904 = all(greaterThanEqual(sample_p, vec3(0.0)));
                        bool _911;
                        if (_904)
                        {
                            _911 = all(lessThan(sample_p, vec3(1.0)));
                        }
                        else
                        {
                            _911 = _904;
                        }
                        if (_911)
                        {
                            is_inside = true;
                        }
                    }
                    else
                    {
                        bool _917 = any(lessThan(sample_p, vec3(0.0)));
                        bool _924;
                        if (!_917)
                        {
                            _924 = any(greaterThanEqual(sample_p, vec3(1.0)));
                        }
                        else
                        {
                            _924 = _917;
                        }
                        if (_924)
                        {
                            is_inside = false;
                            loop = false;
                            iter++;
                        }
                    }
                    float mip_coarse = min(3.5, mip + 1.0);
                    int param_5 = 256;
                    vec3 param_6 = sample_p;
                    float param_7 = mip_coarse;
                    vec4 gc = vec4(rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_5, param_6, param_7).xxxx);
                    if (gc.w > 0.0040000001899898052215576171875)
                    {
                        int param_8 = 256;
                        vec3 param_9 = sample_p;
                        float param_10 = mip;
                        gc.w = rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_8, param_9, param_10).x;
                        int param_11 = 256;
                        vec3 param_12 = sample_p;
                        float param_13 = mip;
                        vec4 param_14 = rt_cone_trace_sample_cubemap(voxel_color_texture, param_11, param_12, param_13);
                        vec3 _969 = color_convert_rgbm_rgb(param_14);
                        vec3 _973 = vec3(_969);
                        gc.x = _973.x;
                        gc.y = _973.y;
                        gc.z = _973.z;
                    }
                    if (gc.w > 0.75)
                    {
                        gc.w = 1.0;
                    }
                    float blend = 1.0 - c_occlusion;
                    c_occlusion = min(1.0, c_occlusion + gc.w);
                    c_color += (gc.xyz * blend);
                    l += (diameter * lightTraceDistanceScale);
                    if (l >= trace_range)
                    {
                        loop = false;
                    }
                    if (c_occlusion >= 0.99500000476837158203125)
                    {
                        loop = false;
                    }
                    if (mip >= 1.5)
                    {
                        break;
                    }
                    continue;
                }
                else
                {
                    break;
                }
            }
            for (;;)
            {
                if (loop)
                {
                    float diameter_1 = max(range, (2.0 * coneAperture) * l);
                    float mip_1 = min(3.5, log2(diameter_1 * range_rcp));
                    vec3 grid_p_1 = ((p + (V * l)) - grid_origin) / grid_size;
                    vec3 sample_p_1 = (grid_p_1 + vec3(0.5)) / vec3(float(grid_res));
                    if (is_inside == false)
                    {
                        bool _1064 = all(greaterThanEqual(sample_p_1, vec3(0.0)));
                        bool _1070;
                        if (_1064)
                        {
                            _1070 = all(lessThan(sample_p_1, vec3(1.0)));
                        }
                        else
                        {
                            _1070 = _1064;
                        }
                        if (_1070)
                        {
                            is_inside = true;
                        }
                    }
                    else
                    {
                        bool _1076 = any(lessThan(sample_p_1, vec3(0.0)));
                        bool _1083;
                        if (!_1076)
                        {
                            _1083 = any(greaterThanEqual(sample_p_1, vec3(1.0)));
                        }
                        else
                        {
                            _1083 = _1076;
                        }
                        if (_1083)
                        {
                            is_inside = false;
                            loop = false;
                            iter++;
                        }
                    }
                    if (is_inside)
                    {
                        vec4 gc_1 = vec4(0.0);
                        int param_15 = 256;
                        vec3 param_16 = sample_p_1;
                        float param_17 = mip_1;
                        gc_1.w = rt_cone_trace_sample_cubemap(voxel_occupancy_texture, param_15, param_16, param_17).x;
                        if (gc_1.w > 0.0040000001899898052215576171875)
                        {
                            int param_18 = 256;
                            vec3 param_19 = sample_p_1;
                            float param_20 = mip_1;
                            vec4 param_21 = rt_cone_trace_sample_cubemap(voxel_color_texture, param_18, param_19, param_20);
                            vec3 _1112 = color_convert_rgbm_rgb(param_21);
                            vec3 _1116 = vec3(_1112);
                            gc_1.x = _1116.x;
                            gc_1.y = _1116.y;
                            gc_1.z = _1116.z;
                        }
                        if (gc_1.w > 0.75)
                        {
                            gc_1.w = 1.0;
                        }
                        float blend_1 = 1.0 - c_occlusion;
                        c_occlusion = min(1.0, c_occlusion + gc_1.w);
                        c_color += (gc_1.xyz * blend_1);
                    }
                    l += (diameter_1 * lightTraceDistanceScale);
                    if (l >= trace_range)
                    {
                        loop = false;
                    }
                    if (c_occlusion >= 0.99500000476837158203125)
                    {
                        loop = false;
                    }
                    continue;
                }
                else
                {
                    break;
                }
            }
            c_occlusion = min(1.0, c_occlusion);
            float power = 0.75;
            occ += (c_occlusion / pow(l * occlusion_falloff, power));
            occ_color += (c_color * dot(V, dir));
            si++;
            continue;
        }
        else
        {
            break;
        }
    }
    occ /= float(rays);
    occ_color /= vec3(float(rays));
    if (occ > 1.0)
    {
        occ = 1.0;
    }
    return vec4(occ_color, occ);
}

float sample_previous_depth_max(sampler2D s, vec2 p, float ref_d)
{
    float d = texelFetch(s, ivec2((p * _565.dispatch_setup.resolution) + vec2(0.5)), 0).x;
    vec4 d4 = textureGather(s, p);
    float param = d;
    return linearizeDepth(param);
}

vec3 positionFromDepthPrevious(vec3 vDirection, float depth)
{
    return (_565.dispatch_setup.mat_model_previous * vec4(vDirection * depth, 1.0)).xyz;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 SampleTextureCatmullRom(sampler2D tex, vec2 uv, vec2 texSize)
{
    vec2 samplePos = uv * texSize;
    vec2 texPos1 = floor(samplePos - vec2(0.5)) + vec2(0.5);
    vec2 f = samplePos - texPos1;
    vec2 w0 = f * (vec2(-0.5) + (f * (vec2(1.0) - (f * 0.5))));
    vec2 w1 = vec2(1.0) + ((f * f) * (vec2(-2.5) + (f * 1.5)));
    vec2 w2 = f * (vec2(0.5) + (f * (vec2(2.0) - (f * 1.5))));
    vec2 w3 = (f * f) * (vec2(-0.5) + (f * 0.5));
    vec2 w12 = w1 + w2;
    vec2 offset12 = w2 / (w1 + w2);
    vec2 texPos0 = texPos1 - vec2(1.0);
    vec2 texPos3 = texPos1 + vec2(2.0);
    vec2 texPos12 = texPos1 + offset12;
    texPos0 /= texSize;
    texPos3 /= texSize;
    texPos12 /= texSize;
    vec4 result = vec4(0.0);
    result += ((textureLod(tex, vec2(texPos0.x, texPos0.y), 0.0) * w0.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos0.y), 0.0) * w12.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos0.y), 0.0) * w3.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos0.x, texPos12.y), 0.0) * w0.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos12.y), 0.0) * w12.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos12.y), 0.0) * w3.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos0.x, texPos3.y), 0.0) * w0.x) * w3.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos3.y), 0.0) * w12.x) * w3.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos3.y), 0.0) * w3.x) * w3.y);
    return result;
}

void main()
{
    float range = min(in_bbox_data.grid_size_voxelize.x, min(in_bbox_data.grid_size_voxelize.y, in_bbox_data.grid_size_voxelize.z));
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    float param_2;
    float param_3;
    uint param_4;
    vec3 view_direction_prev;
    int i = 0;
    for (;;)
    {
        if (i < 1)
        {
            ivec2 pos = ivec2((pixel_pos * uvec2(1u)) + _1266[i]);
            ivec2 noise_pos = pos & ivec2(127);
            uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
            uint param = encoded_normal_material;
            int materialId = decode_material(param);
            if ((materialId & 1) == 1)
            {
                imageStore(imTargetLighting, pos, vec4(1.0));
                imageStore(imTargetOcclusion, pos, vec4(1.0));
            }
            else
            {
                uvec2 param_1 = imageLoad(imMetalnessRoughnessMaterialTags, pos).xy;
                decode_metalness_roughness_material(param_1, param_2, param_3, param_4);
                float metalness = param_2;
                float roughness = param_3;
                uint material = param_4;
                DispatchDeferredParams _1332;
                _1332.mat_projection = _565.dispatch_setup.mat_projection;
                _1332.mat_projection_previous = _565.dispatch_setup.mat_projection_previous;
                _1332.mat_model = _565.dispatch_setup.mat_model;
                _1332.mat_model_previous = _565.dispatch_setup.mat_model_previous;
                _1332.mat_view_inverse = _565.dispatch_setup.mat_view_inverse;
                _1332.mat_view_previous = _565.dispatch_setup.mat_view_previous;
                _1332.camera_position = _565.dispatch_setup.camera_position;
                _1332.camera_projection_params = _565.dispatch_setup.camera_projection_params;
                _1332.camera_projection_params_previous = _565.dispatch_setup.camera_projection_params_previous;
                _1332.near_far_plane = _565.dispatch_setup.near_far_plane;
                _1332.resolution = _565.dispatch_setup.resolution;
                _1332.inv_resolution = _565.dispatch_setup.inv_resolution;
                _1332.frustum_shift = _565.dispatch_setup.frustum_shift;
                DispatchDeferredParams param_5 = _1332;
                vec2 param_6 = vec2(pos);
                vec3 view_direction = deferred_get_view_direction_from_screen_pos(param_5, param_6);
                uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
                uint param_7 = encoded_normal_material_1;
                vec3 _1343 = decode_normal(param_7);
                vec3 vNorm = _1343;
                uint param_8 = encoded_normal_material_1;
                int materialId_1 = decode_material(param_8);
                float param_9 = texelFetch(sTextureDepth, pos, 0).x;
                float depth = linearizeDepth(param_9);
                vec3 param_10 = view_direction;
                float param_11 = depth;
                vec3 world = positionFromDepth(param_10, param_11);
                vec3 dir = normalize(world - _565.dispatch_setup.camera_position);
                vec4 diffuse = vec4(0.0);
                vec4 specular = vec4(0.0);
                bool _1379 = _1376.voxel_lighting_setup.compute_diffuse != 0;
                bool _1395;
                if (_1379)
                {
                    _1395 = (materials.material_properties[material].flags & 32768u) != 0u;
                }
                else
                {
                    _1395 = _1379;
                }
                if (_1395)
                {
                    ivec2 param_12 = noise_pos;
                    vec3 param_13 = in_bbox_data.grid_size_voxelize.xyz;
                    int param_14 = 256;
                    vec3 param_15 = in_bbox_data.bbox_voxelize_min.xyz;
                    vec3 param_16 = world;
                    vec3 param_17 = vNorm;
                    vec3 param_18 = vNorm;
                    float param_19 = range;
                    float param_20 = _1376.voxel_lighting_setup.light_trace_distance_scale;
                    float param_21 = min(1.0, 0.550000011920928955078125 + (roughness * 0.25));
                    int param_22 = 1;
                    float param_23 = _1376.voxel_lighting_setup.light_falloff_factor;
                    float param_24 = _1376.voxel_lighting_setup.occlusion_falloff_factor;
                    float param_25 = _1376.voxel_lighting_setup.trace_range;
                    diffuse = rt_cone_trace_occlusion(param_12, s_voxel_colors_filtered, s_voxel_occupancy_filtered, param_13, param_14, param_15, param_16, param_17, param_18, param_19, param_20, param_21, param_22, param_23, param_24, param_25) * vec4(vec3(1.0 - metalness), 1.0);
                }
                bool _1453 = _1376.voxel_lighting_setup.compute_specular != 0;
                bool _1462;
                if (_1453)
                {
                    _1462 = (materials.material_properties[material].flags & 16384u) != 0u;
                }
                else
                {
                    _1462 = _1453;
                }
                if (_1462)
                {
                    vec3 dir_1 = normalize(reflect(world - _565.dispatch_setup.camera_position, vNorm));
                    float specular_roughness = dot(dir_1, vNorm) * roughness;
                    specular_roughness *= specular_roughness;
                    ivec2 param_26 = noise_pos;
                    vec3 param_27 = in_bbox_data.grid_size_voxelize.xyz;
                    int param_28 = 256;
                    vec3 param_29 = in_bbox_data.bbox_voxelize_min.xyz;
                    vec3 param_30 = world;
                    vec3 param_31 = vNorm;
                    vec3 param_32 = dir_1;
                    float param_33 = range;
                    float param_34 = _1376.voxel_lighting_setup.light_trace_distance_scale;
                    float param_35 = specular_roughness;
                    int param_36 = 1;
                    float param_37 = _1376.voxel_lighting_setup.light_falloff_factor;
                    float param_38 = _1376.voxel_lighting_setup.occlusion_falloff_factor;
                    float param_39 = _1376.voxel_lighting_setup.trace_range;
                    specular = rt_cone_trace_occlusion(param_26, s_voxel_colors_filtered, s_voxel_occupancy_filtered, param_27, param_28, param_29, param_30, param_31, param_32, param_33, param_34, param_35, param_36, param_37, param_38, param_39);
                    specular *= (1.0 - ((roughness * roughness) * 0.85000002384185791015625));
                }
                else
                {
                    specular.w = 0.0;
                }
                vec4 combined_lighting_occlusion = diffuse;
                vec4 _1531 = combined_lighting_occlusion;
                vec3 _1533 = _1531.xyz + specular.xyz;
                combined_lighting_occlusion.x = _1533.x;
                combined_lighting_occlusion.y = _1533.y;
                combined_lighting_occlusion.z = _1533.z;
                float diffuse_occlusion = diffuse.w;
                float specular_occlusion = specular.w;
                vec2 combined_occlusion = vec2(diffuse_occlusion, specular_occlusion);
                float specular_occlusion_contribution = clamp(0.5 - roughness, 0.0, 1.0);
                combined_lighting_occlusion.w = (combined_lighting_occlusion.w * (1.0 - (specular_occlusion_contribution * 0.5))) + (specular.w * specular_occlusion_contribution);
                if (false)
                {
                    vec3 hash = texelFetch(s_BlueNoise, ivec3(noise_pos, 0), 0).xyz;
                    combined_lighting_occlusion.x = hash.x;
                    combined_lighting_occlusion.y = hash.y;
                    combined_lighting_occlusion.z = hash.z;
                    combined_lighting_occlusion.w = hash.x;
                }
                float samples = imageLoad(imDebug, pos).w * 255.0;
                bool _1605;
                if (true)
                {
                    _1605 = (materials.material_properties[material].flags & 65536u) != 0u;
                }
                else
                {
                    _1605 = true;
                }
                if (_1605)
                {
                    vec4 view_prev = vec4(world, 1.0);
                    view_prev = _565.dispatch_setup.mat_view_previous * view_prev;
                    view_prev = _565.dispatch_setup.mat_projection_previous * view_prev;
                    vec3 proj_prev = vec3(0.5) + ((view_prev.xyz / vec3(view_prev.w)) * 0.5);
                    vec2 screen_prev = proj_prev.xy;
                    proj_prev.y = 1.0 - proj_prev.y;
                    bool _1641 = screen_prev.x >= 0.0;
                    bool _1647;
                    if (_1641)
                    {
                        _1647 = screen_prev.y >= 0.0;
                    }
                    else
                    {
                        _1647 = _1641;
                    }
                    bool _1653;
                    if (_1647)
                    {
                        _1653 = screen_prev.x < 1.0;
                    }
                    else
                    {
                        _1653 = _1647;
                    }
                    bool _1659;
                    if (_1653)
                    {
                        _1659 = screen_prev.y < 1.0;
                    }
                    else
                    {
                        _1659 = _1653;
                    }
                    if (_1659)
                    {
                        view_direction_prev.x = (-_565.dispatch_setup.camera_projection_params.z) + (_565.dispatch_setup.camera_projection_params.x * screen_prev.x);
                        view_direction_prev.y = (-_565.dispatch_setup.camera_projection_params.w) + (_565.dispatch_setup.camera_projection_params.y * screen_prev.y);
                        view_direction_prev.z = 1.0;
                        vec2 param_40 = proj_prev.xy;
                        float param_41 = texelFetch(sTextureDepth, pos, 0).x;
                        float depth_prev = sample_previous_depth_max(sTextureDepthPrevious, param_40, param_41);
                        vec3 param_42 = view_direction_prev;
                        float param_43 = depth_prev;
                        vec3 world_prev = positionFromDepthPrevious(param_42, param_43);
                        vec3 param_44 = vNorm;
                        mat4 param_45 = _565.dispatch_setup.mat_model;
                        vec3 screenVNorm = vector_transform_by_mat33(param_44, param_45);
                        float tolerance = _1376.voxel_lighting_setup.reprojection_tolerance;
                        if (length(world - world_prev) <= tolerance)
                        {
                            vec2 param_46 = proj_prev.xy + (_565.dispatch_setup.inv_resolution * 0.5);
                            vec2 param_47 = vec2(_565.dispatch_setup.resolution);
                            vec4 combined_lighting_occlusion_prev = SampleTextureCatmullRom(sTargetLightingPrevious, param_46, param_47);
                            float f = 0.100000001490116119384765625;
                            f = 1.0 / (1.0 + min(4.0, samples));
                            combined_lighting_occlusion = mix(combined_lighting_occlusion_prev, combined_lighting_occlusion, vec4(f));
                            samples += 1.0;
                            imageStore(imDebug, pos, vec4(f, 0.0, 0.0, samples / 255.0));
                        }
                        else
                        {
                            samples = 1.0;
                            imageStore(imDebug, pos, vec4(0.0, 1.0, 1.0, samples / 255.0));
                        }
                    }
                }
                imageStore(imTargetLighting, pos, combined_lighting_occlusion);
                imageStore(imTargetOcclusion, pos, vec4(combined_occlusion, 0.0, 0.0));
            }
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
}

 