#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorFrustumCull_Params
{
    mat4 transform_local_to_gizmo;
    mat4 transform_world_to_view;
    mat4 transform_projection;
    float instance_radius;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstanceModifierLookAt_Params
{
    vec3 ref_position;
    int look_away;
    int axis;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    float color_lod;
    float occupancy_lod;
    float occupancy_threshold;
    int bbox_from_voxelizer;
    uvec3 resolution;
    int _pad2;
    vec3 bbox_position;
    int _pad3;
    vec3 bbox_dimensions;
    int _pad4;
    vec3 instance_scale_base;
    int _pad7;
    vec3 instance_scale_factor;
    int _pad8;
};

struct ModifierFactorSet_Params
{
    float value;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1951;

layout(set = 0, binding = 7, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _1968;

layout(set = 0, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 8, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _2148;

layout(set = 0, binding = 9, std140) uniform VM1
{
    layout(row_major) ModifierFactorFrustumCull_Params VM1_params;
} _2163;

layout(set = 0, binding = 10, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _2281;

layout(set = 0, binding = 11, std140) uniform VM3
{
    InstanceModifierRandomizerV2_Params VM3_params;
} _2295;

layout(set = 0, binding = 12, std140) uniform VM4
{
    ModifierFactorSet_Params VM4_params;
} _2321;

layout(set = 0, binding = 13, std140) uniform VM5
{
    InstanceModifierLookAt_Params VM5_params;
} _2328;

layout(set = 0, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _2384;

layout(set = 0, binding = 4, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2406;

layout(set = 0, binding = 5, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _2427;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _2435;

layout(set = 0, binding = 14) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 15) uniform sampler3D s_voxel_occupancy_filtered;

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _139 = v;
    float _143 = v.w;
    vec3 _146 = (_139.xyz * _143) * 128.0;
    v.x = _146.x;
    v.y = _146.y;
    v.z = _146.z;
    return v.xyz * v.xyz;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _875 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _875;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _894 = vector_transform_by_mat43(param, param_1);
        coords = _894;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _901 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _901;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void modifier_factor_frustum_cull(ModifierFactorFrustumCull_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    vec3 param = coords;
    mat4 param_1 = cs_transforms.mat_local_to_model;
    vec3 _939 = vector_transform_by_mat43(param, param_1);
    coords = _939;
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_world_to_view;
    vec3 _945 = vector_transform_by_mat43(param_2, param_3);
    coords = _945;
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _952 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _952;
    vec3 param_6 = rel_coords;
    mat4 param_7 = modifier_params.transform_projection;
    vec4 _959 = vector_transform_by_mat_projection(param_6, param_7);
    vec4 projected = _959;
    float margin = 0.100000001490116119384765625;
    vec4 _964 = projected;
    vec2 _966 = _964.xy * (1.0 - margin);
    projected.x = _966.x;
    projected.y = _966.y;
    bool _976 = projected.x < (-projected.w);
    bool _985;
    if (!_976)
    {
        _985 = projected.x > projected.w;
    }
    else
    {
        _985 = _976;
    }
    bool _995;
    if (!_985)
    {
        _995 = projected.y < (-projected.w);
    }
    else
    {
        _995 = _985;
    }
    bool _1004;
    if (!_995)
    {
        _1004 = projected.y > projected.w;
    }
    else
    {
        _1004 = _995;
    }
    bool _1013;
    if (!_1004)
    {
        _1013 = projected.z < (-margin);
    }
    else
    {
        _1013 = _1004;
    }
    if (_1013)
    {
        modifier_factor.is_discarded = true;
    }
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _311 = hash(param);
    uint param_1 = v.z;
    uint _316 = hash(param_1);
    uint param_2 = (v.x ^ _311) ^ _316;
    uint _319 = hash(param_2);
    return _319;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _348 = floatConstruct(param_1);
    return _348;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _338 = hash(param);
    uint param_1 = _338;
    float _340 = floatConstruct(param_1);
    return _340;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec4 _mat3ToQuaternion(mat3 r)
{
    float trace = (r[0].x + r[1].y) + r[2].z;
    vec4 q;
    if (trace > 0.0)
    {
        float s = sqrt(trace + 1.0) * 2.0;
        q.w = 0.25 * s;
        q.x = (r[2].y - r[1].z) / s;
        q.y = (r[0].z - r[2].x) / s;
        q.z = (r[1].x - r[0].y) / s;
    }
    else
    {
        bool _1429 = r[0].x > r[1].y;
        bool _1437;
        if (_1429)
        {
            _1437 = r[0].x > r[2].z;
        }
        else
        {
            _1437 = _1429;
        }
        if (_1437)
        {
            float s_1 = sqrt(((1.0 + r[0].x) - r[1].y) - r[2].z) * 2.0;
            q.w = (r[2].y - r[1].z) / s_1;
            q.x = 0.25 * s_1;
            q.y = (r[0].y + r[1].x) / s_1;
            q.z = (r[0].z + r[2].x) / s_1;
        }
        else
        {
            if (r[1].y > r[2].z)
            {
                float s_2 = sqrt(((1.0 + r[1].y) - r[0].x) - r[2].z) * 2.0;
                q.w = (r[0].z - r[2].x) / s_2;
                q.x = (r[0].y + r[1].x) / s_2;
                q.y = 0.25 * s_2;
                q.z = (r[1].z + r[2].y) / s_2;
            }
            else
            {
                float s_3 = sqrt(((1.0 + r[2].z) - r[0].x) - r[1].y) * 2.0;
                q.w = (r[1].x - r[0].y) / s_3;
                q.x = (r[0].z + r[2].x) / s_3;
                q.y = (r[1].z + r[2].y) / s_3;
                q.z = 0.25 * s_3;
            }
        }
    }
    return q;
}

vec4 _slerp(inout vec4 q1, inout vec4 q2, float t)
{
    q1 = normalize(q1);
    q2 = normalize(q2);
    float _dot = dot(q1, q2);
    if (_dot < 0.0)
    {
        q2 = -q2;
        _dot = -_dot;
    }
    if (_dot > 0.999499976634979248046875)
    {
        vec4 result = mix(q1, q2, vec4(t));
        return normalize(result);
    }
    float theta_0 = acos(_dot);
    float theta = theta_0 * t;
    float sin_theta = sin(theta);
    float sin_theta_0 = sin(theta_0);
    float s1 = cos(theta) - ((_dot * sin_theta) / sin_theta_0);
    float s2 = sin_theta / sin_theta_0;
    return (q1 * s1) + (q2 * s2);
}

mat3 _quaternionToMat3(inout vec4 q)
{
    q = normalize(q);
    float xx = q.x * q.x;
    float yy = q.y * q.y;
    float zz = q.z * q.z;
    float xy = q.x * q.y;
    float xz = q.x * q.z;
    float yz = q.y * q.z;
    float wx = q.w * q.x;
    float wy = q.w * q.y;
    float wz = q.w * q.z;
    mat3 m;
    m[0].x = 1.0 - (2.0 * (yy + zz));
    m[0].y = 2.0 * (xy - wz);
    m[0].z = 2.0 * (xz + wy);
    m[1].x = 2.0 * (xy + wz);
    m[1].y = 1.0 - (2.0 * (xx + zz));
    m[1].z = 2.0 * (yz - wx);
    m[2].x = 2.0 * (xz - wy);
    m[2].y = 2.0 * (yz + wx);
    m[2].z = 1.0 - (2.0 * (xx + yy));
    return m;
}

void instance_modifier_look_at(InstanceModifierLookAt_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    vec3 ref_position = modifier_params.ref_position;
    vec3 pos = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    vec3 nx = vec3(instance.m0.x, instance.m1.x, instance.m2.x);
    vec3 ny = vec3(instance.m0.y, instance.m1.y, instance.m2.y);
    vec3 nz = vec3(instance.m0.z, instance.m1.z, instance.m2.z);
    vec3 dir = normalize(pos - ref_position);
    if (modifier_params.look_away != 0)
    {
        dir *= (-1.0);
    }
    vec3 nnx;
    vec3 nny;
    vec3 nnz;
    if (modifier_params.axis == 0)
    {
        nnx = dir;
        nny = normalize(ny);
        nnz = normalize(cross(nnx, nny));
        nny = cross(nnx, nnz);
    }
    else
    {
        if (modifier_params.axis == 1)
        {
            nny = dir;
            nnx = normalize(nx);
            nnz = normalize(cross(nny, nnx));
            nnx = cross(nny, nnz);
        }
        else
        {
            nnz = dir;
            nnx = normalize(nx);
            nny = normalize(cross(nnz, nnx));
            nnx = cross(nny, nnz);
        }
    }
    float nx_length = length(nx);
    float ny_length = length(ny);
    float nz_length = length(nz);
    mat3 m_src;
    m_src[0] = nx / vec3(nx_length);
    m_src[1] = ny / vec3(ny_length);
    m_src[2] = nz / vec3(nz_length);
    mat3 m_dst;
    m_dst[0] = nnx;
    m_dst[1] = nny;
    m_dst[2] = nnz;
    mat3 param = m_src;
    vec4 q_src = _mat3ToQuaternion(param);
    mat3 param_1 = m_dst;
    vec4 q_dst = _mat3ToQuaternion(param_1);
    vec4 param_2 = q_src;
    vec4 param_3 = q_dst;
    float param_4 = modifier_factor.factor;
    vec4 _1883 = _slerp(param_2, param_3, param_4);
    vec4 q_slerp = _1883;
    vec4 param_5 = q_slerp;
    mat3 _1887 = _quaternionToMat3(param_5);
    mat3 m_slerp = _1887;
    m_slerp[0] *= nx_length;
    m_slerp[1] *= ny_length;
    m_slerp[2] *= nz_length;
    vec3 _1909 = vec3(m_slerp[0].x, m_slerp[1].x, m_slerp[2].x);
    instance.m0.x = _1909.x;
    instance.m0.y = _1909.y;
    instance.m0.z = _1909.z;
    vec3 _1922 = vec3(m_slerp[0].y, m_slerp[1].y, m_slerp[2].y);
    instance.m1.x = _1922.x;
    instance.m1.y = _1922.y;
    instance.m1.z = _1922.z;
    vec3 _1935 = vec3(m_slerp[0].z, m_slerp[1].z, m_slerp[2].z);
    instance.m2.x = _1935.x;
    instance.m2.y = _1935.y;
    instance.m2.z = _1935.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_1951.instance_params.instance_count >= _1951.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_1968.instancing_generator_params.resolution.x * _1968.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_1968.instancing_generator_params.resolution.x * _1968.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _1968.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _1968.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 instancing_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    if (_1968.instancing_generator_params.bbox_from_voxelizer == 0)
    {
        instancing_bbox_origin = _1968.instancing_generator_params.bbox_position;
        instancing_bbox_size = _1968.instancing_generator_params.bbox_dimensions;
    }
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_1968.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (instance_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _2055 = source_voxel_position.x < 0.0;
    bool _2062;
    if (!_2055)
    {
        _2062 = source_voxel_position.y < 0.0;
    }
    else
    {
        _2062 = _2055;
    }
    bool _2069;
    if (!_2062)
    {
        _2069 = source_voxel_position.z < 0.0;
    }
    else
    {
        _2069 = _2062;
    }
    bool _2076;
    if (!_2069)
    {
        _2076 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _2076 = _2069;
    }
    bool _2083;
    if (!_2076)
    {
        _2083 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _2083 = _2076;
    }
    bool _2090;
    if (!_2083)
    {
        _2090 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _2090 = _2083;
    }
    if (_2090)
    {
        return;
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, _1968.instancing_generator_params.color_lod);
    vec3 _2106 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _2106;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, _1968.instancing_generator_params.occupancy_lod).x;
    if (voxel_occupancy <= _1968.instancing_generator_params.occupancy_threshold)
    {
        return;
    }
    voxel_occupancy -= _1968.instancing_generator_params.occupancy_threshold;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _2153;
    _2153.transform_local_to_gizmo = _2148.VM0_params.transform_local_to_gizmo;
    _2153.noise_domain_scale = _2148.VM0_params.noise_domain_scale;
    _2153.modifier_function = _2148.VM0_params.modifier_function;
    _2153.noise_domain_offset = _2148.VM0_params.noise_domain_offset;
    _2153.noise_value_scale = _2148.VM0_params.noise_value_scale;
    _2153.noise_value_offset = _2148.VM0_params.noise_value_offset;
    _2153.influence_scope = _2148.VM0_params.influence_scope;
    _2153._pad0 = _2148.VM0_params._pad0;
    _2153._pad1 = _2148.VM0_params._pad1;
    ModifierFactorNoise_Params param_1 = _2153;
    ModifierFactor param_2 = modifier_factor;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    modifier_factor_noise_simplex2(param_1, param_2, param_3);
    modifier_factor = param_2;
    ModifierFactorFrustumCull_Params _2168;
    _2168.transform_local_to_gizmo = _2163.VM1_params.transform_local_to_gizmo;
    _2168.transform_world_to_view = _2163.VM1_params.transform_world_to_view;
    _2168.transform_projection = _2163.VM1_params.transform_projection;
    _2168.instance_radius = _2163.VM1_params.instance_radius;
    ModifierFactorFrustumCull_Params param_4 = _2168;
    ModifierFactor param_5 = modifier_factor;
    CoordinateSystemTrasforms param_6 = cs_transforms;
    modifier_factor_frustum_cull(param_4, param_5, param_6);
    modifier_factor = param_5;
    bool _2178 = modifier_factor.factor <= 9.9999997473787516355514526367188e-05;
    bool _2185;
    if (!_2178)
    {
        _2185 = modifier_factor.is_discarded == true;
    }
    else
    {
        _2185 = _2178;
    }
    if (_2185)
    {
        return;
    }
    vec3 instance_scale = _1968.instancing_generator_params.instance_scale_base + (_1968.instancing_generator_params.instance_scale_factor * (voxel_occupancy * modifier_factor.factor));
    bool _2202 = instance_scale.x <= 0.0;
    bool _2209;
    if (!_2202)
    {
        _2209 = instance_scale.y <= 0.0;
    }
    else
    {
        _2209 = _2202;
    }
    bool _2216;
    if (!_2209)
    {
        _2216 = instance_scale.z <= 0.0;
    }
    else
    {
        _2216 = _2209;
    }
    if (_2216)
    {
        return;
    }
    voxel_color += vec3(voxel_occupancy * 0.00999999977648258209228515625);
    mat3 transform;
    transform[0] = vec3(instance_scale.x, 0.0, 0.0);
    transform[1] = vec3(0.0, instance_scale.y, 0.0);
    transform[2] = vec3(0.0, 0.0, instance_scale.z);
    transform = transpose(transform);
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(voxel_color, 1.0);
    instance.flipbook_card = 0u;
    ModifierFactorNoise_Params _2285;
    _2285.transform_local_to_gizmo = _2281.VM2_params.transform_local_to_gizmo;
    _2285.noise_domain_scale = _2281.VM2_params.noise_domain_scale;
    _2285.modifier_function = _2281.VM2_params.modifier_function;
    _2285.noise_domain_offset = _2281.VM2_params.noise_domain_offset;
    _2285.noise_value_scale = _2281.VM2_params.noise_value_scale;
    _2285.noise_value_offset = _2281.VM2_params.noise_value_offset;
    _2285.influence_scope = _2281.VM2_params.influence_scope;
    _2285._pad0 = _2281.VM2_params._pad0;
    _2285._pad1 = _2281.VM2_params._pad1;
    ModifierFactorNoise_Params param_7 = _2285;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_noise_simplex2(param_7, param_8, param_9);
    modifier_factor = param_8;
    InstanceModifierRandomizerV2_Params _2300;
    _2300.replace_previous_rotation_scale = _2295.VM3_params.replace_previous_rotation_scale;
    _2300.randomness_seed = _2295.VM3_params.randomness_seed;
    _2300.replace_previous_position = _2295.VM3_params.replace_previous_position;
    _2300.randomization_input = _2295.VM3_params.randomization_input;
    _2300.position_modifier_base = _2295.VM3_params.position_modifier_base;
    _2300.position_modifier_base_modifier_factor = _2295.VM3_params.position_modifier_base_modifier_factor;
    _2300.position_modifier_range = _2295.VM3_params.position_modifier_range;
    _2300.position_modifier_range_modifier_factor = _2295.VM3_params.position_modifier_range_modifier_factor;
    _2300.rotation_modifier_base = _2295.VM3_params.rotation_modifier_base;
    _2300.rotation_modifier_base_modifier_factor = _2295.VM3_params.rotation_modifier_base_modifier_factor;
    _2300.rotation_modifier_range = _2295.VM3_params.rotation_modifier_range;
    _2300.rotation_modifier_range_modifier_factor = _2295.VM3_params.rotation_modifier_range_modifier_factor;
    _2300.scale_modifier_base = _2295.VM3_params.scale_modifier_base;
    _2300.scale_modifier_base_modifier_factor = _2295.VM3_params.scale_modifier_base_modifier_factor;
    _2300.scale_modifier_range = _2295.VM3_params.scale_modifier_range;
    _2300.scale_modifier_range_modifier_factor = _2295.VM3_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_10 = _2300;
    ModifierFactor param_11 = modifier_factor;
    Instance param_12 = instance;
    uint param_13 = id;
    instance_modifier_randomizer_v2(param_10, param_11, param_12, param_13);
    modifier_factor = param_11;
    instance = param_12;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.factor = _2321.VM4_params.value;
    InstanceModifierLookAt_Params _2333;
    _2333.ref_position = _2328.VM5_params.ref_position;
    _2333.look_away = _2328.VM5_params.look_away;
    _2333.axis = _2328.VM5_params.axis;
    InstanceModifierLookAt_Params param_14 = _2333;
    ModifierFactor param_15 = modifier_factor;
    Instance param_16 = instance;
    uint param_17 = id;
    instance_modifier_look_at(param_14, param_15, param_16, param_17);
    modifier_factor = param_15;
    instance = param_16;
    bool _2347 = length(instance.m0.xyz) < 9.9999997473787516355514526367188e-05;
    bool _2356;
    if (!_2347)
    {
        _2356 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _2356 = _2347;
    }
    bool _2365;
    if (!_2356)
    {
        _2365 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _2365 = _2356;
    }
    if (_2365)
    {
        return;
    }
    int _2371 = atomicAdd(_1951.instance_params.instance_count, 1);
    uint instance_id = uint(_2371);
    if (instance_id >= uint(_1951.instance_params.buffer_capacity))
    {
        return;
    }
    _2384.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _2384.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _2384.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _2406.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _2406.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _2427.instance_hash[instance_id] = instance.hash;
    _2435.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 