#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct FilterCubemapParams
{
    vec4 params;
    uint cube_face;
    float cone_angle;
    float mip_level;
    int cube_face_size;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform FilterCubemapParamsBuffer
{
    FilterCubemapParams filter_params;
} _160;

layout(set = 0, binding = 3) uniform samplerCube sSourceCubemapMip;
layout(set = 0, binding = 2, rgba16f) uniform writeonly image2D imTarget;

mat3 matrixFromVector(vec3 n)
{
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

float rnd(vec2 uv)
{
    return fract(sin(dot(uv, vec2(25.9796009063720703125, 156.46600341796875))) * 43758.546875);
}

vec3 hemisphereSample_phong(vec2 uv, mat3 vecSpace, vec3 cubeDir, float specPow)
{
    float phi = (uv.y * 2.0) * 3.1415927410125732421875;
    float cosTheta = pow(1.0 - uv.x, 1.0 / (specPow + 1.0));
    float sinTheta = sqrt(1.0 - (cosTheta * cosTheta));
    vec3 sampleDir = vec3(cos(phi) * sinTheta, sin(phi) * sinTheta, cosTheta);
    return vecSpace * sampleDir;
}

void main()
{
    uvec2 pixel_pos = gl_GlobalInvocationID.xy;
    vec2 pos = vec2(pixel_pos) / vec2(float(_160.filter_params.cube_face_size));
    pos.y = 1.0 - pos.y;
    pos = (pos - vec2(0.5)) * 2.0;
    vec3 normal = normalize(vec3(pos, 1.0));
    if (_160.filter_params.cube_face == 2u)
    {
        normal = normalize(vec3(pos.x, 1.0, -pos.y));
    }
    else
    {
        if (_160.filter_params.cube_face == 3u)
        {
            normal = normalize(vec3(pos.x, -1.0, pos.y));
        }
        else
        {
            if (_160.filter_params.cube_face == 0u)
            {
                normal = normalize(vec3(1.0, pos.y, -pos.x));
            }
            else
            {
                if (_160.filter_params.cube_face == 1u)
                {
                    normal = normalize(vec3(-1.0, pos.y, pos.x));
                }
                else
                {
                    if (_160.filter_params.cube_face == 5u)
                    {
                        normal = normalize(vec3(-pos.x, pos.y, -1.0));
                    }
                }
            }
        }
    }
    vec3 up = vec3(0.0, 1.0, 0.0);
    vec3 right = normalize(cross(up, normal));
    up = cross(normal, right);
    vec3 param = normalize(normal);
    mat3 vecSpace = matrixFromVector(param);
    vec4 out_color = vec4(0.0);
    vec4 color = vec4(0.0);
    int i = 0;
    for (;;)
    {
        if (i < 4096)
        {
            float sini = sin(float(i));
            float cosi = cos(float(i));
            vec2 param_1 = vec2(sini, cosi);
            float rand = rnd(param_1);
            vec2 param_2 = vec2(float(i) / 4096.0, rand);
            mat3 param_3 = vecSpace;
            vec3 param_4 = normal;
            float param_5 = 500.0 / _160.filter_params.params.y;
            vec3 vect = hemisphereSample_phong(param_2, param_3, param_4, param_5);
            color += textureLod(sSourceCubemapMip, vect, 0.0);
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    color /= vec4(4096.0);
    out_color = color;
    imageStore(imTarget, ivec2(pixel_pos), out_color);
}

 