#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterInstances_Params
{
    vec4 particle_color;
    vec3 primitive_size;
    float particle_lifetime;
    vec3 position_randomness;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
    int random_source_instance;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorQuantizePosition_Params
{
    vec3 quantization_step;
    float _pad0;
    vec3 offset;
    int quantize_x;
    int quantize_y;
    int quantize_z;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParamsVM0
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _423;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _447;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _470;

layout(set = 0, binding = 7, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1024;

layout(set = 0, binding = 8, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1890;

layout(set = 0, binding = 4, std430) buffer VM0
{
    ParticleEmitterInstances_Params VM0_params;
} _1933;

layout(set = 0, binding = 9, std140) uniform InstanceParamsBufferVM0
{
    InstanceParamsVM0 instance_params_VM0;
} _1982;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBufferVM0
{
    vec4 instance_transform_VM0[];
} _1995;

layout(set = 0, binding = 10, std140) uniform VM1
{
    ModifierFactorQuantizePosition_Params VM1_params;
} _2077;

layout(set = 0, binding = 11, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _2092;

layout(set = 0, binding = 12, std140) uniform VM3
{
    ParticleModifierCurl_Params VM3_params;
} _2113;

layout(set = 0, binding = 13, std140) uniform VM4
{
    layout(row_major) ModifierFactorNoise_Params VM4_params;
} _2135;

layout(set = 0, binding = 6, std430) buffer VM6
{
    ParticleModifierAttractor_Params VM6_params;
} _2159;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_470.prt_prev_positions[(id * 3u) + 0u], _470.prt_prev_positions[(id * 3u) + 1u], _470.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _429;
    _429.life_time = _423.prt_states[id].life_time;
    _429.life_span = _423.prt_states[id].life_span;
    _429.generation_id = _423.prt_states[id].generation_id;
    _429.color = _423.prt_states[id].color;
    ParticleState _428 = _429;
    return _428;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _403 = hash(param);
    uint param_1 = _403;
    float _405 = floatConstruct(param_1);
    return _405;
}

float particle_emitter_instances_rand(float n)
{
    float param = n;
    return random(param);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _492 = color_convert_rgb_float3_uint(param);
    uint v = _492;
    state.color = v;
}

void particle_emitter_instances_emit(ParticleEmitterInstances_Params emitter_params, vec4 instance_transform0, vec4 instance_transform1, vec4 instance_transform2, inout Particle p, uint id)
{
    float fid = float(id);
    float param = (_1024.globals.time + (fid * 5.131999969482421875)) + emitter_params.seed;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_instances_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    vec3 pos = vec3(instance_transform0.w, instance_transform1.w, instance_transform2.w);
    float param_3 = fid + (emitter_params.seed * 0.1271300017833709716796875);
    pos.x += (emitter_params.position_randomness.x * (particle_emitter_instances_rand(param_3) - 0.5));
    float param_4 = fid - (emitter_params.seed * 1.2127130031585693359375);
    pos.y += (emitter_params.position_randomness.y * (particle_emitter_instances_rand(param_4) - 0.5));
    float param_5 = fid + (emitter_params.seed * 2.3127129077911376953125);
    pos.z += (emitter_params.position_randomness.z * (particle_emitter_instances_rand(param_5) - 0.5));
    p.pos = pos;
    ParticleState param_6 = p.state;
    vec3 param_7 = emitter_params.particle_color.xyz;
    prt_set_color(param_6, param_7);
    p.state = param_6;
}

void modifier_factor_quantize_position(ModifierFactorQuantizePosition_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 p = modifier_factor.position;
    p = vec4(p, 1.0).xyz;
    p = (floor((p + modifier_params.offset) / modifier_params.quantization_step) * modifier_params.quantization_step) - modifier_params.offset;
    p = vec4(p, 1.0).xyz;
    if (modifier_params.quantize_x != 0)
    {
        modifier_factor.position.x = p.x;
    }
    if (modifier_params.quantize_y != 0)
    {
        modifier_factor.position.y = p.y;
    }
    if (modifier_params.quantize_z != 0)
    {
        modifier_factor.position.z = p.z;
    }
    if (modifier_factor.has_world_position)
    {
        vec3 p_1 = modifier_factor.world_position;
        p_1 = floor(p_1 / modifier_params.quantization_step) * modifier_params.quantization_step;
        if (modifier_params.quantize_x != 0)
        {
            modifier_factor.world_position.x = p_1.x;
        }
        if (modifier_params.quantize_y != 0)
        {
            modifier_factor.world_position.y = p_1.y;
        }
        if (modifier_params.quantize_z != 0)
        {
            modifier_factor.world_position.z = p_1.z;
        }
    }
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash_1 = _permute(param_2);
    vec4 theta = hash_1 * 3.883222103118896484375;
    vec4 sz = (hash_1 * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash_1 * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1733 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1733;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1751 = vector_transform_by_mat43(param, param_1);
        coords = _1751;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1758 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1758;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec4 saturate(vec4 a)
{
    return max(min(a, vec4(1.0)), vec4(0.0));
}

uvec2 btn_pcg4d16(uvec4 p)
{
    uvec4 v = (p * uvec4(1664525u)) + uvec4(1013904223u);
    v.x += (v.y * v.w);
    v.y += (v.z * v.x);
    v.z += (v.x * v.y);
    v.w += (v.y * v.z);
    v.x += (v.y * v.w);
    v.y += (v.z * v.x);
    return v.xy;
}

vec4 btn_gradient4d(uint hash_1)
{
    vec4 g = vec4(uvec4(hash_1) & uvec4(524288u, 262144u, 131072u, 65536u));
    return (g * vec4(3.814697265625e-06, 7.62939453125e-06, 1.52587890625e-05, 3.0517578125e-05)) - vec4(1.0);
}

vec3 saturate(vec3 a)
{
    return max(vec3(0.0), min(vec3(1.0), a));
}

vec2 saturate(vec2 a)
{
    return max(vec2(0.0), min(vec2(1.0), a));
}

vec3 BitangentNoise4D(vec4 p)
{
    vec4 i = floor(p + vec4(dot(p, vec4(0.309017002582550048828125))));
    vec4 x0 = (p - i) + vec4(dot(i, vec4(0.13819660246372222900390625)));
    vec3 isX = step(x0.yzw, x0.xxx);
    vec3 isYZ = step(x0.zww, x0.yyz);
    vec4 i0;
    i0.x = (isX.x + isX.y) + isX.z;
    vec3 _636 = vec3(1.0) - isX;
    i0.y = _636.x;
    i0.z = _636.y;
    i0.w = _636.z;
    i0.y += (isYZ.x + isYZ.y);
    vec4 _656 = i0;
    vec2 _658 = _656.zw + (vec2(1.0) - isYZ.xy);
    i0.z = _658.x;
    i0.w = _658.y;
    i0.z += isYZ.z;
    i0.w += (1.0 - isYZ.z);
    vec4 param = i0;
    vec4 i3 = saturate(param);
    vec4 param_1 = i0 - vec4(1.0);
    vec4 i2 = saturate(param_1);
    vec4 param_2 = i0 - vec4(2.0);
    vec4 i1 = saturate(param_2);
    vec4 x1 = (x0 - i1) + vec4(0.13819660246372222900390625);
    vec4 x2 = (x0 - i2) + vec4(0.2763932049274444580078125);
    vec4 x3 = (x0 - i3) + vec4(0.4145897924900054931640625);
    vec4 x4 = x0 + vec4(-0.447213590145111083984375);
    i += vec4(32768.5);
    uvec4 param_3 = uvec4(i);
    uvec2 hash0 = btn_pcg4d16(param_3);
    uvec4 param_4 = uvec4(i + i1);
    uvec2 hash1 = btn_pcg4d16(param_4);
    uvec4 param_5 = uvec4(i + i2);
    uvec2 hash2 = btn_pcg4d16(param_5);
    uvec4 param_6 = uvec4(i + i3);
    uvec2 hash3 = btn_pcg4d16(param_6);
    uvec4 param_7 = uvec4(i + vec4(1.0));
    uvec2 hash4 = btn_pcg4d16(param_7);
    uint param_8 = hash0.x;
    vec4 p00 = btn_gradient4d(param_8);
    uint param_9 = hash0.y;
    vec4 p01 = btn_gradient4d(param_9);
    uint param_10 = hash1.x;
    vec4 p10 = btn_gradient4d(param_10);
    uint param_11 = hash1.y;
    vec4 p11 = btn_gradient4d(param_11);
    uint param_12 = hash2.x;
    vec4 p20 = btn_gradient4d(param_12);
    uint param_13 = hash2.y;
    vec4 p21 = btn_gradient4d(param_13);
    uint param_14 = hash3.x;
    vec4 p30 = btn_gradient4d(param_14);
    uint param_15 = hash3.y;
    vec4 p31 = btn_gradient4d(param_15);
    uint param_16 = hash4.x;
    vec4 p40 = btn_gradient4d(param_16);
    uint param_17 = hash4.y;
    vec4 p41 = btn_gradient4d(param_17);
    vec3 param_18 = vec3(0.60000002384185791015625) - vec3(dot(x0, x0), dot(x1, x1), dot(x2, x2));
    vec3 m0 = saturate(param_18);
    vec2 param_19 = vec2(0.60000002384185791015625) - vec2(dot(x3, x3), dot(x4, x4));
    vec2 m1 = saturate(param_19);
    vec3 m02 = m0 * m0;
    vec3 m03 = m02 * m0;
    vec2 m12 = m1 * m1;
    vec2 m13 = m12 * m1;
    vec3 temp0 = m02 * vec3(dot(p00, x0), dot(p10, x1), dot(p20, x2));
    vec2 temp1 = m12 * vec2(dot(p30, x3), dot(p40, x4));
    vec4 grad0 = (((((x0 * temp0.x) + (x1 * temp0.y)) + (x2 * temp0.z)) + (x3 * temp1.x)) + (x4 * temp1.y)) * (-6.0);
    grad0 += (((((p00 * m03.x) + (p10 * m03.y)) + (p20 * m03.z)) + (p30 * m13.x)) + (p40 * m13.y));
    temp0 = m02 * vec3(dot(p01, x0), dot(p11, x1), dot(p21, x2));
    temp1 = m12 * vec2(dot(p31, x3), dot(p41, x4));
    vec4 grad1 = (((((x0 * temp0.x) + (x1 * temp0.y)) + (x2 * temp0.z)) + (x3 * temp1.x)) + (x4 * temp1.y)) * (-6.0);
    grad1 += (((((p01 * m03.x) + (p11 * m03.y)) + (p21 * m03.z)) + (p31 * m13.x)) + (p41 * m13.y));
    return cross(grad0.xyz, grad1.xyz) * 81.0;
}

void particle_modifier_curl_fast(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec4 param = vec4(p.pos * modifier_params.noise_scale, _1024.globals.time * modifier_params.noise_speed);
    vec3 n = BitangentNoise4D(param);
    n = normalize(n);
    p.pos += (((n * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _436;
    _436.life_time = state.life_time;
    _436.life_span = state.life_span;
    _436.generation_id = state.generation_id;
    _436.color = state.color;
    _423.prt_states[id] = _436;
}

void prt_set_position(uint id, vec3 p)
{
    _447.prt_positions[(id * 3u) + 0u] = p.x;
    _447.prt_positions[(id * 3u) + 1u] = p.y;
    _447.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_1890.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    bool _1927 = !prt_is_alive(param_3);
    bool _1938;
    if (_1927)
    {
        _1938 = _1933.VM0_params.pending > 0;
    }
    else
    {
        _1938 = _1927;
    }
    if (_1938)
    {
        int final_emit_idx = -1;
        if (_1933.VM0_params.random_source_instance != 0)
        {
            int pi = 0;
            for (;;)
            {
                if (pi < 8)
                {
                    float param_4 = float(id) * 1.61803400516510009765625;
                    float fid = random(param_4);
                    uint instance_id = uint(fid * 10000000.0);
                    instance_id = (instance_id + uint(_1933.VM0_params.seed)) + uint(pi * 7919);
                    instance_id %= uint(_1982.instance_params_VM0.instance_count);
                    uint transform_idx = instance_id * 3u;
                    vec4 instance_transform0 = _1995.instance_transform_VM0[transform_idx + 0u];
                    float s = dot(instance_transform0.xyz, instance_transform0.xyz);
                    if (s > 9.9999997473787516355514526367188e-06)
                    {
                        final_emit_idx = int(instance_id);
                        break;
                    }
                    pi++;
                    continue;
                }
                else
                {
                    break;
                }
            }
        }
        else
        {
            if (id < uint(_1982.instance_params_VM0.instance_count))
            {
                final_emit_idx = int(id);
            }
        }
        if (final_emit_idx != (-1))
        {
            int _2033 = atomicAdd(_1933.VM0_params.pending, -1);
            int pending = _2033;
            if (pending > 0)
            {
                uint transform_idx_1 = uint(final_emit_idx) * 3u;
                vec4 instance_transform0_1 = _1995.instance_transform_VM0[transform_idx_1 + 0u];
                vec4 instance_transform1 = _1995.instance_transform_VM0[transform_idx_1 + 1u];
                vec4 instance_transform2 = _1995.instance_transform_VM0[transform_idx_1 + 2u];
                ParticleEmitterInstances_Params _2061;
                _2061.particle_color = _1933.VM0_params.particle_color;
                _2061.primitive_size = _1933.VM0_params.primitive_size;
                _2061.particle_lifetime = _1933.VM0_params.particle_lifetime;
                _2061.position_randomness = _1933.VM0_params.position_randomness;
                _2061.particle_lifetime_randomness = _1933.VM0_params.particle_lifetime_randomness;
                _2061.rate = _1933.VM0_params.rate;
                _2061.seed = _1933.VM0_params.seed;
                _2061.pending = _1933.VM0_params.pending;
                _2061.random_source_instance = _1933.VM0_params.random_source_instance;
                ParticleEmitterInstances_Params param_5 = _2061;
                vec4 param_6 = instance_transform0_1;
                vec4 param_7 = instance_transform1;
                vec4 param_8 = instance_transform2;
                Particle param_9 = p;
                uint param_10 = id;
                particle_emitter_instances_emit(param_5, param_6, param_7, param_8, param_9, param_10);
                p = param_9;
            }
        }
    }
    ModifierFactorQuantizePosition_Params _2082;
    _2082.quantization_step = _2077.VM1_params.quantization_step;
    _2082._pad0 = _2077.VM1_params._pad0;
    _2082.offset = _2077.VM1_params.offset;
    _2082.quantize_x = _2077.VM1_params.quantize_x;
    _2082.quantize_y = _2077.VM1_params.quantize_y;
    _2082.quantize_z = _2077.VM1_params.quantize_z;
    ModifierFactorQuantizePosition_Params param_11 = _2082;
    ModifierFactor param_12 = modifier_factor;
    CoordinateSystemTrasforms param_13 = cs_transforms;
    modifier_factor_quantize_position(param_11, param_12, param_13);
    modifier_factor = param_12;
    ModifierFactorNoise_Params _2097;
    _2097.transform_local_to_gizmo = _2092.VM2_params.transform_local_to_gizmo;
    _2097.noise_domain_scale = _2092.VM2_params.noise_domain_scale;
    _2097.modifier_function = _2092.VM2_params.modifier_function;
    _2097.noise_domain_offset = _2092.VM2_params.noise_domain_offset;
    _2097.noise_value_scale = _2092.VM2_params.noise_value_scale;
    _2097.noise_value_offset = _2092.VM2_params.noise_value_offset;
    _2097.influence_scope = _2092.VM2_params.influence_scope;
    _2097._pad0 = _2092.VM2_params._pad0;
    _2097._pad1 = _2092.VM2_params._pad1;
    ModifierFactorNoise_Params param_14 = _2097;
    ModifierFactor param_15 = modifier_factor;
    CoordinateSystemTrasforms param_16 = cs_transforms;
    modifier_factor_noise_simplex2(param_14, param_15, param_16);
    modifier_factor = param_15;
    ParticleState param_17 = p.state;
    if (prt_is_alive(param_17))
    {
        ParticleModifierCurl_Params _2118;
        _2118.position = _2113.VM3_params.position;
        _2118.falloff_mode = _2113.VM3_params.falloff_mode;
        _2118.radius = _2113.VM3_params.radius;
        _2118.falloff_inverse = _2113.VM3_params.falloff_inverse;
        _2118.noise_strength = _2113.VM3_params.noise_strength;
        _2118.noise_speed = _2113.VM3_params.noise_speed;
        _2118.noise_scale = _2113.VM3_params.noise_scale;
        ParticleModifierCurl_Params param_18 = _2118;
        ParticleLifecycleParams _2123;
        _2123.time_step = _1890.lifecycle_params.time_step;
        _2123.max_lifetime = _1890.lifecycle_params.max_lifetime;
        _2123.reset = _1890.lifecycle_params.reset;
        _2123._pad1 = _1890.lifecycle_params._pad1;
        ParticleLifecycleParams param_19 = _2123;
        ModifierFactor param_20 = modifier_factor;
        Particle param_21 = p;
        uint param_22 = id;
        particle_modifier_curl_fast(param_18, param_19, param_20, param_21, param_22);
        modifier_factor = param_20;
        p = param_21;
    }
    ModifierFactorNoise_Params _2139;
    _2139.transform_local_to_gizmo = _2135.VM4_params.transform_local_to_gizmo;
    _2139.noise_domain_scale = _2135.VM4_params.noise_domain_scale;
    _2139.modifier_function = _2135.VM4_params.modifier_function;
    _2139.noise_domain_offset = _2135.VM4_params.noise_domain_offset;
    _2139.noise_value_scale = _2135.VM4_params.noise_value_scale;
    _2139.noise_value_offset = _2135.VM4_params.noise_value_offset;
    _2139.influence_scope = _2135.VM4_params.influence_scope;
    _2139._pad0 = _2135.VM4_params._pad0;
    _2139._pad1 = _2135.VM4_params._pad1;
    ModifierFactorNoise_Params param_23 = _2139;
    ModifierFactor param_24 = modifier_factor;
    CoordinateSystemTrasforms param_25 = cs_transforms;
    modifier_factor_noise_simplex2(param_23, param_24, param_25);
    modifier_factor = param_24;
    modifier_factor.factor = abs(modifier_factor.factor);
    ParticleState param_26 = p.state;
    if (prt_is_alive(param_26))
    {
        ParticleModifierAttractor_Params _2164;
        _2164.position = _2159.VM6_params.position;
        _2164.radius = _2159.VM6_params.radius;
        _2164.velocity = _2159.VM6_params.velocity;
        ParticleModifierAttractor_Params param_27 = _2164;
        ModifierFactor param_28 = modifier_factor;
        ParticleLifecycleParams _2170;
        _2170.time_step = _1890.lifecycle_params.time_step;
        _2170.max_lifetime = _1890.lifecycle_params.max_lifetime;
        _2170.reset = _1890.lifecycle_params.reset;
        _2170._pad1 = _1890.lifecycle_params._pad1;
        ParticleLifecycleParams param_29 = _2170;
        Particle param_30 = p;
        uint param_31 = id;
        particle_modifier_attractor(param_27, param_28, param_29, param_30, param_31);
        p = param_30;
    }
    ParticleState param_32 = p.state;
    float param_33 = _1890.lifecycle_params.time_step;
    float param_34 = _1890.lifecycle_params.max_lifetime;
    prt_advance_life(param_32, param_33, param_34);
    p.state = param_32;
    uint param_35 = id;
    ParticleState param_36 = p.state;
    prt_set_state(param_35, param_36);
    uint param_37 = id;
    vec3 param_38 = p.pos;
    prt_set_position(param_37, param_38);
}

 