#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(triangles) in;
layout(max_vertices = 3, triangle_strip) out;

struct PartitionGeometryDrawParams
{
    uint instance_idx;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 2, binding = 1, std430) buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _37;

layout(set = 2, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 2, binding = 4, std140) uniform PartitionGeometryDrawParamsBuffer
{
    PartitionGeometryDrawParams partition_geometry_params;
} _213;

layout(set = 2, binding = 3, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _225;

layout(set = 2, binding = 5, r32ui) uniform uimage3D imGridMarkers0;

layout(location = 1) in Vertex
{
    vec3 vLocalPos;
    uint vIdx;
} vtx_inputs[3];

layout(location = 5) flat out uint vTriIndex[3];
layout(location = 3) flat out vec3 vTriNormal;
layout(location = 0) flat out int vOrientationIndex;

bool is_contained_in_single_cell(inout vec3 v0, inout vec3 v1, inout vec3 v2, out ivec3 p)
{
    vec3 bbox_origin = in_bbox_data.bbox_raytrace_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_raytrace.xyz;
    vec3 s = -bbox_origin;
    v0 += s;
    v1 += s;
    v2 += s;
    vec3 f = vec3(1.0) / bbox_grid_size;
    v0 *= f;
    v1 *= f;
    v2 *= f;
    ivec3 mi = ivec3(floor(min(v0, min(v1, v2))));
    ivec3 ma = ivec3(floor(max(v0, max(v1, v2))));
    p = mi;
    bool _138 = mi.x == ma.x;
    bool _146;
    if (_138)
    {
        _146 = mi.y == ma.y;
    }
    else
    {
        _146 = _138;
    }
    bool _154;
    if (_146)
    {
        _154 = mi.z == ma.z;
    }
    else
    {
        _154 = _146;
    }
    if (_154)
    {
        return true;
    }
    return false;
}

void rt_link_list_increase_count(uint list_index)
{
    uint _44 = atomicAdd(_37.in_faces_list_tails_data[list_index], 1u);
}

void rt_pack_grid_marker_to_uint(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

void main()
{
    vec3 bbox_origin = in_bbox_data.bbox_raytrace_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_raytrace.xyz;
    vec3 n = cross(vtx_inputs[1].vLocalPos - vtx_inputs[0].vLocalPos, vtx_inputs[2].vLocalPos - vtx_inputs[0].vLocalPos);
    vec3 nn = cross(vtx_inputs[1].vLocalPos - vtx_inputs[0].vLocalPos, vtx_inputs[2].vLocalPos - vtx_inputs[0].vLocalPos);
    vec3 tri_normal_for_lighting = vec3(normalize(nn));
    n = abs(n);
    uint first_face_idx = 0u;
    if (_213.partition_geometry_params.instance_idx > 0u)
    {
        first_face_idx = _225.transformed_data_location[_213.partition_geometry_params.instance_idx - 1u].last_face_idx + 1u;
    }
    vec3 v0 = vtx_inputs[0].vLocalPos;
    vec3 v1 = vtx_inputs[1].vLocalPos;
    vec3 v2 = vtx_inputs[2].vLocalPos;
    if (true)
    {
        vec3 param = v0;
        vec3 param_1 = v1;
        vec3 param_2 = v2;
        ivec3 param_3;
        bool _253 = is_contained_in_single_cell(param, param_1, param_2, param_3);
        ivec3 cell = param_3;
        bool is_single_cell_triangle = _253;
        if (is_single_cell_triangle)
        {
            uint ccx = uint(cell.x);
            uint ccy = uint(cell.y);
            uint ccz = uint(cell.z);
            uint list_index = (ccx + (ccy * 256u)) + ((ccz * 256u) * 256u);
            uint param_4 = list_index;
            rt_link_list_increase_count(param_4);
            ivec3 param_6;
            uint param_7;
            do
            {
                ivec3 param_5 = ivec3(int(ccx), int(ccy), int(ccz));
                rt_pack_grid_marker_to_uint(param_5, param_6, param_7);
                ivec3 pos_packed = param_6;
                uint bit = param_7;
                uint _310 = imageAtomicOr(imGridMarkers0, pos_packed, 1u << bit);
            } while (false);
            return;
        }
    }
    vec3 s = -bbox_origin;
    v0 += s;
    v1 += s;
    v2 += s;
    vec3 f = vec3(1.0) / bbox_grid_size;
    v0 *= f;
    v1 *= f;
    v2 *= f;
    float area = length(cross(v1 - v0, v2 - v0));
    if (area <= 0.001000000047497451305389404296875)
    {
        return;
    }
    vec3 grid_v0 = v0;
    vec3 grid_v1 = v1;
    vec3 grid_v2 = v2;
    vec3 tri_normal = vec3(cross(v1 - v0, v2 - v1) / vec3(area));
    bool _377 = n.x > n.y;
    bool _385;
    if (_377)
    {
        _385 = n.x > n.z;
    }
    else
    {
        _385 = _377;
    }
    int orientation_index;
    if (_385)
    {
        grid_v0 = grid_v0.yzx;
        grid_v1 = grid_v1.yzx;
        grid_v2 = grid_v2.yzx;
        orientation_index = 0;
    }
    else
    {
        bool _400 = n.y > n.x;
        bool _408;
        if (_400)
        {
            _408 = n.y > n.z;
        }
        else
        {
            _408 = _400;
        }
        if (_408)
        {
            grid_v0 = grid_v0.zxy;
            grid_v1 = grid_v1.zxy;
            grid_v2 = grid_v2.zxy;
            orientation_index = 1;
        }
        else
        {
            grid_v0 = grid_v0;
            grid_v1 = grid_v1;
            grid_v2 = grid_v2;
            orientation_index = 2;
        }
    }
    vTriIndex[0] = vtx_inputs[0].vIdx;
    vTriIndex[1] = vtx_inputs[1].vIdx;
    vTriIndex[2] = vtx_inputs[2].vIdx;
    vTriNormal = vec3(tri_normal);
    gl_PrimitiveID = gl_PrimitiveIDIn + int(first_face_idx);
    vOrientationIndex = orientation_index;
    gl_Position = vec4((grid_v0 * 2.0) - vec3(256.0), 256.0);
    EmitVertex();
    vTriIndex[0] = vtx_inputs[0].vIdx;
    vTriIndex[1] = vtx_inputs[1].vIdx;
    vTriIndex[2] = vtx_inputs[2].vIdx;
    vTriNormal = vec3(tri_normal);
    gl_PrimitiveID = gl_PrimitiveIDIn + int(first_face_idx);
    vOrientationIndex = orientation_index;
    gl_Position = vec4((grid_v1 * 2.0) - vec3(256.0), 256.0);
    EmitVertex();
    vTriIndex[0] = vtx_inputs[0].vIdx;
    vTriIndex[1] = vtx_inputs[1].vIdx;
    vTriIndex[2] = vtx_inputs[2].vIdx;
    vTriNormal = vec3(tri_normal);
    gl_PrimitiveID = gl_PrimitiveIDIn + int(first_face_idx);
    vOrientationIndex = orientation_index;
    gl_Position = vec4((grid_v2 * 2.0) - vec3(256.0), 256.0);
    EmitVertex();
    EndPrimitive();
}

 