
#ifndef VERTEX_MODIFIER_DISPLACE_H
#define VERTEX_MODIFIER_DISPLACE_H

struct VertexModifierDisplaceParams
{
	vec3  displace_normal;
	float displace_normal_modifier_factor;
	vec3  displace_base;
	float displace_base_modifier_factor;

	int   influence_scope;
};

const int VERTEX_MODIFIER_DISPLACE_INFLUENCE_SCOPE_PER_INSTANCE = 0;
const int VERTEX_MODIFIER_DISPLACE_INFLUENCE_SCOPE_GLOBAL       = 1;

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
	// for influence move object to the noise modifier local space
	vec3 modifier_position = vec3(0.0);

	float influence = modifier_factor.factor;
	if (influence != 0.0)
	{
		vec3 n = vtx.norm;
		vec3 p = vtx.pos;

		//if (params.influence_scope == VERTEX_MODIFIER_DISPLACE_INFLUENCE_SCOPE_GLOBAL)
		//	p = vector_transform_by_mat43(p, cs_transforms.mat_local_to_instance);

		p += params.displace_base * params.displace_base_modifier_factor * influence;
		p += n * params.displace_normal * params.displace_normal_modifier_factor * influence;

		vtx.pos = p;
	}
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
	_vertex_modifier_displace_apply(params, modifier_factor, vtx,    cs_transforms);
}

#endif // VERTEX_MODIFIER_DISPLACE_H


