#ifndef COMMONS_DEFERRED_H
#define COMMONS_DEFERRED_H

struct BasicDeferredParams
{
	mat4 mModel;
	mat4 mModelview;
	mat4 mCameraModelview;
	mat4 mProjection;
	vec4 camera_projection_params;
	vec4 camera_near_far_plane;
	vec3 camera_position;
};

struct DispatchDeferredParams
{
	mat4 mat_projection;
	mat4 mat_projection_previous;
	mat4 mat_model;
	mat4 mat_model_previous;
	mat4 mat_view_inverse;		// for reprojection
	mat4 mat_view_previous;

	vec3 camera_position;
	// float _pad0;

	vec4 camera_projection_params;			// these include camera jitter, co pay attention where to use which!
	vec4 camera_projection_params_previous;

	vec4 near_far_plane;
	vec2 resolution;
	vec2 inv_resolution;
	vec2 frustum_shift;
};

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
	vec2 vd_pos = screen_pos - ddp.frustum_shift.xy * ddp.resolution.xy * vec2(0.5, -0.5);
	vec3 view_direction;

	view_direction.x = -ddp.camera_projection_params.z + ddp.camera_projection_params.x * vd_pos.x * ddp.inv_resolution.x;
	view_direction.y = -ddp.camera_projection_params.w + ddp.camera_projection_params.y * vd_pos.y * ddp.inv_resolution.y;
	view_direction.z = 1.0;

	#ifdef SPIRV_VULKAN
	view_direction.y = -view_direction.y;
	#endif

	return view_direction;
}

#endif