#ifndef GPU_HASHMAP_H
#define GPU_HASHMAP_H

#if defined(GPU_HASHMAP_MAIN_SETUP)
#extension GL_EXT_shader_explicit_arithmetic_types_int64: enable
#extension GL_EXT_shader_atomic_int64 : enable
#extension GL_ARB_gpu_shader_int64 : enable
#endif

// include this when creating hashmap buffer in custom code
struct GPUHashMapHeader
{
	uint     capacity;
	uint     _pad0;
	uint     _pad1;
	uint     _pad2;
};

struct GPUHashMapInsertResult
{
	uint slot;
	bool duplicate;
};

struct GPUHashMapLookupResult
{
	uint slot;
	bool found;
};

uint64_t GPUHashMapHash64(uint64_t h)
{
	h ^= h >> 33;
	h *= 0xff51afd7ed558ccdUL;
	h ^= h >> 33;
	h *= 0xc4ceb9fe1a85ec53UL;
	h ^= h >> 33;
	return h;
}

const uint64_t GPUHashMap_EmptyKey64 = (~0UL);

#if defined(GPU_HASHMAP_MAIN_SETUP)
layout (local_size_x = 1, local_size_y = 1) in;

struct GPUHashMapSetupParams
{
	uint capacity;	// needs to be power of two
	uint _pad0;
	uint _pad1;
	uint _pad2;
};

layout (std430) buffer GPUHashMapHeaderBuffer {
	GPUHashMapHeader header;
} gpu_hashmap;

layout (std140) uniform GPUHashMapSetupParamsBuffer {
	uint capacity;	// needs to be power of two
	uint _pad0;
	uint _pad1;
	uint _pad2;
} setup_params;

void GPU_HASHMAP_MAIN_SETUP()
{
	gpu_hashmap.header.capacity = setup_params.capacity;
}
#endif



#endif
