;---"stuck in the currents of time" by Kuemmel
;---"texture generation courtesy of Baze/3SC from famous 256 Byter 'tube'
org 100h
use16

sub al,-(0x13+0x80) ;no screen clear needed and provides valid back buffer   
mov ds,word[si]     ;somewhere a valid address ;-) and using ds saves 4 Bytes in total
int 10h
push 0a000h
pop es

;---"greyscale palette
palette:
  mov dx,0x3c9
  mov ax,cx
  out dx,al
  out dx,al
  ;shr al,1 ;if you want it blueish/cloudish
  out dx,al
loop palette

;---"texture generation by baze
mov dl,127	;for texture init...glitch otherwise
texture:
  mov bx,cx
  add ax,cx
  rol ax,cl
  mov dh,al
  sar dh,5
  adc dl,dh
  adc dl,byte[ds:bx+255]
  shr dl,1
  mov byte[ds:bx],dl
  not bh
  mov byte[ds:bx],dl
loop texture

;---"mainloop
main_loop:
xor di,di
mov ax,-100
y_loop:
  mov cx,-160	
  x_loop:
    pusha  
    sub cx,ax		;d%=xc%-yc%
    jnz skip_inc
      inc cx	    ;prevent div by zero...
    skip_inc:
    mov ah,al		;yc%<<8, don't care about al...hopefully
    cwd		        ;dx:ax    = yc%, clear or sign dx
    idiv cx		    ;dx:ax/cx = yc%/d% 
    add ax,bp		;add timer to x%
    xchg ax,bx		;ty texture address
    mov ah,25		;magic constant   
    cwd 		    ;ax=positive, clear dx
    idiv cx		    ;dx:ax/cx = yc%/d% 
    add ax,bp		;add timer to y% => as it's a high Byte effect in y direction is much slower
    mov bh,al		;ty texture address 
    mov al,byte[ds:bx]	;get texel
    sar cx,1		;need that to prevent overflow anyway...
	jns skip_abs
      neg cx		;cl = abs(depth) => counter flow
    skip_abs:
    mul cl		    ;ax = al*cl ...or range limit ah and no palette...
	shr ax,6
	test al,11000000b
	jz skip_clamp
      mov al,63
	skip_clamp:
	stosb
    popa
	inc di		    ;due to popa...
    inc cx
  cmp cx,160
  jne x_loop
  inc ax
cmp al,100
jne y_loop

;---"vsync => timing
mov dx,3dah	
vsync:
  in al,dx
  test al,8
jz vsync

inc bp ;double speed
inc bp

;---"exit
check_keyboard:
;in al,0x60
;dec al			;ah zero here due to y_loop...
jmp main_loop
;  mov ax,03h
;  int 10h
;ret
