org 100h                       
start:
	mov		al,13h	
	int		10h
	les		cx,[bx]			;es=9FFF, cx=20CD
mainloop:
; --------------------------------------------------------------
; chamberlin state variable filter oscillation with infinite q
; increment: a=2*sin(pi*frequency/samplerate)
; storage  : s,c
; init     : s=amplitude, c=0 (or vice versa)
; update   : s-=a*c
;            c+=a*s
; output   : s=sin, c=cos
; --------------------------------------------------------------
; 8.8 fixedpoint for sin/cos calculation, use smallest a=0x00.01
; cx = cos (init val: 0x20.CD), dx = sin (init val: 0x00.00)
	movsx	ax,ch	
	sub		dx,ax		;s-=a*c	(equals) s-=1*c (equals) s-=c>>8
	movsx	ax,dh
	add		cx,ax		;c+=a*s	(equals) c+=1*s (equals) c+=s>>8
pixelloop:
	mov		ax,di		;interpret di as (x,y)
	add		al,ch		;x+=cos
	add		ah,dh		;y+=sin
	and		al,ah		;pattern from x' and y' (can also be xor)
	and		al,0x38		;color range (change it for other colors)
	stosb				;output
	inc		bx			;next pixel
	jnz		pixelloop	;until bx wraps
	jmp		mainloop	;rotation increment and loop all pixels
