;JetPac #5800
;ZX Spectrum 16/48/128, 256 bytes intro
;code, gfx - .ded^RMDA
;02.06.2021, Russia, Samara

;How to build:

;Use SjASMplus https://github.com/z00m128/sjasmplus
;sjasmplus.exe jp5800.asm

;After build use ZX2 https://github.com/einar-saukas/ZX2
;zx2.exe -y -f jp5800.bin

;Link final .BIN.ZX2 with some code, ZX2 depacker + packed data

;----------------------------------------------------
;	org	#7d00
;	ld	hl,data
;	ld	de,#5800
;	push	de
;	include	"dzx2_nano.asm"	;patch it for -y flag
;data:	incbin	"jp5800.bin.zx2";packed data
;----------------------------------------------------

;Real binary is -1 byte from this source. This is possible via:
;
;1) some additional byte payload to source file (yes, add some!)
;2) barely visible color changes in logo
;3) zx2.exe -y -x
;4) nasty trick with depacker initialization
;
;fell free to understand this magic by yourself via debugger

;53color editor http://53c.verve.space/
;file to HEX http://tomeko.net/online_tools/file_to_hex.php

	DEVICE	ZXSPECTRUM48

	org 	#5800

CodeBegin:

	equ	$

attr53c:
	defb #36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36 
	defb #36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36 
	defb #36,#0D,#0D,#0D,#0D,#36,#0D,#0D,#0D,#0D,#36,#0D,#0D,#0D,#0D,#36 
	defb #0D,#0D,#0D,#0D,#36,#36,#36,#0D,#0D,#0D,#36,#36,#0D,#0D,#0D,#36 
	defb #36,#36,#36,#0D,#0D,#36,#0D,#0D,#36,#36,#36,#36,#0D,#0D,#36,#36 
	defb #0D,#0D,#36,#0D,#0D,#36,#0D,#0D,#36,#0D,#36,#0D,#0D,#36,#36,#36 
	defb #36,#36,#36,#0D,#0D,#36,#0D,#0D,#36,#36,#36,#36,#0D,#0D,#36,#36 
	defb #0D,#0D,#36,#0D,#0D,#36,#0D,#0D,#36,#0D,#36,#0D,#0D,#36,#36,#36 
	defb #36,#36,#36,#17,#17,#36,#17,#17,#17,#17,#36,#36,#17,#17,#36,#36 
	defb #17,#17,#17,#17,#36,#36,#17,#17,#17,#17,#36,#17,#17,#36,#36,#36 
	defb #36,#36,#36,#17,#17,#36,#17,#17,#36,#36,#36,#36,#17,#17,#36,#36 
	defb #17,#17,#36,#36,#36,#36,#17,#17,#36,#17,#36,#17,#17,#36,#36,#36 
	defb #36,#36,#36,#17,#17,#36,#17,#17,#36,#36,#36,#36,#17,#17,#36,#36 
	defb #17,#17,#36,#36,#36,#36,#17,#17,#36,#17,#36,#17,#17,#36,#36,#36 
	defb #36,#17,#17,#17,#36,#36,#17,#17,#17,#17,#36,#36,#17,#17,#36,#36 
	defb #17,#17,#36,#36,#36,#36,#17,#17,#36,#17,#36,#36,#17,#17,#17,#36 
	defb #36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36 
	defb #36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36,#36 
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00 
	defb #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00 
	defb #00,#00,#00,#00,#00,#00,#07,#43,#07,#00,#00,#00,#00,#00,#00,#07 
	defb #00,#00,#00,#00,#00,#00,#07,#07,#00,#00,#00,#00,#00,#00,#00,#00 
	defb #00,#00,#00,#00,#03,#03,#43,#43,#43,#00,#00,#00,#00,#00,#43,#43 
	defb #00,#00,#00,#00,#00,#07,#4F,#4F,#07,#00,#00,#00,#00,#00,#00,#00 
	defb #00,#00,#00,#03,#03,#43,#43,#43,#43,#43,#00,#00,#00,#00,#43,#43 
	defb #00,#00,#00,#00,#00,#07,#4F,#4F,#07,#00,#00,#00,#00,#00,#00,#00 
	defb #52,#52,#52,#52,#52,#52,#52,#52,#52,#52,#52,#52,#52,#52,#52,#52 
	defb #52,#52,#02,#02,#47,#47,#07,#07,#47,#0F,#0F,#00,#00,#00,#00,#00 
	defb #00,#00,#03,#03,#43,#43,#43,#43,#43,#43,#43,#00,#00,#43,#43,#43 
	defb #00,#00,#07,#07,#47,#47,#47,#47,#47,#0F,#0F,#0F,#46,#46,#00,#00 
	defb #00,#03,#03,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #00,#00,#00,#00,#47,#47,#47,#47,#47,#0F,#0F,#0F,#46,#46,#42,#00 
	defb #00,#03,#03,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #43,#00,#00,#00,#00,#47,#47,#47,#00,#0F,#46,#46,#46,#46,#42,#42 
	defb #03,#03,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #43,#43,#00,#00,#47,#47,#47,#47,#00,#00,#46,#46,#46,#46,#42,#42 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #43,#43,#43,#43,#47,#00,#47,#47,#00,#00,#00,#42,#42,#42,#42,#42 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #43,#43,#43,#47,#47,#00,#47,#47,#00,#00,#00,#00,#42,#42,#42,#42 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #43,#43,#43,#43,#43,#47,#47,#00,#00,#00,#00,#00,#00,#42,#42,#42 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#00,#00,#00,#00,#00,#00,#00 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#00,#00,#00 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43 
	defb #43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43,#43

;---patch attr data with some machine code------------
	org	#5a63
	                ;chessboard fill for 53c attrs
	ld	h,#58	;hl = #5800
chess:  dec	hl	
	ld	a,h
	rra
        sbc	a,a
        xor	%01010101
;---patch attr data with some machine code------------
	org	$+24
	                ;texture for JetPac logo
        ld	(hl),a
	cp	(hl)
	jr	z,chess
next:  	ld	h,#47	;hl = #47ff
tv2:	rra
	ld	(hl),a
;---patch attr data with some machine code------------
	org	$+24

	dec	hl
	dec	a	
	bit	6,h
	jr	nz,tv2

	di
;---this machine code is not visible :-( ----
	org	#5b00

	out	(#fe),a ;CYAN border
			;laser beam
beam:	ld	sp,#59a0

	DUP	9
	ex	(sp),hl
	pop	af
	EDUP

	jr	beam
	
CodeEnd:	EQU	$

;	SAVESNA	"jp5800.sna",CodeBegin
	SAVEBIN	"jp5800.bin",CodeBegin,CodeEnd-CodeBegin