#!/bin/bash

export LD_LIBRARY_PATH=lib/

# HACK: Mouse cursor hiding in SDL does not work, regardless if we run under
# native Wayland, XWayland or X11. Probably an SDL bug.
#
# This hack works only under X11 (or XWayland), but that's okay because SDL
# still defaults to X, unless otherwise requested, so it should work on
# compomachine :P
#
# https://askubuntu.com/questions/681269/

CURSOR=$(cat <<'EOF'
#define blank_width 1
#define blank_height 1
#define blank_x_hot 0
#define blank_y_hot 0
static unsigned char blank_bits[] = {
    0x00 };
EOF
)

echo "$CURSOR" > /tmp/blank-cursor

xsetroot -cursor /tmp/blank-cursor /tmp/blank-cursor

./benefits-of-online-demoparties_1080p60

xsetroot -cursor_name left_ptr

rm -f /tmp/blank-cursor
