#version 330 core

layout (triangles) in;
layout (triangle_strip) out;
layout (max_vertices=4) out;    

uniform mat4 mvp;
uniform mat4 view;
uniform mat4 model;
uniform mat4 projection;

uniform float particleSize = 0.15f;

out vec2 texCoord;
   
void main (void)
{

	
    vec4 vertexPosition = gl_in[0].gl_Position;
	
	vertexPosition = mvp*vertexPosition;
	
    vec4 coord = vertexPosition + vec4(-0.5f, -0.5f, 0.0 ,0.0 ) * (particleSize*vertexPosition.z);
    gl_Position = coord;
    texCoord = vec2(0.0f, 0.0f);
    EmitVertex();

    coord = vertexPosition + vec4(-0.5f, 0.5f, 0.0,0.0 ) * (particleSize*vertexPosition.z);
	gl_Position = coord;
    texCoord = vec2(0.0f, 1.0f);
    EmitVertex();

    coord = vertexPosition + vec4(0.5f, -0.5f, 0.0,0.0 ) * (particleSize*vertexPosition.z);
	gl_Position = coord;
    texCoord = vec2(1.0f, 0.0f);
    EmitVertex();

    coord = vertexPosition + vec4(0.5f, 0.5f, 0.0,0.0 ) * (particleSize*vertexPosition.z);
	gl_Position = coord;
    texCoord = vec2(1.0f, 1.0f);
    EmitVertex();

    EndPrimitive();
}